/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.tableProvider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.aas.Entity;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.Operation;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;
import org.eclipse.papyrus.uml.nattable.manager.cell.StereotypePropertyCellManager;
import org.eclipse.papyrus.uml.types.core.requests.SetStereotypeValueRequest;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SemanticIdReferenceCellManager
extends StereotypePropertyCellManager {
    private static final String BOM_TABLE_TYPE = "BOMTableType";
    private static final String PROPERTY_TABLE_TYPE = "PropertiesTableType";
    private static final String OPERATION_TABLE_TYPE = "OperationsTableType";
    private static final String SEMENTICID = "semanticId";

    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        boolean res = super.handles(columnElement, rowElement, tableManager);
        if (res) {
            List umlObjects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
            res = umlObjects.get(1) instanceof String && ((String)umlObjects.get(1)).endsWith(SEMENTICID);
        }
        return res;
    }

    protected Object doGetValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        Object res = super.doGetValue(columnElement, rowElement, tableManager);
        return res;
    }

    public Command getSetStringValueCommand(final TransactionalEditingDomain domain, Object columnElement, final Object rowElement, final String newValue, AbstractStringValueConverter valueSolver, final INattableModelManager tableManager) {
        CompositeCommand cc = new CompositeCommand("SemanticId ref command");
        final Model model = ((Element)rowElement).getModel();
        IElementType semanticidRef = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Reference");
        final CreateElementRequest request1 = new CreateElementRequest(domain, (EObject)model, semanticidRef);
        IElementEditService provider1 = ElementEditServiceUtils.getCommandProvider((EObject)model);
        ICommand command1 = provider1.getEditCommand((IEditCommandRequest)request1);
        cc.add((IUndoableOperation)command1);
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, "Set Key and reference in property", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult result = CommandResult.newOKCommandResult();
                Class reference = (Class)request1.getNewElement();
                IElementType key1 = ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.aAS.Key");
                CreateElementRequest request2 = new CreateElementRequest(domain, (EObject)reference, key1);
                IElementEditService provider2 = ElementEditServiceUtils.getCommandProvider((EObject)model);
                ICommand command2 = provider2.getEditCommand((IEditCommandRequest)request2);
                command2.execute((IProgressMonitor)new NullProgressMonitor(), null);
                Class key = (Class)request2.getNewElement();
                if (reference == null || key == null) {
                    result = CommandResult.newErrorCommandResult((String)"We can't set the value");
                } else {
                    Reference steAppli = (Reference)UMLUtil.getStereotypeApplication((Element)reference, Reference.class);
                    Stereotype referenceStereotype = UMLUtil.getStereotype((EObject)steAppli);
                    Key keysteAppli = (Key)UMLUtil.getStereotypeApplication((Element)key, Key.class);
                    SetStereotypeValueRequest request = new SetStereotypeValueRequest(domain, referenceStereotype, (Element)reference, "key", Collections.singletonList(keysteAppli));
                    IElementEditService provider3 = ElementEditServiceUtils.getCommandProvider((EObject)reference);
                    ICommand command3 = provider3.getEditCommand((IEditCommandRequest)request);
                    command3.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    keysteAppli.setValue(newValue);
                    String tableType = tableManager.getTable().getTableConfiguration().getType();
                    if (tableType.equals(SemanticIdReferenceCellManager.BOM_TABLE_TYPE)) {
                        Entity ModelProp = (Entity)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Entity.class);
                        Stereotype propertyStereotype = UMLUtil.getStereotype((EObject)ModelProp);
                        Reference ste2Appli = (Reference)UMLUtil.getStereotypeApplication((Element)reference, Reference.class);
                        SetStereotypeValueRequest request12 = new SetStereotypeValueRequest(domain, propertyStereotype, (Element)rowElement, SemanticIdReferenceCellManager.SEMENTICID, (Object)ste2Appli);
                        IElementEditService provider4 = ElementEditServiceUtils.getCommandProvider((EObject)reference);
                        ICommand command4 = provider4.getEditCommand((IEditCommandRequest)request12);
                        command4.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    } else if (tableType.equals(SemanticIdReferenceCellManager.OPERATION_TABLE_TYPE)) {
                        Operation ModelProp = (Operation)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Operation.class);
                        Stereotype propertyStereotype = UMLUtil.getStereotype((EObject)ModelProp);
                        Reference ste2Appli = (Reference)UMLUtil.getStereotypeApplication((Element)reference, Reference.class);
                        SetStereotypeValueRequest request13 = new SetStereotypeValueRequest(domain, propertyStereotype, (Element)rowElement, SemanticIdReferenceCellManager.SEMENTICID, (Object)ste2Appli);
                        IElementEditService provider4 = ElementEditServiceUtils.getCommandProvider((EObject)reference);
                        ICommand command4 = provider4.getEditCommand((IEditCommandRequest)request13);
                        command4.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    } else if (tableType.equals(SemanticIdReferenceCellManager.PROPERTY_TABLE_TYPE)) {
                        Property ModelProp = (Property)UMLUtil.getStereotypeApplication((Element)((Element)rowElement), Property.class);
                        Stereotype propertyStereotype = UMLUtil.getStereotype((EObject)ModelProp);
                        Reference ste2Appli = (Reference)UMLUtil.getStereotypeApplication((Element)reference, Reference.class);
                        SetStereotypeValueRequest request14 = new SetStereotypeValueRequest(domain, propertyStereotype, (Element)rowElement, SemanticIdReferenceCellManager.SEMENTICID, (Object)ste2Appli);
                        IElementEditService provider4 = ElementEditServiceUtils.getCommandProvider((EObject)reference);
                        ICommand command4 = provider4.getEditCommand((IEditCommandRequest)request14);
                        command4.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                }
                return result;
            }
        };
        cc.add((IUndoableOperation)cmd);
        return GMFtoEMFCommandWrapper.wrap((ICommand)cc);
    }

    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<java.lang.Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        return super.getOrCreateStringValueConverterClass(existingConverters, multiValueSeparator, tableManager);
    }
}

