/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.editors;

import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.papyrus.aas.tables.configurations.editors.KeyUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Type;

public class KeyComboBoxDataProvider
implements IComboBoxDataProvider {
    protected final Table table;
    protected final Comparator<? super Type> comparator;

    public KeyComboBoxDataProvider(Table table, IDisplayConverter converter) {
        this.table = table;
        this.comparator = new TypeComparator(converter);
    }

    public List<?> getValues(int columnIndex, int rowIndex) {
        List<Type> types = KeyUtils.getAllTypes((Element)this.table.getContext());
        types.sort(this.comparator);
        return types;
    }

    private final class TypeComparator
    implements Comparator<Type> {
        private IDisplayConverter converter;

        private TypeComparator(IDisplayConverter converter) {
            this.converter = converter;
        }

        @Override
        public int compare(Type o1, Type o2) {
            String name1 = this.converter.canonicalToDisplayValue((Object)o1).toString();
            String name2 = this.converter.canonicalToDisplayValue((Object)o2).toString();
            return name1.compareTo(name2);
        }
    }
}

