/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelingKind implements Enumerator
{
    TEMPLATE(0, "Template", "Template"),
    INSTANCE(1, "Instance", "Instance");

    public static final int TEMPLATE_VALUE = 0;
    public static final int INSTANCE_VALUE = 1;
    private static final ModelingKind[] VALUES_ARRAY;
    public static final List<ModelingKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelingKind[]{TEMPLATE, INSTANCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelingKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelingKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelingKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelingKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelingKind get(int value) {
        switch (value) {
            case 0: {
                return TEMPLATE;
            }
            case 1: {
                return INSTANCE;
            }
        }
        return null;
    }

    private ModelingKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

