/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LevelType implements Enumerator
{
    MIN(0, "Min", "Min"),
    MAX(1, "Max", "Max"),
    NOM(2, "Nom", "Nom"),
    TYP(3, "Typ", "Typ");

    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 1;
    public static final int NOM_VALUE = 2;
    public static final int TYP_VALUE = 3;
    private static final LevelType[] VALUES_ARRAY;
    public static final List<LevelType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LevelType[]{MIN, MAX, NOM, TYP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LevelType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LevelType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LevelType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LevelType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LevelType get(int value) {
        switch (value) {
            case 0: {
                return MIN;
            }
            case 1: {
                return MAX;
            }
            case 2: {
                return NOM;
            }
            case 3: {
                return TYP;
            }
        }
        return null;
    }

    private LevelType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

