/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.api.submodel.submodelelement.dataelement;

import io.adminshell.aas.v3.model.LangString;
import io.adminshell.aas.v3.model.ModelingKind;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.impl.DefaultMultiLanguageProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aas.api.reference.IReference;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLanguageProperty
extends DefaultMultiLanguageProperty {
    private static final Logger logger = LoggerFactory.getLogger(MultiLanguageProperty.class);
    private List<LangString> multipleLangs = new ArrayList<LangString>();
    private IReference semanticId;
    private ConceptDescription conceptDesc;
    private SubModelElementCollection parentSEC;
    private SubModel parentSub;

    public MultiLanguageProperty() {
        this.kind = ModelingKind.INSTANCE;
        logger.info("MultiLanguageProperty Initialised with no IdShort");
    }

    public MultiLanguageProperty(String idShort) {
        super.setIdShort(idShort);
        this.kind = ModelingKind.INSTANCE;
        logger.info("MultiLanguageProperty Initialised with IdShort: " + idShort);
    }

    @Deprecated
    public void setSemanticId(Reference ref) {
        super.setSemanticId(ref);
    }

    public void setSemanticIdentifier(IReference ref) {
        this.semanticId = ref;
    }

    public void setSemanticDescription(ConceptDescription concept) {
        this.conceptDesc = concept;
    }

    @Deprecated
    public Reference getSemanticId() {
        return super.getSemanticId();
    }

    public IReference getSemanticIdentifier() {
        return this.semanticId;
    }

    public ConceptDescription getSemanticDescription() {
        return this.conceptDesc;
    }

    public void setValue(String langCode, String value) {
        LangString val = new LangString(value, langCode);
        this.multipleLangs.add(val);
        super.setValues(this.multipleLangs);
    }

    public void setParent(SubModelElementCollection parent) {
        this.parentSEC = parent;
    }

    public void setParent(SubModel parent) {
        this.parentSub = parent;
    }

    public SubModelElementCollection getParentSEC() {
        return this.parentSEC;
    }

    public SubModel getParentSub() {
        return this.parentSub;
    }
}

