/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact;

import org.eclipse.papyrus.iotml.hybrid.PhysicalEntity;

import org.eclipse.uml2.uml.InstanceSpecification;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Virtual Entity</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhisicalEntitySpecification <em>Phisical Entity Specification</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhysicalEntity <em>Physical Entity</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage#getVirtualEntity()
 * @model
 * @generated
 */
public interface VirtualEntity extends DigitalArtefact {
	/**
	 * Returns the value of the '<em><b>Phisical Entity Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Phisical Entity Specification</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Phisical Entity Specification</em>' reference.
	 * @see #setPhisicalEntitySpecification(InstanceSpecification)
	 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage#getVirtualEntity_PhisicalEntitySpecification()
	 * @model ordered="false"
	 * @generated
	 */
	InstanceSpecification getPhisicalEntitySpecification();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhisicalEntitySpecification <em>Phisical Entity Specification</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Phisical Entity Specification</em>' reference.
	 * @see #getPhisicalEntitySpecification()
	 * @generated
	 */
	void setPhisicalEntitySpecification(InstanceSpecification value);

	/**
	 * Returns the value of the '<em><b>Physical Entity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Physical Entity</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Physical Entity</em>' reference.
	 * @see #setPhysicalEntity(PhysicalEntity)
	 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage#getVirtualEntity_PhysicalEntity()
	 * @model ordered="false"
	 * @generated
	 */
	PhysicalEntity getPhysicalEntity();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.software.artefact.VirtualEntity#getPhysicalEntity <em>Physical Entity</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Physical Entity</em>' reference.
	 * @see #getPhysicalEntity()
	 * @generated
	 */
	void setPhysicalEntity(PhysicalEntity value);

} // VirtualEntity
