/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hybrid.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.MARTE.MARTEPackage;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwGeneral.HwGeneralPackage;

import org.eclipse.papyrus.MARTE_Library.BasicNFP_Types.BasicNFP_TypesPackage;

import org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes.GRM_BasicTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_DataTypes.MARTE_DataTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_PrimitivesTypes.MARTE_PrimitivesTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.MeasurementUnitsPackage;

import org.eclipse.papyrus.MARTE_Library.RS_Library.RS_LibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary.TimeTypesLibraryPackage;

import org.eclipse.papyrus.iotml.IoTMLPackage;

import org.eclipse.papyrus.iotml.animate.AnimatePackage;

import org.eclipse.papyrus.iotml.animate.impl.AnimatePackageImpl;

import org.eclipse.papyrus.iotml.hardware.HardwarePackage;

import org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage;

import org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl;

import org.eclipse.papyrus.iotml.hardware.core.CorePackage;

import org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl;

import org.eclipse.papyrus.iotml.hardware.impl.HardwarePackageImpl;

import org.eclipse.papyrus.iotml.hardware.network.NetworkPackage;

import org.eclipse.papyrus.iotml.hardware.network.impl.NetworkPackageImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

import org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl;

import org.eclipse.papyrus.iotml.hybrid.HybridFactory;
import org.eclipse.papyrus.iotml.hybrid.HybridPackage;
import org.eclipse.papyrus.iotml.hybrid.PhysicalEntity;

import org.eclipse.papyrus.iotml.impl.IoTMLPackageImpl;

import org.eclipse.papyrus.iotml.software.SoftwarePackage;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;

import org.eclipse.papyrus.iotml.software.artefact.impl.ArtefactPackageImpl;

import org.eclipse.papyrus.iotml.software.core.structure.StructurePackage;

import org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl;

import org.eclipse.papyrus.iotml.software.impl.SoftwarePackageImpl;
import org.eclipse.papyrus.iotml.software.resource.ResourcePackage;

import org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl;

import org.eclipse.papyrus.sysml14.sysmlPackage;

import org.eclipse.uml2.types.TypesPackage;

import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HybridPackageImpl extends EPackageImpl implements HybridPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass physicalEntityEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.iotml.hybrid.HybridPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private HybridPackageImpl() {
		super(eNS_URI, HybridFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link HybridPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static HybridPackage init() {
		if (isInited) return (HybridPackage)EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI);

		// Obtain or create and register package
		HybridPackageImpl theHybridPackage = (HybridPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof HybridPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new HybridPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		MARTEPackage.eINSTANCE.eClass();
		MARTE_PrimitivesTypesPackage.eINSTANCE.eClass();
		MeasurementUnitsPackage.eINSTANCE.eClass();
		GRM_BasicTypesPackage.eINSTANCE.eClass();
		BasicNFP_TypesPackage.eINSTANCE.eClass();
		MARTE_DataTypesPackage.eINSTANCE.eClass();
		TimeTypesLibraryPackage.eINSTANCE.eClass();
		TimeLibraryPackage.eINSTANCE.eClass();
		RS_LibraryPackage.eINSTANCE.eClass();
		sysmlPackage.eINSTANCE.eClass();
		TypesPackage.eINSTANCE.eClass();
		UMLPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		IoTMLPackageImpl theIoTMLPackage = (IoTMLPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) instanceof IoTMLPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) : IoTMLPackage.eINSTANCE);
		AnimatePackageImpl theAnimatePackage = (AnimatePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) instanceof AnimatePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) : AnimatePackage.eINSTANCE);
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) : HardwarePackage.eINSTANCE);
		ActuatorPackageImpl theActuatorPackage = (ActuatorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) instanceof ActuatorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) : ActuatorPackage.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) : SensorPackage.eINSTANCE);
		NetworkPackageImpl theNetworkPackage = (NetworkPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) instanceof NetworkPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) : NetworkPackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		SoftwarePackageImpl theSoftwarePackage = (SoftwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) instanceof SoftwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) : SoftwarePackage.eINSTANCE);
		ArtefactPackageImpl theArtefactPackage = (ArtefactPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) instanceof ArtefactPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI) : ArtefactPackage.eINSTANCE);
		org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl theCorePackage_1 = (org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) instanceof org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) : org.eclipse.papyrus.iotml.software.core.CorePackage.eINSTANCE);
		StructurePackageImpl theStructurePackage = (StructurePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) instanceof StructurePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) : StructurePackage.eINSTANCE);
		ResourcePackageImpl theResourcePackage = (ResourcePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) instanceof ResourcePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) : ResourcePackage.eINSTANCE);

		// Create package meta-data objects
		theHybridPackage.createPackageContents();
		theIoTMLPackage.createPackageContents();
		theAnimatePackage.createPackageContents();
		theHardwarePackage.createPackageContents();
		theActuatorPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theNetworkPackage.createPackageContents();
		theCorePackage.createPackageContents();
		theSoftwarePackage.createPackageContents();
		theArtefactPackage.createPackageContents();
		theCorePackage_1.createPackageContents();
		theStructurePackage.createPackageContents();
		theResourcePackage.createPackageContents();

		// Initialize created meta-data
		theHybridPackage.initializePackageContents();
		theIoTMLPackage.initializePackageContents();
		theAnimatePackage.initializePackageContents();
		theHardwarePackage.initializePackageContents();
		theActuatorPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theNetworkPackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theSoftwarePackage.initializePackageContents();
		theArtefactPackage.initializePackageContents();
		theCorePackage_1.initializePackageContents();
		theStructurePackage.initializePackageContents();
		theResourcePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theHybridPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(HybridPackage.eNS_URI, theHybridPackage);
		return theHybridPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPhysicalEntity() {
		return physicalEntityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HybridFactory getHybridFactory() {
		return (HybridFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		physicalEntityEClass = createEClass(PHYSICAL_ENTITY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		HwGeneralPackage theHwGeneralPackage = (HwGeneralPackage)EPackage.Registry.INSTANCE.getEPackage(HwGeneralPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		physicalEntityEClass.getESuperTypes().add(theHwGeneralPackage.getHwResource());

		// Initialize classes and features; add operations and parameters
		initEClass(physicalEntityEClass, PhysicalEntity.class, "PhysicalEntity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML";	
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "originalName", "Hybrid"
		   });
	}

} //HybridPackageImpl
