/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.sensor.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.impl.HWSensorImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.HwCommonSensor;
import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

import org.eclipse.papyrus.sysml14.blocks.ValueType;

import org.eclipse.uml2.uml.Behavior;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Hw Common Sensor</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl#getInputValueType <em>Input Value Type</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl#getOutputValueType <em>Output Value Type</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl#getHwcommonsensor <em>Hwcommonsensor</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.sensor.impl.HwCommonSensorImpl#getTransferFunction <em>Transfer Function</em>}</li>
 * </ul>
 *
 * @generated
 */
public class HwCommonSensorImpl extends HWSensorImpl implements HwCommonSensor {
	/**
	 * The cached value of the '{@link #getInputValueType() <em>Input Value Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInputValueType()
	 * @generated
	 * @ordered
	 */
	protected ValueType inputValueType;

	/**
	 * The cached value of the '{@link #getOutputValueType() <em>Output Value Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOutputValueType()
	 * @generated
	 * @ordered
	 */
	protected ValueType outputValueType;

	/**
	 * The cached value of the '{@link #getHwcommonsensor() <em>Hwcommonsensor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHwcommonsensor()
	 * @generated
	 * @ordered
	 */
	protected HwCommonSensor hwcommonsensor;

	/**
	 * The cached value of the '{@link #getTransferFunction() <em>Transfer Function</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTransferFunction()
	 * @generated
	 * @ordered
	 */
	protected Behavior transferFunction;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HwCommonSensorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return SensorPackage.Literals.HW_COMMON_SENSOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueType getInputValueType() {
		if (inputValueType != null && inputValueType.eIsProxy()) {
			InternalEObject oldInputValueType = (InternalEObject)inputValueType;
			inputValueType = (ValueType)eResolveProxy(oldInputValueType);
			if (inputValueType != oldInputValueType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE, oldInputValueType, inputValueType));
			}
		}
		return inputValueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueType basicGetInputValueType() {
		return inputValueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInputValueType(ValueType newInputValueType) {
		ValueType oldInputValueType = inputValueType;
		inputValueType = newInputValueType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE, oldInputValueType, inputValueType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueType getOutputValueType() {
		if (outputValueType != null && outputValueType.eIsProxy()) {
			InternalEObject oldOutputValueType = (InternalEObject)outputValueType;
			outputValueType = (ValueType)eResolveProxy(oldOutputValueType);
			if (outputValueType != oldOutputValueType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE, oldOutputValueType, outputValueType));
			}
		}
		return outputValueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ValueType basicGetOutputValueType() {
		return outputValueType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOutputValueType(ValueType newOutputValueType) {
		ValueType oldOutputValueType = outputValueType;
		outputValueType = newOutputValueType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE, oldOutputValueType, outputValueType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HwCommonSensor getHwcommonsensor() {
		if (hwcommonsensor != null && hwcommonsensor.eIsProxy()) {
			InternalEObject oldHwcommonsensor = (InternalEObject)hwcommonsensor;
			hwcommonsensor = (HwCommonSensor)eResolveProxy(oldHwcommonsensor);
			if (hwcommonsensor != oldHwcommonsensor) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR, oldHwcommonsensor, hwcommonsensor));
			}
		}
		return hwcommonsensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HwCommonSensor basicGetHwcommonsensor() {
		return hwcommonsensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHwcommonsensor(HwCommonSensor newHwcommonsensor) {
		HwCommonSensor oldHwcommonsensor = hwcommonsensor;
		hwcommonsensor = newHwcommonsensor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR, oldHwcommonsensor, hwcommonsensor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Behavior getTransferFunction() {
		if (transferFunction != null && transferFunction.eIsProxy()) {
			InternalEObject oldTransferFunction = (InternalEObject)transferFunction;
			transferFunction = (Behavior)eResolveProxy(oldTransferFunction);
			if (transferFunction != oldTransferFunction) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION, oldTransferFunction, transferFunction));
			}
		}
		return transferFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Behavior basicGetTransferFunction() {
		return transferFunction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTransferFunction(Behavior newTransferFunction) {
		Behavior oldTransferFunction = transferFunction;
		transferFunction = newTransferFunction;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION, oldTransferFunction, transferFunction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE:
				if (resolve) return getInputValueType();
				return basicGetInputValueType();
			case SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE:
				if (resolve) return getOutputValueType();
				return basicGetOutputValueType();
			case SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR:
				if (resolve) return getHwcommonsensor();
				return basicGetHwcommonsensor();
			case SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION:
				if (resolve) return getTransferFunction();
				return basicGetTransferFunction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE:
				setInputValueType((ValueType)newValue);
				return;
			case SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE:
				setOutputValueType((ValueType)newValue);
				return;
			case SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR:
				setHwcommonsensor((HwCommonSensor)newValue);
				return;
			case SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION:
				setTransferFunction((Behavior)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE:
				setInputValueType((ValueType)null);
				return;
			case SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE:
				setOutputValueType((ValueType)null);
				return;
			case SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR:
				setHwcommonsensor((HwCommonSensor)null);
				return;
			case SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION:
				setTransferFunction((Behavior)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case SensorPackage.HW_COMMON_SENSOR__INPUT_VALUE_TYPE:
				return inputValueType != null;
			case SensorPackage.HW_COMMON_SENSOR__OUTPUT_VALUE_TYPE:
				return outputValueType != null;
			case SensorPackage.HW_COMMON_SENSOR__HWCOMMONSENSOR:
				return hwcommonsensor != null;
			case SensorPackage.HW_COMMON_SENSOR__TRANSFER_FUNCTION:
				return transferFunction != null;
		}
		return super.eIsSet(featureID);
	}

} //HwCommonSensorImpl
