/*****************************************************************************
 * Copyright (c) 2015 CEA LIST and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   CEA LIST - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrus.sysml14.diagram.parametric.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml14.diagram.parametric.locator.ParameterPositionLocator;
import org.eclipse.papyrus.uml.diagram.common.editparts.AroundBorderItemEditPart;


/**
 * this a the editpart for Parameter that constraints the path of the border item to be internal.
 */
public class ParameterBorderItermEditPart extends AroundBorderItemEditPart {

	/**
	 * Constructor.
	 *
	 * @param view
	 */
	public ParameterBorderItermEditPart(View view) {
		super(view);
	}

	@Override
	public IBorderItemLocator getNewBorderItemLocator(IFigure mainFigure) {
		return new ParameterPositionLocator(mainFigure);
	}
	
}
