/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.papyrus.sysml14.modelelements.Conform;
import org.eclipse.papyrus.sysml14.modelelements.Stakeholder;
import org.eclipse.papyrus.sysml14.modelelements.View;
import org.eclipse.papyrus.sysml14.modelelements.Viewpoint;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Operation;

public class SysMLXMIIDHelper {
    private static final String BASE_CLASS = "baseClass";
    private static final String BASE_CLASSIFIER = "baseClassifier";
    private static final String BASE_GENERALIZATION = "baseGeneralization";
    private static final String COMMENT = "comment";
    private static final String CONCERNLIST = "concernList_";
    private static final String CREATEOPERATION = "createOperation";
    private static final String STAKEHOLDER = "stakeholder";
    private static final String OF = "_Of_";

    public static void calculateMoreNeededId(XMIResource res, Object current, String currentId, Map<EObject, String> oldIds) {
        if (current instanceof View) {
            SysMLXMIIDHelper.calculateBaseClassViewId(res, (View)current, currentId, oldIds);
        } else if (current instanceof Conform) {
            SysMLXMIIDHelper.calculateBaseGeneralizationConformId(res, (Conform)current, currentId, oldIds);
        } else if (current instanceof Viewpoint) {
            SysMLXMIIDHelper.calculateOthersViewPointId(res, (Viewpoint)current, currentId, oldIds);
        }
    }

    public static void calculateBaseClassViewId(XMIResource res, View view, String currentId, Map<EObject, String> oldIds) {
        Object basePackage;
        String basePackageId = null;
        Class basedClass = view.getBase_Class();
        EStructuralFeature basePackageFeature = null;
        Iterator features = view.eClass().getEAllStructuralFeatures().iterator();
        while (features.hasNext() && basePackageFeature == null) {
            EStructuralFeature feature = (EStructuralFeature)features.next();
            if (!feature.getName().equals("base_Package")) continue;
            basePackageFeature = feature;
        }
        if (basePackageFeature != null && (basePackage = view.eGet(basePackageFeature)) instanceof Package && oldIds.containsKey(basePackage)) {
            basePackageId = oldIds.get(basePackage);
        }
        if (basePackageId != null) {
            res.setID((EObject)basedClass, basePackageId);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(BASE_CLASS);
            stringBuilder.append(OF);
            stringBuilder.append(currentId);
            res.setID((EObject)basedClass, stringBuilder.toString());
            oldIds.put((EObject)basedClass, stringBuilder.toString());
        }
    }

    public static void calculateBaseGeneralizationConformId(XMIResource res, Conform conform, String currentId, Map<EObject, String> oldIds) {
        Object baseDependency;
        String basePackageId = null;
        Generalization basedGeneralization = conform.getBase_Generalization();
        EStructuralFeature baseDependencyFeature = null;
        Iterator features = conform.eClass().getEAllStructuralFeatures().iterator();
        while (features.hasNext() && baseDependencyFeature == null) {
            EStructuralFeature feature = (EStructuralFeature)features.next();
            if (!feature.getName().equals("base_Dependency")) continue;
            baseDependencyFeature = feature;
        }
        if (baseDependencyFeature != null && (baseDependency = conform.eGet(baseDependencyFeature)) instanceof Dependency && oldIds.containsKey(baseDependency)) {
            basePackageId = oldIds.get(baseDependency);
        }
        if (basePackageId != null) {
            res.setID((EObject)basedGeneralization, basePackageId);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(BASE_GENERALIZATION);
            stringBuilder.append(OF);
            stringBuilder.append(currentId);
            res.setID((EObject)basedGeneralization, stringBuilder.toString());
            oldIds.put((EObject)basedGeneralization, stringBuilder.toString());
        }
    }

    public static void calculateOthersViewPointId(XMIResource res, Viewpoint viewpoint, String currentId, Map<EObject, String> oldIds) {
        Class basedClass = viewpoint.getBase_Class();
        int concernListIndex = 1;
        for (Comment comment : viewpoint.getConcernList()) {
            if (oldIds.containsKey(comment)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CONCERNLIST);
            stringBuilder.append(concernListIndex);
            stringBuilder.append(OF);
            stringBuilder.append(currentId);
            res.setID((EObject)comment, stringBuilder.toString());
            oldIds.put((EObject)comment, stringBuilder.toString());
            ++concernListIndex;
        }
        Iterator operations = basedClass.getOperations().iterator();
        boolean foundCreate = false;
        while (operations.hasNext() && !foundCreate) {
            Operation operation = (Operation)operations.next();
            if (UMLUtil.getAppliedStereotype((Element)operation, (String)"StandardProfile::Create", (boolean)false) == null || oldIds.containsKey(operation)) continue;
            foundCreate = true;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CREATEOPERATION);
            stringBuilder.append(OF);
            stringBuilder.append(currentId);
            res.setID((EObject)operation, stringBuilder.toString());
            oldIds.put((EObject)operation, stringBuilder.toString());
            if (operation.getOwnedComments().size() != 1) continue;
            Comment comment = (Comment)operation.getOwnedComments().get(0);
            StringBuilder commentStringBuilder = new StringBuilder();
            commentStringBuilder.append(COMMENT);
            commentStringBuilder.append(OF);
            commentStringBuilder.append((CharSequence)stringBuilder);
            res.setID((EObject)comment, commentStringBuilder.toString());
            oldIds.put((EObject)comment, commentStringBuilder.toString());
        }
        int stakeholderIndex = 1;
        ArrayList stakeholders = new ArrayList(viewpoint.getStakeholder());
        Collections.sort(stakeholders, new Comparator<Stakeholder>(){

            @Override
            public int compare(Stakeholder stakeholder1, Stakeholder stakeholder2) {
                return stakeholder1.getBase_Classifier().getName().compareTo(stakeholder2.getBase_Classifier().getName());
            }
        });
        for (Stakeholder stakeholder : stakeholders) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(STAKEHOLDER);
            stringBuilder.append(stakeholderIndex);
            stringBuilder.append(OF);
            stringBuilder.append(currentId);
            res.setID((EObject)stakeholder, stringBuilder.toString());
            oldIds.put((EObject)stakeholder, stringBuilder.toString());
            Classifier nestedClassifier = stakeholder.getBase_Classifier();
            StringBuilder otherStringBuilder = new StringBuilder();
            otherStringBuilder.append(BASE_CLASSIFIER);
            otherStringBuilder.append(OF);
            otherStringBuilder.append((CharSequence)stringBuilder);
            res.setID((EObject)nestedClassifier, otherStringBuilder.toString());
            oldIds.put((EObject)nestedClassifier, otherStringBuilder.toString());
            ++stakeholderIndex;
        }
    }

    public static boolean isStereotypedElementCreated(EObject current) {
        return false;
    }

    public static void calculateCreateStereotypedElement(XMIResource res, EObject current) {
    }
}

