/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper.NotationXMIIDHelper;
import org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper.SysMLXMIIDHelper;
import org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper.UMLXMIIDHelper;
import org.eclipse.papyrus.uml.m2m.qvto.common.utils.TraceHelper;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PreserveXMIIDHelper {
    private Context context;
    private TraceHelper helper = new TraceHelper();

    public PreserveXMIIDHelper(Context context) {
        this.context = context;
    }

    public void keepIdForUMLResource(XMIResource res, Map<EObject, String> oldIds) {
        HashSet<EObject> eObjectForSecondRun = new HashSet<EObject>();
        TreeIterator iter = res.getAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            if (this.isStereotypeApplication(current)) {
                Object result = this.helper.traceFrom((IContext)this.context, (Object)current, null);
                if (oldIds.containsKey(result)) {
                    String oldId = oldIds.get(result);
                    res.setID(current, oldId);
                    SysMLXMIIDHelper.calculateMoreNeededId(res, current, oldId, oldIds);
                    continue;
                }
                eObjectForSecondRun.add(current);
                continue;
            }
            UMLXMIIDHelper.calculateNeededId(res, current, oldIds);
        }
        for (EObject current : eObjectForSecondRun) {
            if (oldIds.containsKey(current)) continue;
            if (SysMLXMIIDHelper.isStereotypedElementCreated(current)) {
                SysMLXMIIDHelper.calculateCreateStereotypedElement(res, current);
                continue;
            }
            if (UMLXMIIDHelper.isStereotypedElementCreated(current)) {
                UMLXMIIDHelper.calculateCreateStereotypedElement(res, current);
                continue;
            }
            System.out.println("It is not possible to found an id for " + current.toString());
        }
    }

    public void keepIdForNotationResource(XMIResource res, Map<EObject, String> oldIds) {
        TreeIterator iter = res.getAllContents();
        while (iter.hasNext()) {
            EObject current = (EObject)iter.next();
            NotationXMIIDHelper.calculateNeededId(res, current, oldIds);
        }
    }

    protected boolean isStereotypeApplication(EObject eobject) {
        return UMLUtil.getBaseElement((EObject)eobject) != null;
    }
}

