/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.sysml14.sysml.xmi.helper;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class NotationXMIIDHelper {
    private static final String DIAGRAM_COMPATIBILITY_VERSION = "diagram_compatibility_version";
    private static final String BENDPOINTS = "bendpoints";
    private static final String BOUNDS = "bounds";
    private static final String CONNECTOR = "connector";
    private static final String IDENTITY_ANCHOR = "identityAnchor";
    private static final String LOCATION = "location";
    private static final String PAPYRUS_VIEW_STYLE = "papyrusViewStyle";
    private static final String SHAPE = "shape";
    private static final String FROM = "_from_";
    private static final String OF = "_Of_";
    private static final String TO = "_to_";
    private static final String UNDERSCORE = "_";

    public static void calculateNeededId(XMIResource res, Object current, Map<EObject, String> oldIds) {
        if (current instanceof DecorationNode) {
            NotationXMIIDHelper.calculateDecorationNode(res, (DecorationNode)current, oldIds);
        } else if (current instanceof Diagram) {
            NotationXMIIDHelper.calculateDiagram(res, (Diagram)current, oldIds);
        } else if (current instanceof Style) {
            NotationXMIIDHelper.calculateStyle(res, (Style)current, oldIds);
        } else if (current instanceof Bounds) {
            NotationXMIIDHelper.calculateBounds(res, (Bounds)current, oldIds);
        } else if (current instanceof Location) {
            NotationXMIIDHelper.calculateLocation(res, (Location)current, oldIds);
        } else if (current instanceof EAnnotation) {
            NotationXMIIDHelper.calculateEAnnotation(res, (EAnnotation)current, oldIds);
        } else if (current instanceof Bendpoints) {
            NotationXMIIDHelper.calculateBendpoints(res, (Bendpoints)current, oldIds);
        } else if (current instanceof IdentityAnchor) {
            NotationXMIIDHelper.calculateIdentityAnchor(res, (IdentityAnchor)current, oldIds);
        }
    }

    public static void calculateDecorationNode(XMIResource res, DecorationNode decorationNode, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(decorationNode)) {
            String containerID = ((XMIResource)decorationNode.eContainer().eResource()).getID(decorationNode.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(decorationNode.getType());
            stringBuilder.append(OF);
            stringBuilder.append(containerID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)decorationNode, stringBuilder.toString());
            oldIds.put((EObject)decorationNode, stringBuilder.toString());
        }
    }

    public static void calculateDiagram(XMIResource res, Diagram diagram, Map<EObject, String> oldIds) {
        StringValueStyle compatibilityVersion = null;
        HashSet<PapyrusViewStyle> papyrusViewStyles = new HashSet<PapyrusViewStyle>();
        for (EObject style : diagram.getStyles()) {
            if (style instanceof PapyrusViewStyle) {
                papyrusViewStyles.add((PapyrusViewStyle)style);
                continue;
            }
            if (!(style instanceof StringValueStyle) || !((StringValueStyle)style).getName().equals(DIAGRAM_COMPATIBILITY_VERSION)) continue;
            compatibilityVersion = (StringValueStyle)style;
        }
        String diagramID = ((XMIResource)diagram.eResource()).getID((EObject)diagram);
        if (compatibilityVersion != null && !oldIds.containsKey(compatibilityVersion)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DIAGRAM_COMPATIBILITY_VERSION);
            stringBuilder.append(OF);
            stringBuilder.append(diagramID);
            res.setID((EObject)compatibilityVersion, stringBuilder.toString());
            oldIds.put((EObject)compatibilityVersion, stringBuilder.toString());
        }
        for (PapyrusViewStyle papyrusViewStyle : papyrusViewStyles) {
            if (oldIds.containsKey(papyrusViewStyle)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(PAPYRUS_VIEW_STYLE);
            stringBuilder.append(((XMIResource)papyrusViewStyle.getOwner().eResource()).getID(papyrusViewStyle.getOwner()));
            stringBuilder.append(OF);
            stringBuilder.append(diagramID);
            res.setID((EObject)papyrusViewStyle, stringBuilder.toString());
            oldIds.put((EObject)papyrusViewStyle, stringBuilder.toString());
        }
    }

    public static void calculateStyle(XMIResource res, Style style, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(style)) {
            String containerID = ((XMIResource)style.eContainer().eResource()).getID(style.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(style.eClass().getName());
            stringBuilder.append(OF);
            stringBuilder.append(containerID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)style, stringBuilder.toString());
            oldIds.put((EObject)style, stringBuilder.toString());
        }
    }

    public static void calculateBounds(XMIResource res, Bounds bounds, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(bounds)) {
            String containerID = ((XMIResource)bounds.eContainer().eResource()).getID(bounds.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(BOUNDS);
            stringBuilder.append(OF);
            stringBuilder.append(containerID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)bounds, stringBuilder.toString());
            oldIds.put((EObject)bounds, stringBuilder.toString());
        }
    }

    public static void calculateLocation(XMIResource res, Location location, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(location)) {
            String containerID = ((XMIResource)location.eContainer().eResource()).getID(location.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(LOCATION);
            stringBuilder.append(OF);
            stringBuilder.append(containerID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)location, stringBuilder.toString());
            oldIds.put((EObject)location, stringBuilder.toString());
        }
    }

    public static void calculateEAnnotation(XMIResource res, EAnnotation eAnnotation, Map<EObject, String> oldIds) {
        String containerID = ((XMIResource)eAnnotation.eContainer().eResource()).getID(eAnnotation.eContainer());
        String eAnnotationID = null;
        if (!oldIds.containsKey(eAnnotation)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(eAnnotation.getSource());
            stringBuilder.append(OF);
            stringBuilder.append(containerID);
            eAnnotationID = stringBuilder.toString();
            res.setID((EObject)eAnnotation, eAnnotationID);
            oldIds.put((EObject)eAnnotation, eAnnotationID);
        } else {
            eAnnotationID = oldIds.get(eAnnotation);
        }
        for (Map.Entry detail : eAnnotation.getDetails()) {
            if (oldIds.containsKey(detail) || !(detail instanceof EStringToStringMapEntryImpl)) continue;
            StringBuilder eAnnotationStringBuilder = new StringBuilder();
            eAnnotationStringBuilder.append((String)detail.getKey());
            eAnnotationStringBuilder.append(OF);
            eAnnotationStringBuilder.append(eAnnotationID);
            res.setID((EObject)((EStringToStringMapEntryImpl)detail), eAnnotationStringBuilder.toString());
            oldIds.put((EObject)((EStringToStringMapEntryImpl)detail), eAnnotationStringBuilder.toString());
        }
    }

    public static void calculateShape(XMIResource res, Shape shape, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(shape)) {
            String elementID = ((XMIResource)shape.getElement().eResource()).getID(shape.getElement());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(SHAPE);
            stringBuilder.append(OF);
            stringBuilder.append(elementID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)shape, stringBuilder.toString());
            oldIds.put((EObject)shape, stringBuilder.toString());
        }
    }

    public static void calculateConnector(XMIResource res, Connector connector, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(connector)) {
            String sourceID = ((XMIResource)connector.getSource().eResource()).getID((EObject)connector.getSource());
            String targetID = ((XMIResource)connector.getTarget().eResource()).getID((EObject)connector.getTarget());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(CONNECTOR);
            stringBuilder.append(FROM);
            stringBuilder.append(sourceID);
            stringBuilder.append(TO);
            stringBuilder.append(targetID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)connector, stringBuilder.toString());
            oldIds.put((EObject)connector, stringBuilder.toString());
        }
    }

    public static void calculateBendpoints(XMIResource res, Bendpoints bendpoints, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(bendpoints)) {
            String elementID = ((XMIResource)bendpoints.eContainer().eResource()).getID(bendpoints.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(BENDPOINTS);
            stringBuilder.append(OF);
            stringBuilder.append(elementID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)bendpoints, stringBuilder.toString());
            oldIds.put((EObject)bendpoints, stringBuilder.toString());
        }
    }

    public static void calculateIdentityAnchor(XMIResource res, IdentityAnchor identityAnchor, Map<EObject, String> oldIds) {
        if (!oldIds.containsKey(identityAnchor)) {
            String elementID = ((XMIResource)identityAnchor.eContainer().eResource()).getID(identityAnchor.eContainer());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(IDENTITY_ANCHOR);
            stringBuilder.append(OF);
            stringBuilder.append(elementID);
            stringBuilder = NotationXMIIDHelper.incrementStringBuilder(stringBuilder.toString(), oldIds);
            res.setID((EObject)identityAnchor, stringBuilder.toString());
            oldIds.put((EObject)identityAnchor, stringBuilder.toString());
        }
    }

    protected static StringBuilder incrementStringBuilder(String initialString, Map<EObject, String> oldIds) {
        StringBuilder subStringBuilder = new StringBuilder(initialString);
        boolean idAlreadyExist = oldIds.containsValue(initialString);
        int incremental = 2;
        while (idAlreadyExist) {
            subStringBuilder = new StringBuilder(initialString);
            subStringBuilder.append(UNDERSCORE);
            subStringBuilder.append(incremental);
            if (!oldIds.containsValue(subStringBuilder.toString())) {
                idAlreadyExist = false;
            }
            ++incremental;
        }
        return subStringBuilder;
    }
}

