/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.utils;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.Activator;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocatorUtils;

public class FixPortsLocationOnOpening {
    public void fix(Diagram diagram) {
        TreeIterator it = diagram.eAllContents();
        while (it.hasNext()) {
            Rectangle parentBounds;
            Rectangle validLocation;
            Shape portView;
            String currentType;
            EObject current = (EObject)it.next();
            if (!(current instanceof Shape) || !"shape_sysml_flowport_as_affixed".equals(currentType = (portView = (Shape)current).getType()) && !"shape_uml_port_as_affixed".equals(currentType)) continue;
            int borderItemOffset = 10;
            View parentView = ViewUtil.getViewContainer((EObject)portView);
            if (!(parentView instanceof Shape)) continue;
            Shape parentShape = (Shape)parentView;
            Bounds portViewBounds = (Bounds)portView.getLayoutConstraint();
            Bounds parentViewBounds = (Bounds)parentShape.getLayoutConstraint();
            Rectangle portBounds = new Rectangle(portViewBounds.getX(), portViewBounds.getY(), portViewBounds.getWidth(), portViewBounds.getHeight());
            int parentWidth = parentViewBounds.getWidth();
            int parentHeight = parentViewBounds.getHeight();
            if (parentWidth == -1 && parentHeight == -1) {
                String parentPrefKey = "InternalBlock_" + parentShape.getType();
                parentWidth = Activator.getInstance().getPreferenceStore().getInt(PreferencesConstantsHelper.getElementConstant((String)parentPrefKey, (int)17));
                parentHeight = Activator.getInstance().getPreferenceStore().getInt(PreferencesConstantsHelper.getElementConstant((String)parentPrefKey, (int)16));
            }
            if (portBounds.equals((Object)(validLocation = PortPositionLocatorUtils.getBorderLocation((Rectangle)(parentBounds = new Rectangle(parentViewBounds.getX(), parentViewBounds.getY(), parentWidth, parentHeight)), (Rectangle)portBounds, (int)borderItemOffset))) || parentViewBounds.getWidth() == -1 || parentViewBounds.getHeight() == -1) continue;
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            FixLocationCommand fixCommand = new FixLocationCommand(editingDomain, "Fix Port location on opening", portViewBounds, validLocation);
            editingDomain.getCommandStack().execute((Command)fixCommand);
        }
    }

    public class FixLocationCommand
    extends RecordingCommand {
        private Bounds portViewBounds;
        private Rectangle portValidBounds;

        public FixLocationCommand(TransactionalEditingDomain domain, String label, Bounds portViewBounds, Rectangle portValidBounds) {
            super(domain, label);
            this.portViewBounds = portViewBounds;
            this.portValidBounds = portValidBounds;
        }

        protected void doExecute() {
            this.portViewBounds.setX(this.portValidBounds.x());
            this.portViewBounds.setY(this.portValidBounds.y());
        }

        public boolean canUndo() {
            return false;
        }
    }
}

