/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.Activator;

public class DeletePropertyCommand
extends RecordingCommand
implements Command {
    private Collection<TypeInstance> typeInstances;
    private IEvaluationContext context;

    public DeletePropertyCommand(TransactionalEditingDomain domain, IEvaluationContext context, TypeInstance typeInstance) {
        this(domain, context, Collections.singleton(typeInstance));
    }

    public DeletePropertyCommand(TransactionalEditingDomain domain, IEvaluationContext context, Collection<TypeInstance> typeInstances) {
        super(domain);
        this.typeInstances = typeInstances;
        this.context = context;
    }

    protected void doExecute() {
        CompoundCommand cc = new CompoundCommand("DeleteLayersCommand");
        try {
            LayersStackApplication layerStackApplication = this.lookupLayersStackApplicationChecked(this.context);
            List layerStacks = layerStackApplication.getLayersStacks();
            TopLayerOperator topLayerOperator = null;
            for (LayersStack layerStack : layerStacks) {
                TopLayerOperator topLayerOperator2 = topLayerOperator = layerStack.getLayers() instanceof TopLayerOperator ? (TopLayerOperator)layerStack.getLayers() : null;
                if (topLayerOperator != null && !topLayerOperator.getLayers().isEmpty()) continue;
            }
            if (topLayerOperator == null) {
                return;
            }
            for (LayerExpression layerExpression : topLayerOperator.getLayers()) {
                AbstractLayer layer;
                AbstractLayer abstractLayer = layer = layerExpression instanceof AbstractLayer ? (AbstractLayer)layerExpression : null;
                if (layer == null) {
                    return;
                }
                ArrayList<Property> propertiesToRemove = new ArrayList<Property>();
                for (Property property : layer.getAttachedProperties()) {
                    if (!this.typeInstances.contains(layer.getPropertyInstance(property))) continue;
                    propertiesToRemove.add(property);
                }
                for (Property property : propertiesToRemove) {
                    layer.removePropertyInstance(property);
                }
            }
        }
        catch (NotFoundException e) {
            Activator.log.error("DeletePropertyCommand The LayerStackApplication could not be resolved from the context", (Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error("DeletePropertyCommand The LayerStackApplication could not be resolved from the context", (Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error("DeletePropertyCommand The layer property could not be resolved", (Throwable)e);
        }
        cc.execute();
    }

    protected LayersStackApplication lookupLayersStackApplicationChecked(IEvaluationContext context) throws org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException, ServiceException, NotFoundException {
        ModelSet modelSet = ServiceUtilsForIEvaluationContext.getInstance().getModelSet((Object)context);
        LayersModelResource model = (LayersModelResource)modelSet.getModelChecked("org.eclipse.papyrus.layers.resource.LayersModel");
        return model.lookupLayerStackApplication();
    }
}

