/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Layer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands.AbstractLayersCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.view.LayersExplorerView;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.view.LayersExplorerViewUtils;
import org.eclipse.ui.IEditorPart;

public class RemoveDiagramSelectedItemsFromCurrentLayer
extends AbstractLayersCommand {
    @Override
    public String getCommandName() {
        return "Attach Selected Items";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        Layer currentLayer;
        List<View> diagramSelectedViews;
        try {
            diagramSelectedViews = this.getSelectedViewsFromCurrentDiagramEditor(context);
            currentLayer = this.getSelectedLayerFromLayerExplorer(context);
        }
        catch (NotFoundException e) {
            Activator.log.error("ERROR - " + ((Object)((Object)this)).getClass().getName() + " - " + e.getMessage(), (Throwable)e);
            return;
        }
        currentLayer.getViews().removeAll(diagramSelectedViews);
    }

    private Layer getSelectedLayerFromLayerExplorer(IEvaluationContext context) throws NotFoundException {
        ISelection selection;
        LayersExplorerView layersExplorerView = LayersExplorerViewUtils.findView(context);
        try {
            selection = layersExplorerView.getSite().getSelectionProvider().getSelection();
        }
        catch (NullPointerException e) {
            throw new NotFoundException("Can't get selection object from LayersExplorerView" + e);
        }
        if (!(selection instanceof ITreeSelection)) {
            throw new NotFoundException("No selection in LayersExplorerView");
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        Object firstSelection = treeSelection.getFirstElement();
        if (!(firstSelection instanceof Layer)) {
            throw new NotFoundException("LayersExplorerView first selection should be of type 'Layer'");
        }
        return (Layer)firstSelection;
    }

    private List<View> getSelectedViewsFromCurrentDiagramEditor(IEvaluationContext context) throws NotFoundException {
        DiagramDocumentEditor diagramEditor = this.getNestedActiveDiagramDocumentEditor(context);
        ISelection selection = diagramEditor.getSite().getSelectionProvider().getSelection();
        if (!(selection instanceof IStructuredSelection) && !selection.isEmpty()) {
            return Collections.emptyList();
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        ArrayList<View> result = new ArrayList<View>(structuredSelection.size());
        for (Object obj : structuredSelection.toList()) {
            View view = (View)Platform.getAdapterManager().getAdapter(obj, View.class);
            if (view == null) continue;
            result.add(view);
        }
        return result;
    }

    private DiagramDocumentEditor getNestedActiveDiagramDocumentEditor(IEvaluationContext context) throws NotFoundException {
        IEditorPart editor;
        try {
            editor = ((ISashWindowsContainer)ServiceUtilsForIEvaluationContext.getInstance().getService(ISashWindowsContainer.class, (Object)context)).getActiveEditor();
        }
        catch (ServiceException e) {
            throw new NotFoundException("Selected editor do not provides ServiceRegistry", (Throwable)e);
        }
        if (!(editor instanceof DiagramDocumentEditor)) {
            throw new NotFoundException("Selected editor do not contains Diagram");
        }
        return (DiagramDocumentEditor)editor;
    }
}

