/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands.AbstractLayersCommand;

public abstract class AbstractCreateLayerExpressionHandler
extends AbstractLayersCommand {
    private static int creationCount = 0;

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        Object selection;
        LayersStackApplication application;
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".doExecute()");
        }
        if (!this.isEnabled(context, selections)) {
            return;
        }
        try {
            application = this.lookupLayersStackApplicationChecked(context);
        }
        catch (org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException e) {
            return;
        }
        catch (NotFoundException e) {
            return;
        }
        catch (ServiceException e) {
            return;
        }
        LayerExpression layer = this.createLayer();
        layer.setName("layer" + creationCount++);
        layer.setApplication(application);
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ". layerCreated");
        }
        if ((selection = selections.get(0)) instanceof LayersStack) {
            LayersStack stack = (LayersStack)selection;
            stack.setLayers(layer);
        } else {
            LayerOperator operator = (LayerOperator)selection;
            operator.getLayers().add(layer);
        }
    }

    protected abstract LayerExpression createLayer();

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        if (selections.size() != 1) {
            return false;
        }
        Object first = selections.get(0);
        boolean res = first instanceof LayerOperator || first instanceof LayersStack;
        return res;
    }
}

