/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayerOperatorDescriptorRegistryImpl;

public class CustomLayerOperatorDescriptorRegistryImpl
extends LayerOperatorDescriptorRegistryImpl {
    protected CustomLayerOperatorDescriptorRegistryImpl() {
        this.defaultOperator = LayersFactory.eINSTANCE.createPropertyOperator();
    }

    @Override
    public void setPropertyCollectionSize(int newPropertyCollectionSize) {
        int oldPropertyCollectionSize = this.propertyCollectionSize;
        this.propertyCollectionSize = newPropertyCollectionSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldPropertyCollectionSize, this.propertyCollectionSize));
        }
        if (newPropertyCollectionSize > oldPropertyCollectionSize) {
            for (LayerOperatorDescriptor descriptor : this.getDescriptors()) {
                descriptor.setPropertyCollectionSize(newPropertyCollectionSize, this.getDefaultOperator());
            }
        }
    }

    @Override
    public void addLayerOperatorDescriptor(LayerOperatorDescriptor descriptor) {
        descriptor.setPropertyCollectionSize(this.getPropertyCollectionSize(), this.getDefaultOperator());
        this.getDescriptors().add(descriptor);
    }

    @Override
    public LayerOperatorDescriptor getLayerOperatorDescriptor(String name) throws NotFoundException {
        if (name == null) {
            throw new NotFoundException("Can't find LayerOperatorDescriptor for name 'null'.");
        }
        for (LayerOperatorDescriptor descriptor : this.getDescriptors()) {
            if (!name.equals(descriptor.getName())) continue;
            return descriptor;
        }
        throw new NotFoundException("Can't find LayerOperatorDescriptor for name '" + name + "'.");
    }

    @Override
    public void addPropertyOperator(PropertyOperator operator) {
        this.getPropertyOperators().add(operator);
    }

    @Override
    public PropertyOperator getPropertyOperator(String name) throws NotFoundException {
        if (name == null) {
            throw new NotFoundException("Can't find PropertyOperator for name 'null'.");
        }
        for (PropertyOperator op : this.getPropertyOperators()) {
            if (!name.equals(op.getName())) continue;
            return op;
        }
        throw new NotFoundException("Can't find PropertyOperator for name '" + name + "'.");
    }

    @Override
    public void attachOperatorToDescriptor(Property property, String operatorName, String layerDescriptorName) throws NotFoundException {
        if (this.getPropertyCollectionSize() <= property.getIndex()) {
            this.setPropertyCollectionSize(property.getIndex());
        }
        PropertyOperator op = this.getPropertyOperator(operatorName);
        LayerOperatorDescriptor layerOp = this.getLayerOperatorDescriptor(layerDescriptorName);
        layerOp.setPropertyOperator(property, op);
    }

    @Override
    public LayerOperator createLayerOperator(String layerOperatorID) throws LayersException {
        LayerOperatorDescriptor desc = this.getLayerOperatorDescriptor(layerOperatorID);
        LayerOperator newLayerOperator = desc.createLayerOperator();
        return newLayerOperator;
    }
}

