/**
 * Copyright (c) 2013, 2017 CEA LIST & LIFL 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Cedric Dumoulin  Cedric.dumoulin@lifl.fr - Initial API and implementation
 *   Quentin Le Menez quentin.lemenez@cea.fr
 * 
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.edit.command.CommandParameter;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

import org.eclipse.gmf.runtime.notation.util.NotationSwitch;

import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;

import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.util.LayersAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class LayersItemProviderAdapterFactory extends LayersAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(LayersEditPlugin.INSTANCE, LayersPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LayersItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerNamedStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerNamedStyleItemProvider layerNamedStyleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerNamedStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerNamedStyleAdapter() {
		if (layerNamedStyleItemProvider == null) {
			layerNamedStyleItemProvider = new LayerNamedStyleItemProvider(this);
		}

		return layerNamedStyleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayersStackItemProvider layersStackItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayersStackAdapter() {
		if (layersStackItemProvider == null) {
			layersStackItemProvider = new LayersStackItemProvider(this);
		}

		return layersStackItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayersStackApplicationItemProvider layersStackApplicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayersStackApplicationAdapter() {
		if (layersStackApplicationItemProvider == null) {
			layersStackApplicationItemProvider = new LayersStackApplicationItemProvider(this);
		}

		return layersStackApplicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerStackDescriptorRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerStackDescriptorRegistryItemProvider layerStackDescriptorRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerStackDescriptorRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerStackDescriptorRegistryAdapter() {
		if (layerStackDescriptorRegistryItemProvider == null) {
			layerStackDescriptorRegistryItemProvider = new LayerStackDescriptorRegistryItemProvider(this);
		}

		return layerStackDescriptorRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyRegistryItemProvider propertyRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyRegistryAdapter() {
		if (propertyRegistryItemProvider == null) {
			propertyRegistryItemProvider = new PropertyRegistryItemProvider(this);
		}

		return propertyRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyItemProvider propertyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyAdapter() {
		if (propertyItemProvider == null) {
			propertyItemProvider = new PropertyItemProvider(this);
		}

		return propertyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeRegistryItemProvider typeRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeRegistryAdapter() {
		if (typeRegistryItemProvider == null) {
			typeRegistryItemProvider = new TypeRegistryItemProvider(this);
		}

		return typeRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToTypeMapItemProvider stringToTypeMapItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToTypeMapAdapter() {
		if (stringToTypeMapItemProvider == null) {
			stringToTypeMapItemProvider = new StringToTypeMapItemProvider(this);
		}

		return stringToTypeMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptorRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerDescriptorRegistryItemProvider layerDescriptorRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptorRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerDescriptorRegistryAdapter() {
		if (layerDescriptorRegistryItemProvider == null) {
			layerDescriptorRegistryItemProvider = new LayerDescriptorRegistryItemProvider(this);
		}

		return layerDescriptorRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerDescriptorItemProvider layerDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerDescriptorAdapter() {
		if (layerDescriptorItemProvider == null) {
			layerDescriptorItemProvider = new LayerDescriptorItemProvider(this);
		}

		return layerDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerApplicationFactory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerApplicationFactoryItemProvider layerApplicationFactoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerApplicationFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerApplicationFactoryAdapter() {
		if (layerApplicationFactoryItemProvider == null) {
			layerApplicationFactoryItemProvider = new LayerApplicationFactoryItemProvider(this);
		}

		return layerApplicationFactoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetterRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertySetterRegistryItemProvider propertySetterRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetterRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertySetterRegistryAdapter() {
		if (propertySetterRegistryItemProvider == null) {
			propertySetterRegistryItemProvider = new PropertySetterRegistryItemProvider(this);
		}

		return propertySetterRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToPropertySetterItemProvider stringToPropertySetterItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToPropertySetterAdapter() {
		if (stringToPropertySetterItemProvider == null) {
			stringToPropertySetterItemProvider = new StringToPropertySetterItemProvider(this);
		}

		return stringToPropertySetterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptorRegistry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerOperatorDescriptorRegistryItemProvider layerOperatorDescriptorRegistryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptorRegistry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerOperatorDescriptorRegistryAdapter() {
		if (layerOperatorDescriptorRegistryItemProvider == null) {
			layerOperatorDescriptorRegistryItemProvider = new LayerOperatorDescriptorRegistryItemProvider(this);
		}

		return layerOperatorDescriptorRegistryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerOperatorDescriptorItemProvider layerOperatorDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerOperatorDescriptorAdapter() {
		if (layerOperatorDescriptorItemProvider == null) {
			layerOperatorDescriptorItemProvider = new LayerOperatorDescriptorItemProvider(this);
		}

		return layerOperatorDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyOperatorItemProvider propertyOperatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyOperatorAdapter() {
		if (propertyOperatorItemProvider == null) {
			propertyOperatorItemProvider = new PropertyOperatorItemProvider(this);
		}

		return propertyOperatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToTypeInstanceMapItemProvider stringToTypeInstanceMapItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToTypeInstanceMapAdapter() {
		if (stringToTypeInstanceMapItemProvider == null) {
			stringToTypeInstanceMapItemProvider = new StringToTypeInstanceMapItemProvider(this);
		}

		return stringToTypeInstanceMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Folder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FolderItemProvider folderItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Folder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFolderAdapter() {
		if (folderItemProvider == null) {
			folderItemProvider = new FolderItemProvider(this);
		}

		return folderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Metamodel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetamodelItemProvider metamodelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Metamodel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetamodelAdapter() {
		if (metamodelItemProvider == null) {
			metamodelItemProvider = new MetamodelItemProvider(this);
		}

		return metamodelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TopLayerOperatorItemProvider topLayerOperatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTopLayerOperatorAdapter() {
		if (topLayerOperatorItemProvider == null) {
			topLayerOperatorItemProvider = new TopLayerOperatorItemProvider(this);
		}

		return topLayerOperatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.StackedLayerOperator} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StackedLayerOperatorItemProvider stackedLayerOperatorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.StackedLayerOperator}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStackedLayerOperatorAdapter() {
		if (stackedLayerOperatorItemProvider == null) {
			stackedLayerOperatorItemProvider = new StackedLayerOperatorItemProvider(this);
		}

		return stackedLayerOperatorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyIndex} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyIndexItemProvider propertyIndexItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyIndex}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPropertyIndexAdapter() {
		if (propertyIndexItemProvider == null) {
			propertyIndexItemProvider = new PropertyIndexItemProvider(this);
		}

		return propertyIndexItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToPropertyIndexMapItemProvider stringToPropertyIndexMapItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToPropertyIndexMapAdapter() {
		if (stringToPropertyIndexMapItemProvider == null) {
			stringToPropertyIndexMapItemProvider = new StringToPropertyIndexMapItemProvider(this);
		}

		return stringToPropertyIndexMapItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.SimpleLayerDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SimpleLayerDescriptorItemProvider simpleLayerDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.SimpleLayerDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSimpleLayerDescriptorAdapter() {
		if (simpleLayerDescriptorItemProvider == null) {
			simpleLayerDescriptorItemProvider = new SimpleLayerDescriptorItemProvider(this);
		}

		return simpleLayerDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullInstanceItemProvider nullInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullInstanceAdapter() {
		if (nullInstanceItemProvider == null) {
			nullInstanceItemProvider = new NullInstanceItemProvider(this);
		}

		return nullInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Layer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LayerItemProvider layerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Layer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLayerAdapter() {
		if (layerItemProvider == null) {
			layerItemProvider = new LayerItemProvider(this);
		}

		return layerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullPropertySetter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NullPropertySetterItemProvider nullPropertySetterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullPropertySetter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNullPropertySetterAdapter() {
		if (nullPropertySetterItemProvider == null) {
			nullPropertySetterItemProvider = new NullPropertySetterItemProvider(this);
		}

		return nullPropertySetterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperatorDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TopLayerOperatorDescriptorItemProvider topLayerOperatorDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperatorDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTopLayerOperatorDescriptorAdapter() {
		if (topLayerOperatorDescriptorItemProvider == null) {
			topLayerOperatorDescriptorItemProvider = new TopLayerOperatorDescriptorItemProvider(this);
		}

		return topLayerOperatorDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.StackedLayerOperatorDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StackedLayerOperatorDescriptorItemProvider stackedLayerOperatorDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.StackedLayerOperatorDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStackedLayerOperatorDescriptorAdapter() {
		if (stackedLayerOperatorDescriptorItemProvider == null) {
			stackedLayerOperatorDescriptorItemProvider = new StackedLayerOperatorDescriptorItemProvider(this);
		}

		return stackedLayerOperatorDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AllViewsDerivedLayer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AllViewsDerivedLayerItemProvider allViewsDerivedLayerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AllViewsDerivedLayer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAllViewsDerivedLayerAdapter() {
		if (allViewsDerivedLayerItemProvider == null) {
			allViewsDerivedLayerItemProvider = new AllViewsDerivedLayerItemProvider(this);
		}

		return allViewsDerivedLayerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSPropertySetter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSPropertySetterItemProvider cssPropertySetterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSPropertySetter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSPropertySetterAdapter() {
		if (cssPropertySetterItemProvider == null) {
			cssPropertySetterItemProvider = new CSSPropertySetterItemProvider(this);
		}

		return cssPropertySetterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSTypeItemProvider cssTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSTypeAdapter() {
		if (cssTypeItemProvider == null) {
			cssTypeItemProvider = new CSSTypeItemProvider(this);
		}

		return cssTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSInstanceItemProvider cssInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSInstanceAdapter() {
		if (cssInstanceItemProvider == null) {
			cssInstanceItemProvider = new CSSInstanceItemProvider(this);
		}

		return cssInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHidePropertySetter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSHidePropertySetterItemProvider cssHidePropertySetterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHidePropertySetter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSHidePropertySetterAdapter() {
		if (cssHidePropertySetterItemProvider == null) {
			cssHidePropertySetterItemProvider = new CSSHidePropertySetterItemProvider(this);
		}

		return cssHidePropertySetterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHideType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSHideTypeItemProvider cssHideTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHideType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSHideTypeAdapter() {
		if (cssHideTypeItemProvider == null) {
			cssHideTypeItemProvider = new CSSHideTypeItemProvider(this);
		}

		return cssHideTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHideInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CSSHideInstanceItemProvider cssHideInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CSSHideInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCSSHideInstanceAdapter() {
		if (cssHideInstanceItemProvider == null) {
			cssHideInstanceItemProvider = new CSSHideInstanceItemProvider(this);
		}

		return cssHideInstanceItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (layerNamedStyleItemProvider != null) layerNamedStyleItemProvider.dispose();
		if (layersStackItemProvider != null) layersStackItemProvider.dispose();
		if (layersStackApplicationItemProvider != null) layersStackApplicationItemProvider.dispose();
		if (layerStackDescriptorRegistryItemProvider != null) layerStackDescriptorRegistryItemProvider.dispose();
		if (propertyRegistryItemProvider != null) propertyRegistryItemProvider.dispose();
		if (propertyItemProvider != null) propertyItemProvider.dispose();
		if (typeRegistryItemProvider != null) typeRegistryItemProvider.dispose();
		if (stringToTypeMapItemProvider != null) stringToTypeMapItemProvider.dispose();
		if (layerDescriptorRegistryItemProvider != null) layerDescriptorRegistryItemProvider.dispose();
		if (layerDescriptorItemProvider != null) layerDescriptorItemProvider.dispose();
		if (layerApplicationFactoryItemProvider != null) layerApplicationFactoryItemProvider.dispose();
		if (propertySetterRegistryItemProvider != null) propertySetterRegistryItemProvider.dispose();
		if (stringToPropertySetterItemProvider != null) stringToPropertySetterItemProvider.dispose();
		if (layerOperatorDescriptorRegistryItemProvider != null) layerOperatorDescriptorRegistryItemProvider.dispose();
		if (layerOperatorDescriptorItemProvider != null) layerOperatorDescriptorItemProvider.dispose();
		if (propertyOperatorItemProvider != null) propertyOperatorItemProvider.dispose();
		if (stringToTypeInstanceMapItemProvider != null) stringToTypeInstanceMapItemProvider.dispose();
		if (folderItemProvider != null) folderItemProvider.dispose();
		if (metamodelItemProvider != null) metamodelItemProvider.dispose();
		if (topLayerOperatorItemProvider != null) topLayerOperatorItemProvider.dispose();
		if (stackedLayerOperatorItemProvider != null) stackedLayerOperatorItemProvider.dispose();
		if (propertyIndexItemProvider != null) propertyIndexItemProvider.dispose();
		if (stringToPropertyIndexMapItemProvider != null) stringToPropertyIndexMapItemProvider.dispose();
		if (simpleLayerDescriptorItemProvider != null) simpleLayerDescriptorItemProvider.dispose();
		if (nullInstanceItemProvider != null) nullInstanceItemProvider.dispose();
		if (layerItemProvider != null) layerItemProvider.dispose();
		if (nullPropertySetterItemProvider != null) nullPropertySetterItemProvider.dispose();
		if (topLayerOperatorDescriptorItemProvider != null) topLayerOperatorDescriptorItemProvider.dispose();
		if (stackedLayerOperatorDescriptorItemProvider != null) stackedLayerOperatorDescriptorItemProvider.dispose();
		if (allViewsDerivedLayerItemProvider != null) allViewsDerivedLayerItemProvider.dispose();
		if (cssPropertySetterItemProvider != null) cssPropertySetterItemProvider.dispose();
		if (cssTypeItemProvider != null) cssTypeItemProvider.dispose();
		if (cssInstanceItemProvider != null) cssInstanceItemProvider.dispose();
		if (cssHidePropertySetterItemProvider != null) cssHidePropertySetterItemProvider.dispose();
		if (cssHideTypeItemProvider != null) cssHideTypeItemProvider.dispose();
		if (cssHideInstanceItemProvider != null) cssHideInstanceItemProvider.dispose();
	}

	/**
	 * A child creation extender for the {@link NotationPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static class NotationChildCreationExtender implements IChildCreationExtender {
		/**
		 * The switch for creating child descriptors specific to each extended class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * 
		 * @generated NOT
		 */
		protected static class CreationSwitch extends NotationSwitch {
			/**
			 * The child descriptors being populated.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected List<Object> newChildDescriptors;

			/**
			 * The domain in which to create the children.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected EditingDomain editingDomain;

			/**
			 * Creates the a switch for populating child descriptors in the given domain.
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain) {
				this.newChildDescriptors = newChildDescriptors;
				this.editingDomain = editingDomain;
			}

			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			@Override
			public Object caseView(View object) {
				newChildDescriptors.add
					(createChildParameter
						(NotationPackage.Literals.VIEW__STYLES,
						 LayersFactory.eINSTANCE.createLayerNamedStyle()));

				return null;
			}

			/**
			 * <!-- begin-user-doc -->
			 * <!-- end-user-doc -->
			 * @generated
			 */
			protected CommandParameter createChildParameter(Object feature, Object child) {
				return new CommandParameter(null, feature, child);
			}

		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		@Override
		public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
			ArrayList<Object> result = new ArrayList<Object>();
			new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
			return result;
		}

		/**
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		@Override
		public ResourceLocator getResourceLocator() {
			return LayersEditPlugin.INSTANCE;
		}
	}

}
