/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.operators;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.BooleanInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.operators.CustomPropertyOperatorsInstance;

public class BooleanAndOperator
implements CustomPropertyOperatorsInstance {
    public static final BooleanInstance FALSE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
    public static final BooleanInstance TRUE_INSTANCE;

    static {
        FALSE_INSTANCE.setValue(false);
        TRUE_INSTANCE = LayersFactory.eINSTANCE.createBooleanInstance();
        TRUE_INSTANCE.setValue(true);
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(EList<ComputePropertyValueCommand> nestedCommand) throws LayersException {
        return new BooleanAndOperatorCommand(nestedCommand);
    }

    class BooleanAndOperatorCommand
    implements ComputePropertyValueCommand {
        EList<ComputePropertyValueCommand> nestedCommand;

        public BooleanAndOperatorCommand(EList<ComputePropertyValueCommand> nestedCommand) {
            this.nestedCommand = nestedCommand;
        }

        @Override
        public TypeInstance getCmdValue() throws LayersException {
            for (ComputePropertyValueCommand curCmd : this.nestedCommand) {
                boolean curCmdRes = ((BooleanInstance)curCmd.getCmdValue()).isValue();
                if (curCmdRes) continue;
                return FALSE_INSTANCE;
            }
            return TRUE_INSTANCE;
        }
    }
}

