/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.BadStateException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptor;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.NullInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayerExpressionImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.StringToTypeInstanceMapImpl;

public abstract class AbstractLayerImpl
extends LayerExpressionImpl
implements AbstractLayer {
    protected EList<TypeInstance> propertyValues;
    protected EMap<String, TypeInstance> propertyValueMap;
    protected LayerDescriptor layerDescriptor;
    protected EList<View> views;

    protected AbstractLayerImpl() {
        PropertyValuesSynchronizer adapter = new PropertyValuesSynchronizer();
        this.eAdapters().add((Object)adapter);
    }

    @Override
    protected void startBehaviors() {
        super.startBehaviors();
    }

    @Override
    protected EClass eStaticClass() {
        return LayersPackage.Literals.ABSTRACT_LAYER;
    }

    @Override
    public EList<TypeInstance> getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new EObjectResolvingEList<TypeInstance>(TypeInstance.class, (InternalEObject)this, 8){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.propertyValues;
    }

    @Override
    public EMap<String, TypeInstance> getPropertyValueMap() {
        if (this.propertyValueMap == null) {
            this.propertyValueMap = new EcoreEMap(LayersPackage.Literals.STRING_TO_TYPE_INSTANCE_MAP, StringToTypeInstanceMapImpl.class, (InternalEObject)this, 9);
        }
        return this.propertyValueMap;
    }

    @Override
    public LayerDescriptor getLayerDescriptor() {
        if (this.layerDescriptor != null && this.layerDescriptor.eIsProxy()) {
            InternalEObject oldLayerDescriptor = (InternalEObject)this.layerDescriptor;
            this.layerDescriptor = (LayerDescriptor)this.eResolveProxy(oldLayerDescriptor);
            if (this.layerDescriptor != oldLayerDescriptor && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldLayerDescriptor, (Object)this.layerDescriptor));
            }
        }
        return this.layerDescriptor;
    }

    public LayerDescriptor basicGetLayerDescriptor() {
        return this.layerDescriptor;
    }

    @Override
    public void setLayerDescriptor(LayerDescriptor newLayerDescriptor) {
        LayerDescriptor oldLayerDescriptor = this.layerDescriptor;
        this.layerDescriptor = newLayerDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLayerDescriptor, (Object)this.layerDescriptor));
        }
    }

    @Override
    public EList<View> getViews() {
        if (this.views == null) {
            this.views = new EObjectResolvingEList(View.class, (InternalEObject)this, 11);
        }
        return this.views;
    }

    @Override
    public EList<Property> getAttachedProperties() {
        BasicEList res = new BasicEList();
        for (Map.Entry entry : this.getPropertyValueMap()) {
            String propertyName = (String)entry.getKey();
            try {
                res.add((Object)this.application.getPropertyRegistry().getProperty(propertyName));
            }
            catch (NotFoundException e) {
                res.add(null);
                e.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public TypeInstance addPropertyInstance(Property property) throws LayersException {
        String name = property.getName();
        if (name == null || name.length() == 0) {
            throw new LayersException("The name of a property must be set.");
        }
        try {
            TypeInstance instance = property.createInstance();
            this.getPropertyValueMap().put((Object)name, (Object)instance);
            return instance;
        }
        catch (NullPointerException e) {
            throw new LayersException("The type of the property '" + name + "' must be set.", e);
        }
    }

    @Override
    public void removePropertyInstance(Property property) {
        this.getPropertyValueMap().remove((Object)property.getName());
    }

    @Override
    public TypeInstance getPropertyInstance(Property property) throws LayersException {
        return this.getPropertyInstance(property.getName());
    }

    @Override
    public TypeInstance getPropertyInstance(String property) throws LayersException {
        TypeInstance instance = (TypeInstance)this.getPropertyValueMap().get((Object)property);
        if (instance == null) {
            throw new NotFoundException("Can't find instance for the specified property");
        }
        return instance;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getPropertyValueMap()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getPropertyValues();
            }
            case 9: {
                if (coreType) {
                    return this.getPropertyValueMap();
                }
                return this.getPropertyValueMap().map();
            }
            case 10: {
                if (resolve) {
                    return this.getLayerDescriptor();
                }
                return this.basicGetLayerDescriptor();
            }
            case 11: {
                return this.getViews();
            }
            case 12: {
                return this.getAttachedProperties();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getPropertyValues().clear();
                this.getPropertyValues().addAll((Collection)newValue);
                return;
            }
            case 9: {
                ((EStructuralFeature.Setting)this.getPropertyValueMap()).set(newValue);
                return;
            }
            case 10: {
                this.setLayerDescriptor((LayerDescriptor)newValue);
                return;
            }
            case 11: {
                this.getViews().clear();
                this.getViews().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getAttachedProperties().clear();
                this.getAttachedProperties().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getPropertyValues().clear();
                return;
            }
            case 9: {
                this.getPropertyValueMap().clear();
                return;
            }
            case 10: {
                this.setLayerDescriptor(null);
                return;
            }
            case 11: {
                this.getViews().clear();
                return;
            }
            case 12: {
                this.getAttachedProperties().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.propertyValues != null && !this.propertyValues.isEmpty();
            }
            case 9: {
                return this.propertyValueMap != null && !this.propertyValueMap.isEmpty();
            }
            case 10: {
                return this.layerDescriptor != null;
            }
            case 11: {
                return this.views != null && !this.views.isEmpty();
            }
            case 12: {
                return !this.getAttachedProperties().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 9: {
                try {
                    return this.addPropertyInstance((Property)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 10: {
                this.removePropertyInstance((Property)arguments.get(0));
                return null;
            }
            case 11: {
                try {
                    return this.getPropertyInstance((Property)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 12: {
                try {
                    return this.getPropertyInstance((String)arguments.get(0));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    protected void resetAllPropertyValuesFromRegistry() throws BadStateException {
        int size;
        EList<Property> availableProperties;
        this.getPropertyValues().clear();
        LayersStackApplication application = this.getApplication();
        if (application == null) {
            return;
        }
        try {
            availableProperties = application.getPropertyRegistry().getProperties();
            size = availableProperties.size();
        }
        catch (NullPointerException e) {
            throw new BadStateException("Property 'application.propertyRegistry' must be set for resetAllPropertyValuesFromRegistry() to work.");
        }
        this.getPropertyValues().clear();
        int i = 0;
        while (i < size) {
            String propertyName = ((Property)availableProperties.get(i)).getName();
            TypeInstance instance = (TypeInstance)this.getPropertyValueMap().get((Object)propertyName);
            if (instance == null) {
                instance = NullInstance.NULLINSTANCE;
            }
            this.getPropertyValues().add((Object)instance);
            ++i;
        }
    }

    protected void synchronizePropertyValue(String propertyName, TypeInstance value) throws BadStateException, NotFoundException {
        if (this.application == null) {
            return;
        }
        try {
            int propertyIndex = this.application.getPropertyRegistry().getPropertyIndex(propertyName);
            this.getPropertyValues().set(propertyIndex, (Object)value);
        }
        catch (NullPointerException e) {
            throw new BadStateException("application should be set first.");
        }
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        if (!this.isLayerEnabledInternal() || !this.getViews().contains((Object)view)) {
            return null;
        }
        try {
            return this.getPropertyInstance(property);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> properties) throws LayersException {
        if (!this.isLayerEnabledInternal() || !this.getViews().contains((Object)view)) {
            return null;
        }
        BasicEList resCmds = new BasicEList(properties.size());
        boolean isCmdFound = false;
        for (Property property : properties) {
            if (property != null) {
                try {
                    resCmds.add((Object)this.getPropertyInstance(property));
                    isCmdFound = true;
                }
                catch (NotFoundException e) {
                    resCmds.add(null);
                }
                continue;
            }
            resCmds.add(null);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> views, Property property) throws LayersException {
        TypeInstance value;
        if (!this.isLayerEnabledInternal()) {
            return null;
        }
        try {
            value = this.getPropertyInstance(property);
        }
        catch (NotFoundException e1) {
            return null;
        }
        BasicEList resCmds = new BasicEList(views.size());
        boolean isCmdFound = false;
        for (View view : views) {
            if (view != null && this.getViews().contains((Object)view)) {
                isCmdFound = true;
                resCmds.add((Object)value);
                continue;
            }
            resCmds.add(null);
        }
        if (isCmdFound) {
            return resCmds;
        }
        return null;
    }

    public class PropertyValuesSynchronizer
    extends AdapterImpl {
        public void notifyChanged(Notification msg) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("event " + msg.getEventType());
            }
            switch (msg.getFeatureID(AbstractLayer.class)) {
                case 9: {
                    this.notifyLayerPropertyValueMapChanged(msg);
                    break;
                }
                case 0: {
                    this.notifyLayerApplicationFeatureChanged(msg);
                    break;
                }
            }
        }

        protected void notifyLayerPropertyValueMapChanged(Notification msg) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("map changed " + msg.getEventType());
            }
            switch (msg.getEventType()) {
                case 1: {
                    StringToTypeInstanceMapImpl entry = (StringToTypeInstanceMapImpl)((Object)msg.getNewValue());
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("SET - newValue=" + entry.getValue() + ", key=" + entry.getKey());
                    }
                    String newKey = entry.getKey();
                    TypeInstance value = entry.getValue();
                    if (value == null) break;
                    try {
                        AbstractLayerImpl.this.synchronizePropertyValue(newKey, value);
                    }
                    catch (BadStateException e) {
                        e.printStackTrace();
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    StringToTypeInstanceMapImpl entry = (StringToTypeInstanceMapImpl)((Object)msg.getNewValue());
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("ADD - newValue=" + entry.getValue() + ", key=" + entry.getKey());
                    }
                    try {
                        AbstractLayerImpl.this.synchronizePropertyValue(entry.getKey(), entry.getValue());
                    }
                    catch (LayersException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    StringToTypeInstanceMapImpl entry = (StringToTypeInstanceMapImpl)((Object)msg.getOldValue());
                    if (Activator.log.isDebugEnabled()) {
                        Activator.log.debug("REMOVE" + entry.getValue() + ", key=" + entry.getKey());
                    }
                    try {
                        AbstractLayerImpl.this.synchronizePropertyValue(entry.getKey(), NullInstance.NULLINSTANCE);
                    }
                    catch (LayersException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }

        protected void notifyLayerApplicationFeatureChanged(Notification msg) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug("application changed " + msg.getEventType());
            }
            switch (msg.getEventType()) {
                case 1: {
                    try {
                        AbstractLayerImpl.this.resetAllPropertyValuesFromRegistry();
                    }
                    catch (BadStateException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    AbstractLayerImpl.this.getPropertyValues().clear();
                }
            }
        }
    }
}

