/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.ClassnameKind;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayersConfigPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.impl.InstanciableElementImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.InstanciationException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.CustomPropertyOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.operators.CustomPropertyOperatorsInstance;
import org.osgi.framework.Bundle;

public class OperatorConfigImpl
extends InstanciableElementImpl
implements OperatorConfig {
    protected OperatorConfigImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LayersConfigPackage.Literals.OPERATOR_CONFIG;
    }

    @Override
    public PropertyOperator createOperatorDescriptor() throws InstanciationException {
        switch (this.getClassnameKind()) {
            case UNDEFINED: {
                try {
                    PropertyOperator res = this.createEmfInstance();
                    this.setClassnameKind(ClassnameKind.EMF_CLASSNAME);
                    return res;
                }
                catch (InstanciationException instanciationException) {
                }
                catch (ClassCastException e) {
                    this.setClassnameKind(ClassnameKind.NOT_FOUND);
                    throw new InstanciationException("Can't create PropertyOperator for name '" + this.getClassname() + "'. Bad EMF type.");
                }
                try {
                    PropertyOperator res = this.createPojoInstance();
                    this.setClassnameKind(ClassnameKind.POJO_CLASSNAME);
                    return res;
                }
                catch (InstanciationException e) {
                    this.setClassnameKind(ClassnameKind.NOT_FOUND);
                    throw e;
                }
            }
            case EMF_CLASSNAME: {
                return this.createEmfInstance();
            }
            case POJO_CLASSNAME: {
                return this.createPojoInstance();
            }
            case NOT_FOUND: {
                break;
            }
        }
        throw new InstanciationException("Can't create PropertyOperator for name '" + this.getClassname() + "'.");
    }

    protected PropertyOperator createPojoInstance() throws InstanciationException {
        try {
            Class<?> opClass = this.loadClass();
            CustomPropertyOperator operator = LayersFactory.eINSTANCE.createCustomPropertyOperator();
            operator.setOperatorInstance((CustomPropertyOperatorsInstance)opClass.newInstance());
            operator.setName(this.getName());
            return operator;
        }
        catch (Exception e) {
            this.setClassnameKind(ClassnameKind.NOT_FOUND);
            throw new InstanciationException("Can't create PropertyOperator for name '" + this.getClassname() + "'. " + e.getMessage());
        }
    }

    protected PropertyOperator createEmfInstance() throws InstanciationException {
        PropertyOperator res;
        EClassifier classifier = LayersPackage.eINSTANCE.getEClassifier(this.getClassname());
        if (classifier == null) {
            throw new InstanciationException("Can't create PropertyOperator for name '" + this.getClassname() + "'. Bad classname.");
        }
        try {
            res = (PropertyOperator)LayersFactory.eINSTANCE.create((EClass)classifier);
        }
        catch (ClassCastException e) {
            throw new InstanciationException("Can't create PropertyOperator for name '" + this.getClassname() + "'. Bad type.");
        }
        return res;
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                try {
                    return this.createOperatorDescriptor();
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    private Class<?> loadClass() throws LayersException {
        Class classDesc;
        String classname = this.getClassname();
        try {
            classDesc = Class.forName(classname);
        }
        catch (ClassNotFoundException e1) {
            try {
                String bundleID = this.getBundleID();
                Bundle bundle = Platform.getBundle((String)bundleID);
                classDesc = bundle.loadClass(classname);
            }
            catch (ClassNotFoundException e2) {
                throw new LayersException("Can't find class for the name '" + classname + "'.", e2);
            }
            catch (NullPointerException e) {
                throw new LayersException("Can't find bundle '" + this.getBundleID() + "' for class for the name '" + classname + "'.", e);
            }
        }
        return classDesc;
    }
}

