/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagramtemplate.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.papyrus.diagramtemplate.DiagramDefinition;
import org.eclipse.papyrus.diagramtemplate.DiagramTemplateFactory;
import org.eclipse.papyrus.diagramtemplate.DiagramTemplatePackage;
import org.eclipse.papyrus.diagramtemplate.Selection;
import org.eclipse.papyrus.diagramtemplate.SelectionKind;
import org.eclipse.papyrus.diagramtemplate.SelectionRef;
import org.eclipse.papyrus.diagramtemplate.Template;
import org.eclipse.papyrus.diagramtemplate.impl.DiagramDefinitionImpl;
import org.eclipse.papyrus.diagramtemplate.impl.SelectionImpl;
import org.eclipse.papyrus.diagramtemplate.impl.SelectionRefImpl;
import org.eclipse.papyrus.diagramtemplate.impl.TemplateImpl;

public class DiagramTemplateFactoryImpl
extends EFactoryImpl
implements DiagramTemplateFactory {
    public static DiagramTemplateFactory init() {
        try {
            DiagramTemplateFactory theDiagramTemplateFactory = (DiagramTemplateFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/papyrus/diagramtemplate");
            if (theDiagramTemplateFactory != null) {
                return theDiagramTemplateFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DiagramTemplateFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createDiagramDefinition();
            }
            case 1: {
                return this.createSelection();
            }
            case 2: {
                return this.createSelectionRef();
            }
            case 3: {
                return this.createTemplate();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createSelectionKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertSelectionKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public DiagramDefinition createDiagramDefinition() {
        DiagramDefinitionImpl diagramDefinition = new DiagramDefinitionImpl();
        return diagramDefinition;
    }

    public Selection createSelection() {
        SelectionImpl selection = new SelectionImpl();
        return selection;
    }

    public SelectionRef createSelectionRef() {
        SelectionRefImpl selectionRef = new SelectionRefImpl();
        return selectionRef;
    }

    public Template createTemplate() {
        TemplateImpl template = new TemplateImpl();
        return template;
    }

    public SelectionKind createSelectionKindFromString(EDataType eDataType, String initialValue) {
        SelectionKind result = SelectionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSelectionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DiagramTemplatePackage getDiagramTemplatePackage() {
        return (DiagramTemplatePackage)this.getEPackage();
    }

    @Deprecated
    public static DiagramTemplatePackage getPackage() {
        return DiagramTemplatePackage.eINSTANCE;
    }
}

