/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ease.module;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.ease.module.RequestUtils;
import org.eclipse.papyrus.ease.module.ViewAndElementHandler;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.types.core.utils.ElementTypeRegistryUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PapyrusUtilsModule
extends AbstractScriptModule {
    private ModelSet currentModelSet = null;
    static WeakReference<PapyrusMultiDiagramEditor> papyrus = null;

    private IFile getDIFile(IFile inputFile) {
        IFile result = null;
        if ("uml".equals(inputFile.getFileExtension())) {
            result = (IFile)inputFile.getParent().findMember(inputFile.getName().replaceAll(".uml$", ".di"));
        } else if ("di".equals(inputFile.getFileExtension()) && inputFile.exists()) {
            result = inputFile;
        }
        return result;
    }

    @WrapToScript
    public Package getPapyrusModel(String modelPath) throws RuntimeException, CoreException, URISyntaxException, IOException, ServiceException {
        Object resolved = ResourceTools.resolve((Object)modelPath, (Object)this.getScriptEngine().getExecutedFile());
        IFile diFile = null;
        URI modelURI = null;
        if (resolved instanceof IFile) {
            diFile = this.getDIFile((IFile)resolved);
        } else {
            IResource referencedIFile;
            URI emfURI = null;
            if (resolved instanceof URL || resolved instanceof java.net.URI) {
                emfURI = URI.createURI((String)modelPath);
            }
            if (emfURI != null && emfURI.isPlatformResource() && (referencedIFile = ResourcesPlugin.getWorkspace().getRoot().findMember(emfURI.toPlatformString(true))) instanceof IFile) {
                diFile = this.getDIFile((IFile)referencedIFile);
            }
        }
        if (diFile != null) {
            EObject rootObject;
            Resource res;
            ServicesRegistry servicesRegistry;
            IWorkbench workbench = PlatformUI.getWorkbench();
            FileEditorInput editorInput = new FileEditorInput(diFile);
            IEditorPart editorPart = null;
            IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            block0: while (n2 < n) {
                IWorkbenchWindow win = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = win.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    final IWorkbenchPage page = iWorkbenchPageArray[n4];
                    editorPart = page.findEditor((IEditorInput)editorInput);
                    if (editorPart != null) {
                        final IEditorPart papyPart = editorPart;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                page.activate((IWorkbenchPart)papyPart);
                            }
                        });
                        break block0;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (editorPart != null && (servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class)) != null) {
                this.currentModelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
            }
            if (this.currentModelSet != null && (res = this.currentModelSet.getResource(modelURI = URI.createPlatformResourceURI((String)diFile.getFullPath().toString(), (boolean)true).trimFileExtension().appendFileExtension("uml"), true)) != null && !res.getContents().isEmpty() && (rootObject = (EObject)res.getContents().get(0)) instanceof Package) {
                return (Package)rootObject;
            }
        }
        throw new RuntimeException("Failed to find an opened Papyrus session for file: " + modelPath);
    }

    @WrapToScript
    public NamedElement getPapyrusNamedElement(Object context, String qualifiedName) throws RuntimeException, CoreException, URISyntaxException, IOException, ServiceException {
        ResourceSet resSet = null;
        if (context instanceof String) {
            Package pack = this.getPapyrusModel((String)context);
            if (pack != null) {
                resSet = pack.eResource().getResourceSet();
            }
        } else if (context instanceof EObject && ((EObject)context).eResource() != null) {
            resSet = ((EObject)context).eResource().getResourceSet();
        }
        if (resSet != null) {
            Collection elems = UMLUtil.findNamedElements(resSet, (String)qualifiedName);
            if (!elems.isEmpty()) {
                return (NamedElement)elems.iterator().next();
            }
            throw new RuntimeException("Failed to find a NamedElement with qualified name: " + qualifiedName);
        }
        throw new RuntimeException("Failed to find a contextual resource for object " + context.toString() + " when searching Named Element " + qualifiedName);
    }

    @WrapToScript
    public static void setPapyrusSession(PapyrusMultiDiagramEditor editor) {
        papyrus = new WeakReference<PapyrusMultiDiagramEditor>(editor);
    }

    public static PapyrusMultiDiagramEditor getPapyrusSession() {
        if (papyrus != null && papyrus.get() != null) {
            return (PapyrusMultiDiagramEditor)papyrus.get();
        }
        PapyrusMultiDiagramEditor result = PapyrusUtilsModule.getActivePapyrusEditor();
        PapyrusUtilsModule.setPapyrusSession(result);
        return result;
    }

    @WrapToScript
    public static void createDiagram(EObject owner, String diagramArchitectureLabel, String diagramName) {
        try {
            ViewPrototype proto = PolicyChecker.getFor((EObject)owner).getPrototypesFor(owner).stream().filter(prototype -> diagramArchitectureLabel.equals(prototype.getLabel())).findAny().get();
            if (proto != null) {
                boolean bl = proto.instantiateOn(owner, diagramName);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Failed to find a diagram kind named " + diagramArchitectureLabel);
        }
    }

    @WrapToScript
    public static EObject createSemanticElement(EObject owner, String elementTypeIdToCreate) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, elementTypeIdToCreate);
        if (elementType != null) {
            return RequestUtils.createElementWithRequest(owner, elementType);
        }
        return null;
    }

    @WrapToScript
    public static ViewAndElementHandler createSemanticElementAndLinkView(String graphicalElementTypeIdToCreate, Node sourceNode, Double relativeXSource, Double relativeYSource, Node targetNode, Double relativeXTarget, Double relativeYTarget) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, graphicalElementTypeIdToCreate);
        GraphicalEditPart diagramEditPart = (GraphicalEditPart)PapyrusUtilsModule.getActivePapyrusViewer(papyrus).getContents();
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)PapyrusUtilsModule.getActivePapyrusViewer(papyrus).getEditPartRegistry().get(sourceNode);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)PapyrusUtilsModule.getActivePapyrusViewer(papyrus).getEditPartRegistry().get(targetNode);
        CreateConnectionViewAndElementRequest request = (CreateConnectionViewAndElementRequest)AspectUnspecifiedTypeConnectionTool.PapyrusCreateViewRequestFactory.getCreateConnectionRequest((IElementType)elementType, (PreferencesHint)diagramEditPart.getDiagramPreferencesHint());
        request.setSourceEditPart((EditPart)sourceEditPart);
        request.setType((Object)"connection start");
        PrecisionPoint sourcePoint = PapyrusUtilsModule.getAbsolutePoint(sourceNode, relativeXSource, relativeYSource);
        sourceEditPart.getFigure().translateToAbsolute((Translatable)sourcePoint);
        request.setLocation((Point)sourcePoint);
        Command command = sourceEditPart.getTargetEditPart((Request)request).getCommand((Request)request);
        if (command instanceof CompoundCommand) {
            for (Object subCommand : ((CompoundCommand)command).getCommands()) {
                if (!(subCommand instanceof ICommandProxy)) continue;
                request.setStartCommand((Command)((ICommandProxy)subCommand));
                break;
            }
        }
        request.setType((Object)"connection end");
        request.setTargetEditPart((EditPart)targetEditPart);
        PrecisionPoint targetPoint = PapyrusUtilsModule.getAbsolutePoint(targetNode, relativeXTarget, relativeYTarget);
        targetEditPart.getFigure().translateToAbsolute((Translatable)targetPoint);
        request.setLocation((Point)targetPoint);
        command = targetEditPart.getTargetEditPart((Request)request).getCommand((Request)request);
        if (command != null && command.canExecute()) {
            command.execute();
        }
        CreateConnectionViewAndElementRequest.ConnectionViewAndElementDescriptor descriptor = request.getConnectionViewAndElementDescriptor();
        View view = (View)descriptor.getAdapter(View.class);
        EObject semanticElement = (EObject)descriptor.getElementAdapter().getAdapter(EObject.class);
        return new ViewAndElementHandler(view, semanticElement);
    }

    @WrapToScript
    public static ViewAndElementHandler createSemanticElementAndView(String graphicalElementTypeIdToCreate, Integer x, Integer y, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer width, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer height) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, graphicalElementTypeIdToCreate);
        EditPart targetEditPart = PapyrusUtilsModule.calculateTargetEditPart(papyrus, (double)x, (double)y);
        if (elementType instanceof IHintedType && targetEditPart instanceof GraphicalEditPart) {
            CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, ((IHintedType)elementType).getSemanticHint(), ((GraphicalEditPart)targetEditPart).getDiagramPreferencesHint());
            CreateViewAndElementRequest request = new CreateViewAndElementRequest(viewDescriptor);
            Command command = targetEditPart.getTargetEditPart((Request)request).getCommand((Request)request);
            if (command != null && command.canExecute()) {
                command.execute();
            }
            View view = (View)viewDescriptor.getAdapter(View.class);
            EObject semanticElement = (EObject)viewDescriptor.getElementAdapter().getAdapter(EObject.class);
            PapyrusUtilsModule.updateBounds((IAdaptable)viewDescriptor, (TransactionalEditingDomain)papyrus.getEditingDomain(), new Point(x.intValue(), y.intValue()), width, height);
            return new ViewAndElementHandler(view, semanticElement);
        }
        return null;
    }

    @WrapToScript
    public static void refreshPapyrus() {
        Runnable refresh = new Runnable(){

            @Override
            public void run() {
                PapyrusUtilsModule.getActivePapyrusViewer(PapyrusUtilsModule.getPapyrusSession()).flush();
            }
        };
        Display.getDefault().syncExec(refresh);
    }

    public static void updateBounds(IAdaptable iAdaptable, TransactionalEditingDomain domain, Point location, Integer width, Integer height) {
        SetBoundsCommand setBoundsCommand = null;
        if (width != null && height != null) {
            Dimension dimension = new Dimension(width.intValue(), height.intValue());
            Rectangle rectangle = new Rectangle(location, dimension);
            setBoundsCommand = new SetBoundsCommand(domain, "move", iAdaptable, rectangle);
        } else {
            setBoundsCommand = new SetBoundsCommand(domain, "move", iAdaptable, location);
        }
        try {
            setBoundsCommand.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @WrapToScript
    public static View createView(EObject element, String graphicalElementTypeIdToCreate, Integer x, Integer y, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer width, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer height) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, graphicalElementTypeIdToCreate);
        EditPart targetEditPart = PapyrusUtilsModule.calculateTargetEditPart(papyrus, (double)x, (double)y);
        if (elementType instanceof IHintedType && targetEditPart instanceof GraphicalEditPart) {
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(element), Node.class, ((IHintedType)elementType).getSemanticHint(), ((GraphicalEditPart)targetEditPart).getDiagramPreferencesHint());
            CreateViewCommand createCommand = new CreateViewCommand((TransactionalEditingDomain)papyrus.getEditingDomain(), descriptor, ((GraphicalEditPart)targetEditPart).getNotationView());
            try {
                createCommand.execute(null, null);
                IAdaptable commandResult = (IAdaptable)createCommand.getCommandResult().getReturnValue();
                View result = (View)commandResult.getAdapter(View.class);
                PapyrusUtilsModule.updateBounds(commandResult, (TransactionalEditingDomain)papyrus.getEditingDomain(), new Point(x.intValue(), y.intValue()), width, height);
                return result;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @WrapToScript
    public static View createRelativeView(EObject element, String graphicalElementTypeIdToCreate, Node parentNode, Double relativeX, Double relativeY, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer width, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer height) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, graphicalElementTypeIdToCreate);
        Diagram diagram = DiagramUtils.getContainingDiagram((View)parentNode);
        GraphicalEditPart diagramEditPart = (GraphicalEditPart)PapyrusUtilsModule.getActivePapyrusViewer(papyrus).getEditPartRegistry().get(diagram);
        if (elementType instanceof IHintedType && diagramEditPart instanceof GraphicalEditPart) {
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(element), Node.class, ((IHintedType)elementType).getSemanticHint(), diagramEditPart.getDiagramPreferencesHint());
            CreateViewCommand createCommand = new CreateViewCommand((TransactionalEditingDomain)papyrus.getEditingDomain(), descriptor, (View)parentNode);
            try {
                createCommand.execute(null, null);
                IAdaptable commandResult = (IAdaptable)createCommand.getCommandResult().getReturnValue();
                View result = (View)commandResult.getAdapter(View.class);
                PapyrusUtilsModule.updateBounds(commandResult, (TransactionalEditingDomain)papyrus.getEditingDomain(), PapyrusUtilsModule.getRelativePoint(parentNode, relativeX, relativeY), width, height);
                return result;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @WrapToScript
    public static ViewAndElementHandler createRelativeSemanticElementAndView(String graphicalElementTypeIdToCreate, Node parentNode, Double relativeX, Double relativeY, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer width, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Integer height) {
        PapyrusMultiDiagramEditor papyrus = PapyrusUtilsModule.getPapyrusSession();
        IElementType elementType = PapyrusUtilsModule.getElementType(papyrus, graphicalElementTypeIdToCreate);
        if (elementType instanceof IHintedType && parentNode instanceof Node) {
            CreateViewAndElementRequest.ViewAndElementDescriptor viewDescriptor;
            CreateViewAndElementRequest request;
            Command command;
            GraphicalEditPart targetEditPart = null;
            if (relativeX == 0.0 || relativeY == 0.0 || relativeX == 1.0 || relativeY == 1.0) {
                targetEditPart = (GraphicalEditPart)PapyrusUtilsModule.getActivePapyrusViewer(papyrus).getEditPartRegistry().get(parentNode);
            } else {
                PrecisionPoint absoluteLocation = PapyrusUtilsModule.getAbsolutePoint(parentNode, relativeX, relativeY);
                targetEditPart = (GraphicalEditPart)PapyrusUtilsModule.calculateTargetEditPart(PapyrusUtilsModule.getPapyrusSession(), absoluteLocation.preciseX(), absoluteLocation.preciseY());
            }
            if (targetEditPart instanceof GraphicalEditPart && (command = targetEditPart.getTargetEditPart((Request)(request = new CreateViewAndElementRequest(viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, ((IHintedType)elementType).getSemanticHint(), targetEditPart.getDiagramPreferencesHint())))).getCommand((Request)request)) != null && command.canExecute()) {
                command.execute();
                View view = (View)viewDescriptor.getAdapter(View.class);
                EObject semanticElement = (EObject)viewDescriptor.getElementAdapter().getAdapter(EObject.class);
                PapyrusUtilsModule.updateBounds((IAdaptable)viewDescriptor, (TransactionalEditingDomain)papyrus.getEditingDomain(), PapyrusUtilsModule.getRelativePoint(parentNode, relativeX, relativeY), width, height);
                return new ViewAndElementHandler(view, semanticElement);
            }
        }
        return null;
    }

    private static Point getRelativePoint(Node parentNode, Double relativeX, Double relativeY) {
        LayoutConstraint constraint = parentNode.getLayoutConstraint();
        if (constraint instanceof Bounds) {
            Bounds bounds = (Bounds)constraint;
            double newX = relativeX * (double)bounds.getWidth();
            double newY = relativeY * (double)bounds.getHeight();
            return new PrecisionPoint(newX, newY);
        }
        return null;
    }

    private static PrecisionPoint getAbsolutePoint(Node parentNode, Double relativeX, Double relativeY) {
        LayoutConstraint constraint = parentNode.getLayoutConstraint();
        if (constraint instanceof Bounds) {
            Bounds bounds = (Bounds)constraint;
            Double newX = relativeX * (double)bounds.getWidth() + (double)bounds.getX();
            Double newY = relativeY * (double)bounds.getHeight() + (double)bounds.getY();
            return new PrecisionPoint(newX.doubleValue(), newY.doubleValue());
        }
        return null;
    }

    public static EditPart calculateTargetEditPart(PapyrusMultiDiagramEditor papyrus, Double x, Double y) {
        GraphicalEditPart diagramPart;
        IFigure targetFigure;
        PrecisionPoint location = new PrecisionPoint(x.doubleValue(), y.doubleValue());
        GraphicalViewer currentViewer = PapyrusUtilsModule.getActivePapyrusViewer(papyrus);
        if (currentViewer != null && (targetFigure = (diagramPart = (GraphicalEditPart)currentViewer.getContents()).getFigure().findFigureAt((Point)location)) != null) {
            EditPart targetEditPart = (EditPart)currentViewer.getVisualPartMap().get(targetFigure);
            while (targetEditPart == null && targetFigure.getParent() != null) {
                targetFigure = targetFigure.getParent();
                targetEditPart = (EditPart)currentViewer.getVisualPartMap().get(targetFigure);
            }
            return targetEditPart;
        }
        return null;
    }

    public static IElementType getElementType(PapyrusMultiDiagramEditor papyrus, String id) {
        try {
            ModelSet modelSet = (ModelSet)papyrus.getServicesRegistry().getService(ModelSet.class);
            ArchitectureDescriptionUtils utils = new ArchitectureDescriptionUtils(modelSet);
            IClientContext currentClientContext = ClientContextManager.getInstance().getClientContext(utils.getArchitectureContextId());
            return ElementTypeRegistryUtils.getType((IClientContext)currentClientContext, (String)id);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PapyrusMultiDiagramEditor getActivePapyrusEditor() {
        RunnableWithResult<IWorkbenchWindow> runnable = new RunnableWithResult<IWorkbenchWindow>(){

            public IWorkbenchWindow runWithTry() throws Throwable {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                return workbenchWindow;
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runnable);
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)runnable.getResult();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        if (editorPart != null && editorPart instanceof PapyrusMultiDiagramEditor) {
            try {
                if (!((PapyrusMultiDiagramEditor)editorPart).getServicesRegistry().isStarted((Object)ModelSet.class.getName())) {
                    ((PapyrusMultiDiagramEditor)editorPart).getServicesRegistry().startServicesByClassKeys(new Class[]{ModelSet.class});
                }
            }
            catch (ServiceMultiException | ServiceNotFoundException e) {
                e.printStackTrace();
            }
            return (PapyrusMultiDiagramEditor)editorPart;
        }
        return null;
    }

    public static GraphicalViewer getActivePapyrusViewer(PapyrusMultiDiagramEditor papyrusEditor) {
        IEditorPart currentEditor = papyrusEditor.getActiveEditor();
        if (currentEditor instanceof GraphicalEditor) {
            return (GraphicalViewer)((GraphicalEditor)currentEditor).getAdapter(GraphicalViewer.class);
        }
        return null;
    }
}

