/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ease.lang.python.jupyter.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.AbstractReplScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.ScriptExecutionException;
import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.python.py4j.internal.IInteractiveReturn;
import org.eclipse.ease.lang.python.py4j.internal.IPythonSideEngine;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.papyrus.ease.lang.python.jupyter.Activator;
import org.eclipse.papyrus.ease.lang.python.jupyter.internal.JupyterProxy;
import org.eclipse.swt.widgets.Display;

public class JupyterEngine
extends AbstractReplScriptEngine {
    public static final String ENGINE_ID = "org.eclipse.ease.lang.python.jupyter.engine";
    private static final String NOTE_BOOK_EXTENSION = "ipynb";
    private static final long PYTHON_SHUTDOWN_TIMEOUT_SECONDS = 5L;
    protected IPythonSideEngine fPythonSideEngine;
    private Process fPythonProcess;
    private Thread fInputGobbler;
    private Thread fErrorGobbler;
    private JupyterProxy jupyterProxy;

    public JupyterEngine() {
        super("Jupyter (CEA)");
    }

    protected void setupEngine() throws ScriptEngineException {
        if (this.fPythonSideEngine != null) {
            return;
        }
        if (this.jupyterProxy == null) {
            this.initializeJupyterProxy();
        }
        try {
            this.setTerminateOnIdle(false);
            this.fPythonProcess = this.jupyterProxy.getJupyterProcess();
            Activator.getDefault().registeProxy(this.jupyterProxy);
            this.fInputGobbler = new Thread((Runnable)new StreamGobbler(this.fPythonProcess.getInputStream(), this.getOutputStream(), "stdout"), "EASE py4j engine output stream gobbler");
            this.fInputGobbler.start();
            this.fErrorGobbler = new Thread((Runnable)new StreamGobbler(this.fPythonProcess.getErrorStream(), this.getErrorStream(), "stderr"), "EASE py4j engine error stream gobbler");
            this.fErrorGobbler.start();
            this.jupyterProxy.waitForKernelStartup();
            this.fPythonSideEngine = this.jupyterProxy.getPythonSideEngine();
        }
        catch (Exception e) {
            this.teardownEngine();
            throw new ScriptEngineException("Failed to start Python process. Please check the setting for the Python interpreter in Preferences -> Scripting -> Python Scripting:\n" + e.getMessage(), (Throwable)e);
        }
    }

    private void initializeJupyterProxy() {
        this.jupyterProxy = new JupyterProxy();
        ArrayList<Script> scriptToRemove = new ArrayList<Script>();
        for (Script script : this.getScheduledScripts()) {
            IFile scriptFile;
            if (!(script.getCommand() instanceof IFile) || !NOTE_BOOK_EXTENSION.equals((scriptFile = (IFile)script.getCommand()).getFileExtension())) continue;
            this.jupyterProxy.setNotebook(scriptFile);
            scriptToRemove.add(script);
        }
        this.getScheduledScripts().removeAll(scriptToRemove);
    }

    protected Object execute(final Script script, Object reference, final String fileName, boolean uiThread) throws Throwable {
        if (uiThread) {
            RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

                public Object runWithTry() throws Throwable {
                    return JupyterEngine.this.internalExecute(script, fileName);
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResultOrThrow();
        }
        return this.internalExecute(script, fileName);
    }

    protected Object internalExecute(Script script, String fileName) throws Throwable, Exception {
        IInteractiveReturn interactiveReturn;
        if (script.isShellMode()) {
            interactiveReturn = this.fPythonSideEngine.executeInteractive(script.getCode());
        } else {
            String code = script.getCode();
            interactiveReturn = this.fPythonSideEngine.executeScript(code, fileName);
        }
        Object exception = interactiveReturn.getException();
        if (exception instanceof Throwable) {
            throw (Throwable)exception;
        }
        if (exception != null) {
            throw new ScriptExecutionException(exception.toString(), 0, null, null, new ScriptStackTrace(), null);
        }
        return interactiveReturn.getResult();
    }

    public void terminateCurrent() {
        this.setTerminateOnIdle(true);
    }

    protected void teardownEngine() throws ScriptEngineException {
        if (this.jupyterProxy != null) {
            this.jupyterProxy.shutDown();
        }
        Activator.getDefault().unRegisterProxy(this.jupyterProxy);
        try {
            if (this.fInputGobbler != null) {
                this.fInputGobbler.join();
            }
            if (this.fErrorGobbler != null) {
                this.fErrorGobbler.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public void registerJar(URL url) {
        throw new UnsupportedOperationException();
    }

    protected Object internalGetVariable(String name) {
        return this.fPythonSideEngine.internalGetVariable(name);
    }

    protected Map<String, Object> internalGetVariables() {
        return this.fPythonSideEngine.internalGetVariables();
    }

    protected boolean internalHasVariable(String name) {
        return this.fPythonSideEngine.internalHasVariable(name);
    }

    protected void internalSetVariable(String name, Object content) {
        this.fPythonSideEngine.internalSetVariable(name, content);
    }

    public <T> T getAdapter(Class<T> adapter) {
        System.out.print("Adapted to: " + adapter);
        if (adapter.isInstance(this.fPythonProcess)) {
            System.out.println(" SUCCESS");
            return (T)this.fPythonProcess;
        }
        System.out.println(" Failed");
        return (T)super.getAdapter(adapter);
    }

    public String toString(Object object) {
        if (object == null) {
            return "None";
        }
        return super.toString(object);
    }

    public Process getPythonProcess() {
        return this.fPythonProcess;
    }

    public void setJupyterProxy(JupyterProxy jupyterProxy) {
        this.jupyterProxy = jupyterProxy;
    }

    private static class StreamGobbler
    implements Runnable {
        private final InputStream fReader;
        private final OutputStream fWriter;
        private final String fStreamName;

        public StreamGobbler(InputStream stream, OutputStream output, String streamName) {
            this.fReader = stream;
            this.fWriter = output;
            this.fStreamName = streamName;
        }

        @Override
        public void run() {
            try {
                int readCount;
                byte[] bytes = new byte[512];
                while ((readCount = this.fReader.read(bytes)) >= 0) {
                    try {
                        this.fWriter.write(bytes, 0, readCount);
                    }
                    catch (IOException e) {
                        Logger.error((String)"org.eclipse.papyrus.ease.lang.python.jupyter", (String)("Failed to write data read from Python's " + this.fStreamName + " stream."), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.papyrus.ease.lang.python.jupyter", (String)("Failed to read data from Python's " + this.fStreamName + " stream."), (Throwable)e);
            }
        }
    }
}

