/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ease.ui.help.hovers.HelpHoverImageProvider;
import org.eclipse.ease.ui.help.hovers.IHoverHelp;
import org.eclipse.ui.IMemento;

public class ConstantHelp
implements IHoverHelp {
    private final URL fHelpLocation;
    private final IMemento fHelpContent;
    private final Field fField;

    public ConstantHelp(URL helpLocation, IMemento helpContent, Field field) {
        this.fHelpLocation = helpLocation;
        this.fHelpContent = helpContent;
        this.fField = field;
    }

    @Override
    public String getName() {
        return this.fField.getName();
    }

    @Override
    public String getDescription() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("constants".equals(node.getString("class"))) {
                ArrayList<IMemento> candidates = new ArrayList<IMemento>();
                candidates.addAll(Arrays.asList(node.getChildren()));
                while (!candidates.isEmpty()) {
                    IMemento candidate = (IMemento)candidates.remove(0);
                    if (this.fField.getName().equals(candidate.getString("data-field"))) {
                        IHoverHelp.updateRelativeLinks(candidate, this.fHelpLocation);
                        return IHoverHelp.getNodeContent(candidate);
                    }
                    candidates.addAll(Arrays.asList(candidate.getChildren()));
                }
                break;
            }
            ++n2;
        }
        return "";
    }

    @Override
    public String getHoverContent() {
        String description = this.getDescription();
        if (!description.isEmpty()) {
            StringBuffer help = new StringBuffer();
            help.append("<h5>");
            help.append(IHoverHelp.getImageAndLabel(HelpHoverImageProvider.getImageLocation("icons/eobj16/field.png"), this.getName()));
            help.append("</h5>");
            help.append("<br />");
            help.append(description);
            return help.toString();
        }
        return null;
    }
}

