/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.ui;

import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.ease.ui.scripts.ui.ScriptContentProvider;
import org.eclipse.ease.ui.scripts.ui.ScriptContextMenuEntries;
import org.eclipse.ease.ui.scripts.ui.ScriptDragSource;
import org.eclipse.ease.ui.scripts.ui.ScriptEngineFilter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ScriptComposite
extends Composite
implements EventHandler {
    private final TreeViewer treeViewer;
    private IDoubleClickListener fDoubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IScriptEngine scriptEngine;
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof IScript && ScriptComposite.this.fEngineProvider != null && (scriptEngine = ScriptComposite.this.fEngineProvider.getScriptEngine()) != null) {
                scriptEngine.executeAsync((Object)("include('script:/" + ((IScript)element).getPath() + "');"));
            }
        }
    };
    private IScriptEngineProvider fEngineProvider = null;

    public ScriptComposite(IScriptEngineProvider engineProvider, IWorkbenchPartSite site, Composite parent, int style) {
        super(parent, style);
        this.fEngineProvider = engineProvider;
        this.setLayout((Layout)new FillLayout(256));
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        this.treeViewer.setContentProvider((IContentProvider)new ScriptContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IPath) {
                    return ((IPath)element).lastSegment();
                }
                if (element instanceof IScript) {
                    return ((IScript)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IPath) {
                    return Activator.getImage((String)"org.eclipse.ease.ui", (String)"/icons/eobj16/folder.png", (boolean)true);
                }
                if (element instanceof IScript) {
                    return Activator.getImage((String)"org.eclipse.ease.ui", (String)"/icons/eobj16/script.png", (boolean)true);
                }
                return super.getImage(element);
            }
        }, decorator));
        this.treeViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof IPath ? 0 : 1;
            }
        });
        IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        this.treeViewer.setInput((Object)repositoryService);
        if (this.fDoubleClickListener != null) {
            this.treeViewer.addDoubleClickListener(this.fDoubleClickListener);
        }
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        site.registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
        site.setSelectionProvider((ISelectionProvider)this.treeViewer);
        IMenuService menuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        ScriptContextMenuEntries popupContributionFactory = new ScriptContextMenuEntries("popup:" + site.getId());
        menuService.addContributionFactory((AbstractContributionFactory)popupContributionFactory);
        menuManager.setRemoveAllWhenShown(true);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)popupContributionFactory);
        ScriptDragSource.addDragSupport(this.treeViewer);
        IEventBroker fEventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        fEventBroker.subscribe("org/eclipse/ease/scripts/new", (EventHandler)this);
        fEventBroker.subscribe("org/eclipse/ease/scripts/removed", (EventHandler)this);
        fEventBroker.subscribe("org/eclipse/ease/scripts/keyword/name", (EventHandler)this);
    }

    public void setEngine(String engineID) {
        this.treeViewer.setFilters(new ViewerFilter[]{new ScriptEngineFilter(engineID)});
    }

    public void dispose() {
        IEventBroker fEventBroker = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        fEventBroker.unsubscribe((EventHandler)this);
        super.dispose();
    }

    public void setDoubleClickListener(IDoubleClickListener doubleClickListener) {
        if (this.fDoubleClickListener != null && this.treeViewer != null) {
            this.treeViewer.removeDoubleClickListener(this.fDoubleClickListener);
        }
        this.fDoubleClickListener = doubleClickListener;
        if (this.fDoubleClickListener != null && this.treeViewer != null) {
            this.treeViewer.addDoubleClickListener(this.fDoubleClickListener);
        }
    }

    public void handleEvent(Event event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ScriptComposite.this.treeViewer.refresh();
            }
        });
    }

    public ISelectionProvider getSelectionProvider() {
        return this.treeViewer;
    }
}

