/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ease.module;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class RequestUtils {
    public static Command getSetFeatureCommand(EObject targetElement, Object value, EStructuralFeature featureToSet) {
        ICommand setCommand;
        SetRequest req = new SetRequest(targetElement, featureToSet, value);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)targetElement);
        if (provider != null && (setCommand = provider.getEditCommand((IEditCommandRequest)req)) != null && setCommand.canExecute()) {
            return new ICommandProxy(setCommand);
        }
        return null;
    }

    public static void setFeatureWithRequest(EObject objectToModify, Object value, EStructuralFeature featureToSet) {
        Command setFeatureCommand = RequestUtils.getSetFeatureCommand(objectToModify, value, featureToSet);
        if (setFeatureCommand != null && setFeatureCommand.canExecute()) {
            setFeatureCommand.execute();
        }
    }

    public static <T extends EObject> T createElementWithRequest(EObject receiver, IElementType elementTypeToCreate, EReference containmentFeature) {
        ICommand createCommand;
        CreateElementRequest createElementRequest = containmentFeature == null ? new CreateElementRequest(receiver, elementTypeToCreate) : new CreateElementRequest(receiver, elementTypeToCreate, containmentFeature);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)receiver);
        if (provider != null && (createCommand = provider.getEditCommand((IEditCommandRequest)createElementRequest)) != null && createCommand.canExecute()) {
            try {
                createCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            CommandResult result = createCommand.getCommandResult();
            return RequestUtils.getCreatedObject(result);
        }
        return null;
    }

    public static <T extends EObject> T createElementWithRequest(EObject receiver, IElementType elementTypeToCreate) {
        return RequestUtils.createElementWithRequest(receiver, elementTypeToCreate, null);
    }

    public static <T extends EObject> T getCreatedObject(CommandResult commandResult) {
        Object objectResult = commandResult.getReturnValue();
        if (objectResult instanceof List) {
            List listResult = (List)objectResult;
            for (Object elementResult : listResult) {
                EObject newElement;
                CreateElementRequest request;
                if (!(elementResult instanceof CreateElementRequestAdapter) || (request = (CreateElementRequest)((CreateElementRequestAdapter)elementResult).getAdapter(CreateElementRequest.class)) == null || !((newElement = request.getNewElement()) instanceof EObject)) continue;
                return (T)newElement;
            }
        } else if (commandResult.getReturnValue() instanceof EObject) {
            return (T)((EObject)commandResult.getReturnValue());
        }
        return null;
    }

    public static void deleteObjectsWithRequest(List<EObject> objectsDelete) {
        for (EObject objectToDelete : objectsDelete) {
            RequestUtils.deleteObjectWithRequest(objectToDelete);
        }
    }

    public static void deleteObjectWithRequest(EObject objectToDelete) {
        ICommand deleteCommand;
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)objectToDelete);
        DestroyElementRequest request = new DestroyElementRequest(objectToDelete, true);
        if (provider != null && (deleteCommand = provider.getEditCommand((IEditCommandRequest)request)) != null && deleteCommand.canExecute()) {
            try {
                deleteCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

