/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ComponentInternalSourceToRepresentationDropBehaviorProvider
implements IInternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public Status drop(EObject droppedElement, EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (Status)new ComponentDropOutsideRepresentationBehaviorProviderSwitch(oldContainer, newContainer, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class ComponentDropOutsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<Status> {
        private final EObject oldContainer;
        private final EObject newContainer;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        ComponentDropOutsideRepresentationBehaviorProviderSwitch(EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.oldContainer = oldContainer;
            this.newContainer = newContainer;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public Status caseElement(Element droppedElement) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedElement.eContainmentFeature().getName();
                if (this.oldContainer.eClass().getEStructuralFeature(refName) != null && this.newContainer.eClass().getEStructuralFeature(refName) != null) {
                    Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedElement);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(this.newContainer, refName, droppedElement);
                    }
                    return dropStatus;
                }
            }
            return (Status)super.caseElement(droppedElement);
        }

        public Status caseProperty(Property droppedProperty) {
            EObject oldSemanticContainer;
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            Status dropStatus = null;
            if (this.oldContainer instanceof Component && this.newContainer instanceof Interface || this.oldContainer instanceof Interface && this.newContainer instanceof Component) {
                dropStatus = Status.createFailingStatus("Cannot drag and drop a Property from an Interface to a Component");
            } else if (this.oldContainer != this.newContainer && (oldSemanticContainer = droppedProperty.eContainer()) != null) {
                String refName = droppedProperty.eContainingFeature().getName();
                EObject newSemanticContainer = this.getPropertyNewSemanticContainer();
                if (newSemanticContainer != null) {
                    dropStatus = modifier.removeValue(oldSemanticContainer, refName, droppedProperty);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(newSemanticContainer, UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName(), droppedProperty);
                    }
                } else {
                    dropStatus = Status.createFailingStatus("Container should be a Structured Classifier or a Typed Property.");
                }
            }
            if (dropStatus == null) {
                dropStatus = (Status)super.caseProperty(droppedProperty);
            }
            return dropStatus;
        }

        private EObject getPropertyNewSemanticContainer() {
            EObject newSemanticContainer = null;
            if (this.newContainer instanceof Property) {
                Type type = ((Property)this.newContainer).getType();
                if (type instanceof StructuredClassifier) {
                    newSemanticContainer = type;
                }
            } else if (this.newContainer instanceof StructuredClassifier) {
                newSemanticContainer = this.newContainer;
            } else if (this.newContainer instanceof Interface) {
                newSemanticContainer = this.newContainer;
            }
            return newSemanticContainer;
        }
    }
}

