/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.base.utils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.transformation.base.Activator;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ApplyProfile
extends RecordingCommand {
    public static final String CMD_LABEL = "Apply %s profile";
    Package pkg;
    URI profileURI;

    public ApplyProfile(Package pkg, URI profileURI) {
        super(TransactionUtil.getEditingDomain((EObject)pkg), CMD_LABEL);
        this.pkg = pkg;
        this.profileURI = profileURI;
    }

    protected void doExecute() {
        try {
            Profile profile = (Profile)ElementUtils.loadPackage((URI)this.profileURI, (Element)this.pkg);
            if (profile != null && !profile.getOwnedStereotypes().isEmpty()) {
                this.pkg.applyProfile(profile);
            } else {
                Activator.log.info(String.format("Profile for URI %s is not available", this.profileURI));
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }
}

