/*****************************************************************************
 * Copyright (c) 2024 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Ansgar Radermacher
 *
 *****************************************************************************/
package org.eclipse.papyrus.designer.realtime.rtsymbols.profile;

import org.eclipse.emf.common.util.URI;

/**
 * Utility class to get informations about RTSymbols profile resources
 */
public final class RTSProfileResource {

	public static final String PROFILE_PATHMAP = "pathmap://PapyrusRealTimeSymbols_PROFILES/"; //$NON-NLS-1$

	public static final String PROFILE_PATH = PROFILE_PATHMAP + "RealTimeSymbols.profile.uml"; //$NON-NLS-1$

	public static final URI PROFILE_PATH_URI = URI.createURI(PROFILE_PATH);

	public static final String PROFILE_URI = "http://www.eclipse.org/papyrus/RealTimeSymbols/1"; //$NON-NLS-1$
}
