/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type;

import java.util.HashMap;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.ClassOrInterfaceType;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.type.Type;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.GenericVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public final class PrimitiveType
extends Type {
    static final HashMap<String, Primitive> unboxMap = new HashMap();
    private Primitive type;

    static {
        Primitive[] primitiveArray = Primitive.values();
        int n = primitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            Primitive unboxedType = primitiveArray[n2];
            unboxMap.put(unboxedType.nameOfBoxedType, unboxedType);
            ++n2;
        }
    }

    public PrimitiveType() {
    }

    public PrimitiveType(Primitive type) {
        this.type = type;
    }

    public PrimitiveType(int beginLine, int beginColumn, int endLine, int endColumn, Primitive type) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.type = type;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Primitive getType() {
        return this.type;
    }

    public ClassOrInterfaceType toBoxedType() {
        return this.type.toBoxedType();
    }

    public void setType(Primitive type) {
        this.type = type;
    }

    public static enum Primitive {
        Boolean("Boolean"),
        Char("Character"),
        Byte("Byte"),
        Short("Short"),
        Int("Integer"),
        Long("Long"),
        Float("Float"),
        Double("Double");

        final String nameOfBoxedType;

        public ClassOrInterfaceType toBoxedType() {
            return new ClassOrInterfaceType(this.nameOfBoxedType);
        }

        private Primitive(String nameOfBoxedType) {
            this.nameOfBoxedType = nameOfBoxedType;
        }
    }
}

