/**
 * Copyright (c) 2006 - 2016 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import java.util.Collection;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class JavaClassOperationsDeclaration {
  public static CharSequence javaClassOperationsDeclaration(final Classifier clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Collection<Operation> _ownedOperations = JavaOperations.getOwnedOperations(clazz);
      for(final Operation op : _ownedOperations) {
        {
          boolean _hasStereotype = GenUtils.hasStereotype(op, NoCodeGen.class);
          boolean _not = (!_hasStereotype);
          if (_not) {
            CharSequence _javaOperationDeclaration = JavaOperations.javaOperationDeclaration(op);
            _builder.append(_javaOperationDeclaration);
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
