/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.codesync.SyncStatus;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageCodegen;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.SyncInformation;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.TextEditorConstants;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Utils;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.FindTransition;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.ParameterModifiers;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.EStorageClass;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.StorageClass;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Volatile;
import org.eclipse.papyrus.designer.languages.cpp.reverse.CommentUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.ParameterUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class SyncCDTtoModel
implements Runnable {
    public static final String VOID_TYPE = "void";
    public static final String REGISTER = "register";
    public static final String CONST = "const";
    public static final String VOLATILE = "volatile";
    public static final String sAtParam = "@param";
    public static final String sAtReturn = "@return";
    public static final String ansiCLib = "AnsiCLibrary";
    protected IEditorInput m_input;
    protected Classifier m_classifier;
    protected String m_projectName;
    protected ILangCodegen m_codegen;
    IASTNodeSelector selector;
    public final String c_cpp_langID = "C/C++";

    public SyncCDTtoModel(IEditorInput input, Classifier classifier, String projectName, String generatorID) {
        this.m_input = input;
        this.m_classifier = classifier;
        this.m_projectName = projectName;
        this.m_codegen = LanguageCodegen.getGenerator((Pattern)TextEditorConstants.CPP, (String)generatorID);
    }

    public void syncCDTtoModel() {
        CommandSupport.exec((EObject)this.m_classifier, (String)"update model from CDT", (Runnable)this);
    }

    @Override
    public void run() {
        block11: {
            ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.m_input);
            SyncStatus.syncFromEditor = true;
            if (ice instanceof ITranslationUnit) {
                ICProject project = CoreModel.getDefault().getCModel().getCProject(this.m_projectName);
                IIndex index = null;
                try {
                    index = CCorePlugin.getIndexManager().getIndex(project);
                    index.acquireReadLock();
                    ITranslationUnit itu = (ITranslationUnit)ice;
                    IASTTranslationUnit ast = itu.getAST(index, 2);
                    this.selector = ast.getNodeSelector(null);
                    this.examineChildren(itu, (IParent)itu);
                    this.updateCppInclude(itu);
                    if (itu instanceof IWorkingCopy) {
                        ((IWorkingCopy)itu).reconcile(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CModelException e) {
                    Activator.log.error((Throwable)e);
                    if (index != null) {
                        index.releaseReadLock();
                    }
                    break block11;
                }
                catch (Exception e) {
                    try {
                        Activator.log.error((Throwable)e);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (index != null) {
                            index.releaseReadLock();
                        }
                    }
                }
                if (index == null) break block11;
                index.releaseReadLock();
            }
        }
        SyncStatus.syncFromEditor = false;
    }

    public void examineChildren(ITranslationUnit itu, IParent parent) throws CModelException {
        int position = 0;
        ICElement[] iCElementArray = parent.getChildren();
        int n = iCElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child instanceof IParent) {
                this.examineChildren(itu, (IParent)child);
            }
            ISourceRange range = null;
            if (child instanceof ISourceReference) {
                range = ((ISourceReference)child).getSourceRange();
            }
            if (child instanceof IFunctionDeclaration) {
                String name = ((IFunctionDeclaration)child).getElementName();
                IASTNode node = this.selector.findEnclosingNode(range.getStartPos(), range.getLength());
                if (node instanceof IASTFunctionDefinition) {
                    IASTFunctionDefinition definition = (IASTFunctionDefinition)node;
                    IASTFunctionDeclarator declarator = definition.getDeclarator();
                    String unfilteredBody = SyncCDTtoModel.getBody(itu, definition);
                    SyncInformation syncInfo = this.m_codegen.getSyncInformation(name, unfilteredBody);
                    String body = Utils.removeGenerated(unfilteredBody);
                    if (syncInfo == null || !syncInfo.isGenerated) {
                        NamedElement ne = this.updateMethod(position, parent, name, body, declarator, syncInfo);
                        this.updateComment(itu, definition, ne);
                    }
                }
                ++position;
            }
            ++n2;
        }
    }

    public void updateCppInclude(ITranslationUnit itu) {
        Include include;
        String contents = new String(itu.getContents());
        int preBodyStart = contents.indexOf("// Include from Include stereotype (pre-body)");
        int preBodyEnd = contents.indexOf("// End of Include stereotype (pre-body)");
        String preBody = "";
        String body = "";
        if (preBodyStart != -1 && preBodyEnd > (preBodyStart += "// Include from Include stereotype (pre-body)".length())) {
            preBody = contents.substring(preBodyStart, preBodyEnd).trim();
        }
        int bodyStart = contents.indexOf("// Include from Include declaration (body)");
        int bodyEnd = contents.indexOf("// End of Include declaration (body)");
        if (bodyStart != -1 && bodyEnd > (bodyStart += "// Include from Include declaration (body)".length() + 1)) {
            body = contents.substring(bodyStart, bodyEnd).trim();
        }
        if ((body.length() > 0 || preBody.length() > 0) && (include = (Include)StereotypeUtil.applyApp((Element)this.m_classifier, Include.class)) != null) {
            include.setPreBody(preBody);
            include.setBody(body);
        }
    }

    public NamedElement updateMethod(int position, IParent parent, String qualifiedName, String body, IASTFunctionDeclarator declarator, SyncInformation syncInfo) {
        String[] names = qualifiedName.split("::");
        String name = names[names.length - 1];
        Operation operation = null;
        Behavior behavior = null;
        if (syncInfo == null || syncInfo.behavior == null && syncInfo.createBehaviorName == null) {
            operation = this.getModelOperationFromName(name, parent, declarator, position);
            if (operation != null) {
                operation.setName(name);
            } else {
                behavior = FindTransition.findBehavior(this.m_classifier, name);
                if (behavior == null) {
                    if (this.m_classifier instanceof Class) {
                        operation = ((Class)this.m_classifier).createOwnedOperation(name, null, null);
                    } else if (this.m_classifier instanceof DataType) {
                        operation = ((DataType)this.m_classifier).createOwnedOperation(name, null, null);
                    }
                }
            }
        } else if (syncInfo.behavior != null) {
            behavior = syncInfo.behavior;
        } else if (syncInfo.createBehaviorName != null && this.m_classifier instanceof Class) {
            Class clazz = (Class)this.m_classifier;
            behavior = (OpaqueBehavior)clazz.createOwnedBehavior(syncInfo.createBehaviorName, UMLPackage.eINSTANCE.getOpaqueBehavior().eClass());
        }
        if (operation != null) {
            if (operation.getMethods().size() == 0) {
                if (this.m_classifier instanceof Class) {
                    behavior = ((Class)this.m_classifier).createOwnedBehavior(name, UMLPackage.eINSTANCE.getOpaqueBehavior());
                } else {
                    boolean cfr_ignored_0 = this.m_classifier instanceof DataType;
                }
                behavior.setSpecification((BehavioralFeature)operation);
                behavior.setIsReentrant(false);
            } else {
                behavior = (Behavior)operation.getMethods().get(0);
                if (!behavior.getName().equals(name)) {
                    behavior.setName(name);
                }
            }
        }
        this.updateParameters(declarator, (NamedElement)operation);
        if (behavior instanceof OpaqueBehavior) {
            this.updateParameters(declarator, (NamedElement)behavior);
            OpaqueBehavior ob = (OpaqueBehavior)behavior;
            if (ob.getBodies().size() == 0) {
                ob.getLanguages().add((Object)"C/C++");
                ob.getBodies().add((Object)"");
            }
            int i = 0;
            while (i < ob.getLanguages().size()) {
                String language = (String)ob.getLanguages().get(i);
                if ((TextEditorConstants.CPP.matcher(language).matches() || "C/C++".equals(language)) && i < ob.getBodies().size()) {
                    ob.getBodies().set(i, (Object)body);
                }
                ++i;
            }
        }
        if (operation != null) {
            return operation;
        }
        return behavior;
    }

    protected void updateParameters(IASTFunctionDeclarator declarator, NamedElement opOrBehavior) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        List existingParamList = ParameterUtils.getOwnedParametersCopy((NamedElement)opOrBehavior);
        IASTFunctionDefinition definition = (IASTFunctionDefinition)declarator.getParent();
        IASTNode[] iASTNodeArray = declarator.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode declaratorChild = iASTNodeArray[n2];
            if (declaratorChild instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)declaratorChild;
                IASTName parameterName = parameter.getDeclarator().getName();
                IASTDeclSpecifier parameterType = parameter.getDeclSpecifier();
                ParameterModifiers modifiers = new ParameterModifiers();
                String parameterTypeName = "";
                try {
                    IToken token = parameter.getDeclarator().getSyntax();
                    this.updateModifierFromParameter(token, modifiers);
                    token = parameterType.getSyntax();
                    parameterTypeName = this.updateModifierFromParameterType(token, parameterTypeName, modifiers);
                }
                catch (ExpansionOverlapsBoundaryException token) {
                    // empty catch block
                }
                parameterType.isRestrict();
                Parameter umlParameter = ParameterUtils.getParameterViaName((List)existingParamList, (String)parameterName.toString());
                Type umlType = this.getParameterType(parameterName, parameterTypeName, umlParameter);
                if (umlParameter == null) {
                    umlParameter = ParameterUtils.createOwnedParameter((NamedElement)opOrBehavior, (String)parameterName.toString(), (Type)umlType);
                } else {
                    umlParameter.setType(umlType);
                }
                this.applyParameterModifiers(parameterType, umlParameter, modifiers);
                paramList.add(umlParameter);
            }
            ++n2;
        }
        IASTDeclSpecifier declSpecifier = definition.getDeclSpecifier();
        String retTypeStr = declSpecifier.toString();
        ParameterModifiers retParamModifiers = new ParameterModifiers();
        IASTPointerOperator[] iASTPointerOperatorArray = declarator.getPointerOperators();
        int n3 = iASTPointerOperatorArray.length;
        int parameter = 0;
        while (parameter < n3) {
            IASTPointerOperator ptrOp = iASTPointerOperatorArray[parameter];
            try {
                this.updateModifierFromParameterType(ptrOp.getSyntax(), retTypeStr, retParamModifiers);
            }
            catch (ExpansionOverlapsBoundaryException expansionOverlapsBoundaryException) {
                // empty catch block
            }
            ++parameter;
        }
        if (!(retTypeStr == null || retTypeStr.length() <= 0 || retTypeStr.equals(VOID_TYPE) && declarator.getPointerOperators().length <= 0)) {
            Parameter umlRetParameter = ParameterUtils.getParameterViaName((List)existingParamList, null);
            Type retParamType = this.getParameterType(null, retTypeStr, umlRetParameter);
            if (umlRetParameter == null) {
                umlRetParameter = ParameterUtils.createReturnResult((NamedElement)opOrBehavior, (Type)retParamType);
            } else {
                umlRetParameter.setType(retParamType);
            }
            this.applyParameterModifiers(declSpecifier, umlRetParameter, retParamModifiers);
            paramList.add(umlRetParameter);
        }
        for (Parameter existingParam : existingParamList) {
            if (paramList.contains(existingParam)) continue;
            existingParam.destroy();
        }
        ParameterUtils.resetParameters((NamedElement)opOrBehavior, paramList);
    }

    protected void updateModifierFromParameter(IToken token, ParameterModifiers modifiers) {
        while (token != null) {
            String tokenStr = token.toString();
            if (tokenStr.equals("*")) {
                modifiers.isPointer = true;
            } else if (tokenStr.equals("&")) {
                modifiers.isRef = true;
            } else if (tokenStr.equals("[")) {
                while (token != null) {
                    modifiers.array = String.valueOf(modifiers.array) + token.toString();
                    token = token.getNext();
                }
                if (token == null) break;
            }
            token = token.getNext();
        }
    }

    protected String updateModifierFromParameterType(IToken token, String parameterTypeName, ParameterModifiers modifiers) {
        while (token != null) {
            String tokenStr = token.toString();
            if (tokenStr.equals("*")) {
                modifiers.isPointer = true;
            } else if (tokenStr.equals("&")) {
                modifiers.isRef = true;
            } else if (tokenStr.equals(REGISTER)) {
                modifiers.isRegister = true;
            } else if (!tokenStr.equals(CONST) && !tokenStr.equals(VOLATILE)) {
                if (((String)parameterTypeName).length() > 0) {
                    parameterTypeName = (String)parameterTypeName + " ";
                }
                parameterTypeName = (String)parameterTypeName + tokenStr;
            }
            token = token.getNext();
        }
        return parameterTypeName;
    }

    protected Type getParameterType(IASTName parameterName, String typeName, Parameter existingParameter) {
        String qParName;
        NamedElement namedElemParamType = ElementUtils.getQualifiedElement((Package)PackageUtil.getRootPackage((Element)this.m_classifier), (String)typeName);
        if (namedElemParamType == null && (namedElemParamType = ElementUtils.getQualifiedElementFromRS((Element)this.m_classifier, (URI)CppUriConstants.ANSIC_LIB_URI, (String)(qParName = "AnsiCLibrary::" + typeName))) == null && existingParameter != null) {
            return existingParameter.getType();
        }
        return namedElemParamType instanceof Type ? (Type)namedElemParamType : null;
    }

    public void applyParameterModifiers(IASTDeclSpecifier parameterType, Parameter umlParameter, ParameterModifiers modifiers) {
        StorageClass sc;
        if (parameterType.isConst()) {
            StereotypeUtil.apply((Element)umlParameter, Const.class);
        }
        if (parameterType.isVolatile()) {
            StereotypeUtil.apply((Element)umlParameter, Volatile.class);
        }
        if (modifiers.isRegister && (sc = (StorageClass)StereotypeUtil.applyApp((Element)umlParameter, StorageClass.class)) != null) {
            sc.setStorageClass(EStorageClass.REGISTER);
        }
        ParameterDirectionKind direction = umlParameter.getDirection();
        if (umlParameter.getUpper() == 1 && (direction == ParameterDirectionKind.IN_LITERAL || direction == ParameterDirectionKind.RETURN_LITERAL)) {
            Array arraySt;
            if (modifiers.isPointer) {
                StereotypeUtil.apply((Element)umlParameter, Ptr.class);
            } else if (modifiers.isRef) {
                StereotypeUtil.apply((Element)umlParameter, Ref.class);
            }
            if (modifiers.array.length() > 0 && (arraySt = (Array)StereotypeUtil.applyApp((Element)umlParameter, Array.class)) != null && !modifiers.array.equals("[]") && !modifiers.array.equals("[ ]")) {
                arraySt.setDefinition(modifiers.array);
            }
        }
    }

    public Operation getModelOperationFromName(String name, IParent parent, IASTFunctionDeclarator currentDecl, int position) {
        Operation operation = null;
        ArrayList<Operation> opListMatching = new ArrayList<Operation>();
        for (Operation op : this.m_classifier.getOperations()) {
            if (op.getName() == null || !op.getName().equals(name)) continue;
            opListMatching.add(op);
        }
        if (opListMatching.size() == 0) {
            if (position < this.m_classifier.getOperations().size()) {
                operation = (Operation)this.m_classifier.getOperations().get(position);
                String modelName = operation.getName();
                try {
                    ICElement[] iCElementArray = parent.getChildren();
                    int n = iCElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cdtName;
                        ICElement child = iCElementArray[n2];
                        if (child instanceof IMethodDeclaration && (cdtName = ((IMethodDeclaration)child).getElementName()).equals(modelName)) {
                            operation = null;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (CModelException child) {}
            }
        } else if (opListMatching.size() == 1) {
            operation = (Operation)opListMatching.get(0);
        } else {
            int pos = 0;
            int matchPos = -1;
            try {
                ICElement[] iCElementArray = parent.getChildren();
                int n = iCElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICElement child = iCElementArray[n3];
                    if (child instanceof IMethodDeclaration) {
                        String cdtName;
                        String[] names;
                        String shortName;
                        IASTFunctionDefinition fctDef;
                        IMethodDeclaration md = (IMethodDeclaration)child;
                        ISourceRange range = md.getSourceRange();
                        IASTNode node = this.selector.findEnclosingNode(range.getStartPos(), range.getLength());
                        if (node instanceof IASTFunctionDefinition && (fctDef = (IASTFunctionDefinition)node).getDeclarator() == currentDecl) {
                            matchPos = pos;
                        }
                        if ((shortName = (names = (cdtName = md.getElementName()).split("::"))[names.length - 1]).equals(name)) {
                            ++pos;
                        }
                    }
                    ++n3;
                }
            }
            catch (CModelException e) {
                Activator.log.error((Throwable)e);
            }
            if (matchPos >= 0 && matchPos < opListMatching.size()) {
                operation = (Operation)this.m_classifier.getOperations().get(matchPos);
            }
        }
        return operation;
    }

    public static String getBody(ITranslationUnit itu, IASTFunctionDefinition definition) {
        IASTStatement body = definition.getBody();
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement bodyComp = (IASTCompoundStatement)body;
            IASTFileLocation bodyLoc = bodyComp.getFileLocation();
            int start = bodyLoc.getNodeOffset();
            int end = start + bodyLoc.getNodeLength();
            char[] contents = itu.getContents();
            return StringUtils.decreaseIndent((char[])contents, (int)(start + 2), (int)(end - 2), (int)4);
        }
        return "";
    }

    public void updateComment(ITranslationUnit itu, IASTFunctionDefinition definition, NamedElement ne) {
        String comment = CommentUtils.getPreceedingComment((IASTNode)definition);
        if (comment.length() > 0) {
            comment = CommentUtils.cleanupComment((String)comment);
            int atParam = comment.indexOf(sAtParam);
            int atReturn = comment.indexOf(sAtReturn);
            int atParamOrReturn = atReturn != -1 && (atReturn < atParam || atParam == -1) ? atReturn : atParam;
            Object commentMethodOnly = atParamOrReturn != -1 ? comment.substring(0, atParamOrReturn).trim() : comment;
            while (atParam != -1) {
                int currentAtParam = atParam;
                String commentParam = (atParam = comment.indexOf(sAtParam, atParam + 1)) != -1 ? comment.substring(currentAtParam, atParam) : comment.substring(currentAtParam);
                int atParamName = sAtParam.length();
                while (atParamName < commentParam.length() && Character.isWhitespace(commentParam.charAt(atParamName))) {
                    ++atParamName;
                }
                int atParamNameEnd = atParamName;
                while (atParamNameEnd < commentParam.length() && !Character.isWhitespace(commentParam.charAt(atParamNameEnd))) {
                    ++atParamNameEnd;
                }
                if (atParamNameEnd >= commentParam.length() - 1) continue;
                String parameterName = commentParam.substring(atParamName, atParamNameEnd);
                String commentParamText = commentParam.substring(atParamNameEnd).trim();
                Parameter parameter = null;
                if (ne instanceof BehavioralFeature) {
                    parameter = ((BehavioralFeature)ne).getOwnedParameter(parameterName, null, false, false);
                } else if (ne instanceof Behavior) {
                    parameter = ((Behavior)ne).getOwnedParameter(parameterName, null, false, false);
                }
                if (parameter != null) {
                    Comment commentParamUML;
                    EList commentsParamUML = parameter.getOwnedComments();
                    if (commentsParamUML.size() == 0) {
                        commentParamUML = parameter.createOwnedComment();
                        commentParamUML.getAnnotatedElements().add((Object)commentParamUML);
                    } else {
                        commentParamUML = (Comment)commentsParamUML.get(0);
                    }
                    commentParamUML.setBody(commentParamText);
                    continue;
                }
                commentMethodOnly = (String)commentMethodOnly + "\n @param" + parameterName + " not found(!) " + commentParamText;
            }
            if (((String)commentMethodOnly).equals("*")) {
                commentMethodOnly = "";
            }
            EList commentsUML = ne.getOwnedComments();
            if (((String)commentMethodOnly).length() > 0) {
                Comment commentUML;
                if (commentsUML.size() == 0) {
                    commentUML = ne.createOwnedComment();
                    commentUML.getAnnotatedElements().add((Object)commentUML);
                } else {
                    commentUML = (Comment)commentsUML.get(0);
                }
                commentUML.setBody((String)commentMethodOnly);
            } else if (commentsUML.size() > 0) {
                ((Comment)commentsUML.get(0)).destroy();
            }
        }
    }

    public ILangCodegen getCodeGen() {
        return this.m_codegen;
    }
}

