/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.testutils;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.papyrus.designer.infra.ui.UIProjectManagement;
import org.eclipse.papyrus.designer.languages.common.testutils.FileComparison;
import org.eclipse.papyrus.designer.languages.common.testutils.RecursiveCopy;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.junit.utils.rules.AbstractHouseKeeperRule;
import org.eclipse.papyrus.junit.utils.rules.PapyrusEditorFixture;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.hamcrest.MatcherAssert;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TransformationTestSupport {
    protected AbstractHouseKeeperRule houseKeeper;
    protected PapyrusEditorFixture modelSetFixture;
    Class<?> testClass;

    static {
        System.setProperty("papyrus.run-headless", Boolean.TRUE.toString());
    }

    public TransformationTestSupport(Class<?> testClass, AbstractHouseKeeperRule houseKeeper, PapyrusEditorFixture modelSetFixture) {
        this.houseKeeper = houseKeeper;
        this.modelSetFixture = modelSetFixture;
        this.testClass = testClass;
    }

    public void runTransformation(String depPlanOrTrafoPkg) {
        NamedElement ne = ElementUtils.getQualifiedElement((Package)this.modelSetFixture.getModel(), (String)depPlanOrTrafoPkg);
        if (ne instanceof Package) {
            IProject project = UIProjectManagement.getCurrentProject();
            Package nePkg = (Package)ne;
            boolean genOptions = false;
            new ExecuteTransformationChain(nePkg, project).executeTransformation((IProgressMonitor)new NullProgressMonitor(), 0);
        }
    }

    public void validateResults(IProject genProject, String folderInTestBundle, String srcGen) {
        IProject modelProject = this.modelSetFixture.getProject().getProject();
        RecursiveCopy copier = new RecursiveCopy(this.houseKeeper);
        Bundle srcBundle = FrameworkUtil.getBundle(this.testClass);
        copier.copy(srcBundle, folderInTestBundle, modelProject, "expectedResult");
        IFolder expectedSrcGen = modelProject.getFolder("expectedResult");
        MatcherAssert.assertThat((String)"expected source folder must exist", (boolean)expectedSrcGen.exists());
        IProject generatedSrcGen = srcGen.equals(".") ? genProject : genProject.getFolder(srcGen);
        MatcherAssert.assertThat((String)"generated source folder must exist", (boolean)generatedSrcGen.exists());
        FileComparison.assertGeneratedMatchesExpected((IContainer)generatedSrcGen, (IContainer)expectedSrcGen);
    }
}

