/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import java.io.File;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.ModelLibrary;
import org.eclipse.xtend2.lib.StringConcatenation;

public class CommonScript {
    public static CharSequence genHeading(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* File generated from the ");
        String _qualifiedName = namedElement.getQualifiedName();
        _builder.append(_qualifiedName, " ");
        _builder.append(" uml class");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* Generated by the Papyrus C Generator (CEA LIST) ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        return _builder;
    }

    public static CharSequence packagePath(NamedElement element) {
        StringConcatenation _builder = new StringConcatenation();
        String _replace = element.getQualifiedName().replace(".", File.separator);
        _builder.append(_replace);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genComment(Element element) {
        StringConcatenation _xblockexpression = null;
        Object commentText = "";
        EList _ownedComments = element.getOwnedComments();
        for (Comment comment : _ownedComments) {
            String _commentText = commentText;
            String _cleanCR = GenUtils.cleanCR((String)comment.getBody());
            commentText = _commentText + _cleanCR;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* ");
        String _replaceAll = ((String)commentText).replaceAll("\n", "\n * ");
        _builder.append(_replaceAll, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public static CharSequence genAbstract(Class clazz) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAbstract = clazz.isAbstract();
        if (_isAbstract) {
            _builder.append("abstract ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genAbstract(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAbstract = operation.isAbstract();
        if (_isAbstract) {
            _builder.append("abstract ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genFinal(RedefinableElement redefinableElement) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isLeaf = redefinableElement.isLeaf();
        if (_isLeaf) {
            _builder.append("final ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence genStatic(Feature feature) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isStatic = feature.isStatic();
        if (_isStatic) {
            _builder.append("static ");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence HeaderPackageImportTemplate(PackageImport packageImport) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)packageImport.getImportedPackage(), ModelLibrary.class);
        if (_hasStereotype) {
            _builder.append("#include <");
            String _name = packageImport.getImportedPackage().getName();
            _builder.append(_name);
            _builder.append(".h> ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("#include ");
            String _name_1 = packageImport.getImportedPackage().getName();
            _builder.append(_name_1);
            _builder.append(".h");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence genName(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        String _genVisibility = CommonScript.genVisibility(namedElement);
        _builder.append(_genVisibility);
        CharSequence _genCoreName = CommonScript.genCoreName(namedElement);
        _builder.append((Object)_genCoreName);
        return _builder;
    }

    public static CharSequence genCoreName(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        String _replaceAll = namedElement.getName().replaceAll("/|\\.|~", "_");
        _builder.append(_replaceAll);
        return _builder;
    }

    public static String genVisibility(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        VisibilityKind _visibility = namedElement.getVisibility();
        boolean _equals = Objects.equals(_visibility, VisibilityKind.PRIVATE_LITERAL);
        if (_equals) {
            _builder.newLineIfNotEmpty();
            _builder.append("/* private */");
            _builder.newLine();
        } else {
            VisibilityKind _visibility_1 = namedElement.getVisibility();
            boolean _equals_1 = Objects.equals(_visibility_1, VisibilityKind.PROTECTED_LITERAL);
            if (_equals_1) {
                _builder.append("/* protected */");
                _builder.newLine();
                _builder.append("\t\t");
            }
        }
        return _builder.toString().trim();
    }

    public static CharSequence genIncludeSelf(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/* include header file*/");
        _builder.newLine();
        _builder.append("#include \"");
        CharSequence _genName = CommonScript.genName(namedElement);
        _builder.append((Object)_genName);
        _builder.append(".h\"");
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

