/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class MultiplicityScript {
  public static CharSequence genMultiplicity(final MultiplicityElement multiplicityElement) {
    StringConcatenation _builder = new StringConcatenation();
    {
      int _upper = multiplicityElement.getUpper();
      boolean _equals = (_upper == (-1));
      if (_equals) {
        _builder.append("[]");
        _builder.newLine();
      } else {
        int _upper_1 = multiplicityElement.getUpper();
        boolean _greaterThan = (_upper_1 > 1);
        if (_greaterThan) {
          _builder.append("[");
          String _string = Integer.valueOf(multiplicityElement.getUpper()).toString();
          _builder.append(_string);
          _builder.append("]");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
        }
      }
    }
    return _builder;
  }
}
