package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.languages.cpp.library.CppUriConstants;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;

/**
 * Enable ports that delegate to several inner parts/ports, see bug 531771
 * 
 * This delegation is bidirectional, i.e. applies to provided and required
 * ports (methods being called and methods that are calling, respectively)
 * 
 * For provided ports: return the reference to a broadcast class in the
 *   get_XXX methods.
 *   The user has to verify that the port of the composite has the right
 *   multiplicity.
 * 
 * For required ports: call all connect_XXX of inner parts in the connect_XXX
 *   of the class that owns inner parts.
 * 
 * Finally the createConnection method should handle connecting to a port that
 * returns a vector. In this case we expect the receptacle of the connection
 * to be of multiplicity several.
 */
@SuppressWarnings("all")
public class CreateMultiRefClass {
  private StaticCppToOO cppToOO;

  private LazyCopier copier;

  private static String progLang = "C++";

  public CreateMultiRefClass(final StaticCppToOO cppToOO, final LazyCopier copier) {
    this.cppToOO = cppToOO;
    this.copier = copier;
  }

  public String createDelegationProvided(final org.eclipse.uml2.uml.Class implementation, final List<ConnectorEnd> ces, final Port port, final String portName, final Interface providedIntf) {
    final String attributeName = (PrefixConstants.attributePrefix + portName);
    Property attr = implementation.getOwnedAttribute(attributeName, null);
    if (((attr == null) || (attr instanceof Port))) {
      final org.eclipse.uml2.uml.Class broadcastClass = this.getOrCreateBroadcastClass(providedIntf);
      attr = implementation.createOwnedAttribute(attributeName, broadcastClass);
      ValueSpecification _createDefaultValue = attr.createDefaultValue("default", attr.getType(), UMLPackage.Literals.LITERAL_STRING);
      final LiteralString defaultValue = ((LiteralString) _createDefaultValue);
      defaultValue.setValue("NULL");
      attr.setAggregation(AggregationKind.SHARED_LITERAL);
      return this.createDelegationConnCode(ces, broadcastClass, portName, providedIntf);
    }
    return "";
  }

  public String createDelegationConnCode(final List<ConnectorEnd> ces, final org.eclipse.uml2.uml.Class broadcastClass, final String portName, final Interface providedIntf) {
    StringConcatenation _builder = new StringConcatenation();
    final String attributeName = (PrefixConstants.attributePrefix + portName);
    _builder.newLineIfNotEmpty();
    _builder.append("// generated broadcast class uses generic port name");
    _builder.newLine();
    final String connectOpName = (PrefixConstants.connectQ_Prefix + "port");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("if (");
    _builder.append(attributeName);
    _builder.append(" == NULL) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append(attributeName, "\t");
    _builder.append(" = new ");
    String _qualifiedName = broadcastClass.getQualifiedName();
    _builder.append(_qualifiedName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      for(final ConnectorEnd ce : ces) {
        final Property part = ce.getPartWithPort();
        _builder.newLineIfNotEmpty();
        final ConnectableElement role = ce.getRole();
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        {
          if ((role instanceof Port)) {
            final Port rolePort = ((Port) role);
            _builder.newLineIfNotEmpty();
            {
              boolean _contains = rolePort.getProvideds().contains(providedIntf);
              if (_contains) {
                {
                  if (((rolePort.getProvideds().size() > 1) || ((rolePort.getProvideds().size() == 1) && (!(rolePort.getType() instanceof Interface))))) {
                    {
                      int _upper = part.getUpper();
                      boolean _greaterThan = (_upper > 1);
                      if (_greaterThan) {
                        {
                          int _upper_1 = part.getUpper();
                          ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _upper_1, true);
                          for(final Integer i : _doubleDotLessThan) {
                            _builder.append(attributeName);
                            _builder.append("->");
                            _builder.append(connectOpName);
                            _builder.append("(");
                            String _name = part.getName();
                            _builder.append(_name);
                            _builder.append("[");
                            _builder.append(i);
                            _builder.append("].");
                            _builder.append(PrefixConstants.getP_Prefix);
                            String _name_1 = ((Port)role).getName();
                            _builder.append(_name_1);
                            String _name_2 = providedIntf.getName();
                            _builder.append(_name_2);
                            _builder.append("());");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append(attributeName);
                        _builder.append("->");
                        _builder.append(connectOpName);
                        _builder.append("(");
                        String _nameRef = this.cppToOO.nameRef(part);
                        _builder.append(_nameRef);
                        _builder.append(PrefixConstants.getP_Prefix);
                        String _name_3 = ((Port)role).getName();
                        _builder.append(_name_3);
                        String _name_4 = providedIntf.getName();
                        _builder.append(_name_4);
                        _builder.append("());");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  } else {
                    {
                      int _upper_2 = part.getUpper();
                      boolean _greaterThan_1 = (_upper_2 > 1);
                      if (_greaterThan_1) {
                        {
                          int _upper_3 = part.getUpper();
                          ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _upper_3, true);
                          for(final Integer i_1 : _doubleDotLessThan_1) {
                            _builder.append(attributeName);
                            _builder.append("->");
                            _builder.append(connectOpName);
                            _builder.append("(");
                            String _name_5 = part.getName();
                            _builder.append(_name_5);
                            _builder.append("[");
                            _builder.append(i_1);
                            _builder.append("].");
                            _builder.append(PrefixConstants.getP_Prefix);
                            String _name_6 = ((Port)role).getName();
                            _builder.append(_name_6);
                            _builder.append("());");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append(attributeName);
                        _builder.append("->");
                        _builder.append(connectOpName);
                        _builder.append("(");
                        String _nameRef_1 = this.cppToOO.nameRef(part);
                        _builder.append(_nameRef_1);
                        _builder.append(PrefixConstants.getP_Prefix);
                        String _name_7 = ((Port)role).getName();
                        _builder.append(_name_7);
                        _builder.append("());");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
              }
            }
          } else {
            {
              if ((role instanceof Property)) {
                final Type roleType = ((Property) role).getType();
                _builder.newLineIfNotEmpty();
                {
                  if (((roleType instanceof BehavioredClassifier) && 
                    (((BehavioredClassifier) roleType).getInterfaceRealization(null, providedIntf) != null))) {
                    {
                      int _upper_4 = ((Property) role).getUpper();
                      boolean _greaterThan_2 = (_upper_4 > 1);
                      if (_greaterThan_2) {
                        {
                          int _upper_5 = ((Property) role).getUpper();
                          ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, _upper_5, true);
                          for(final Integer i_2 : _doubleDotLessThan_2) {
                            _builder.append(attributeName);
                            _builder.append("->");
                            _builder.append(connectOpName);
                            _builder.append("(");
                            String _name_8 = ((Property)role).getName();
                            _builder.append(_name_8);
                            _builder.append("[");
                            _builder.append(i_2);
                            _builder.append("]);");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      } else {
                        _builder.append(attributeName);
                        _builder.append("->");
                        _builder.append(connectOpName);
                        _builder.append("(");
                        String _name_9 = ((Property)role).getName();
                        _builder.append(_name_9);
                        _builder.append(");");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("return ");
    _builder.append(attributeName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  public String createDelegationRequired(final org.eclipse.uml2.uml.Class implementation, final String portName, final Interface requiredIntf) {
    final String attributeName = (PrefixConstants.attributePrefix + portName);
    final String opName = (PrefixConstants.connectQ_Prefix + "port");
    Property attr = implementation.getOwnedAttribute(attributeName, null);
    if (((attr == null) || (attr instanceof Port))) {
      final org.eclipse.uml2.uml.Class broadcastClass = this.getOrCreateBroadcastClass(requiredIntf);
      attr = implementation.createOwnedAttribute(attributeName, broadcastClass);
      ValueSpecification _createDefaultValue = attr.createDefaultValue("default", attr.getType(), UMLPackage.Literals.LITERAL_STRING);
      final LiteralString defaultValue = ((LiteralString) _createDefaultValue);
      defaultValue.setValue("NULL");
      this.cppToOO.applyRef(attr);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("if (!");
      _builder.append(attributeName);
      _builder.append(") {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append(attributeName, "\t");
      _builder.append(" = new ");
      String _qualifiedName = broadcastClass.getQualifiedName();
      _builder.append(_qualifiedName, "\t");
      _builder.append("();");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _builder.append(attributeName);
      _builder.append("->");
      _builder.append(opName);
      _builder.append("(ref);");
      _builder.newLineIfNotEmpty();
      return _builder.toString();
    }
    return "";
  }

  /**
   * Create a new broadcast class or create an existing
   */
  public org.eclipse.uml2.uml.Class getOrCreateBroadcastClass(final Interface intf) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Broadcast_");
    String _name = intf.getName();
    _builder.append(_name);
    final String broadcastClassName = _builder.toString();
    PackageableElement broadcastClass = intf.getNearestPackage().getPackagedElement(broadcastClassName);
    if ((broadcastClass instanceof org.eclipse.uml2.uml.Class)) {
      return ((org.eclipse.uml2.uml.Class) broadcastClass);
    } else {
      return this.createBroadcastClass(intf);
    }
  }

  /**
   * Create a broadcast class for a given interface. This class will manage multiple references for the
   * given interface and provide an API for calling each method of the interface.
   * The called operation is called for each stored reference. If there is a return value, only the
   * return value of the last call is returned.
   */
  public org.eclipse.uml2.uml.Class createBroadcastClass(final Interface intf) {
    final String opName = (PrefixConstants.connectQ_Prefix + "port");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Broadcast_");
    String _name = intf.getName();
    _builder.append(_name);
    final String broadcastClassName = _builder.toString();
    final org.eclipse.uml2.uml.Class broadcastClass = intf.getNearestPackage().createOwnedClass(broadcastClassName, false);
    broadcastClass.createInterfaceRealization(("broadcast" + intf), intf);
    PackageUtil.loadPackage(CppUriConstants.STL_LIB_URI, this.copier.source.eResource().getResourceSet());
    NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS(this.copier.source, PrefixConstants.TYPE_FOR_MULTI_RECEPTACLE);
    Type vector = ((Type) _qualifiedElementFromRS);
    if ((vector != null)) {
      vector = this.copier.<Type>getCopy(vector);
    } else {
      String _format = String.format(
        "Can not find type %s. Thus, unable to create suitable connect operation in component to OO transformation", 
        PrefixConstants.TYPE_FOR_MULTI_RECEPTACLE);
      throw new RuntimeException(_format);
    }
    Property references = broadcastClass.createOwnedAttribute("references", vector);
    final TemplateBinding tBinding = StereotypeUtil.<TemplateBinding>applyApp(references, TemplateBinding.class);
    tBinding.getActuals().add(this.cppToOO.createPtrType(intf));
    final Operation connectOperation = broadcastClass.createOwnedOperation(opName, null, null);
    final Parameter connectRefParam = connectOperation.createOwnedParameter("ref", intf);
    final Comment comment = connectRefParam.createOwnedComment();
    comment.setBody("Reference to provided port");
    this.cppToOO.applyRef(connectRefParam);
    Behavior _createOwnedBehavior = broadcastClass.createOwnedBehavior(opName, 
      UMLPackage.eINSTANCE.getOpaqueBehavior());
    final OpaqueBehavior connectBehavior = ((OpaqueBehavior) _createOwnedBehavior);
    connectOperation.getMethods().add(connectBehavior);
    connectBehavior.getLanguages().add(CreateMultiRefClass.progLang);
    EList<String> _bodies = connectBehavior.getBodies();
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("references.push_back(ref);");
    _builder_1.newLine();
    _bodies.add(_builder_1.toString());
    EList<Operation> _operations = intf.getOperations();
    for (final Operation operation : _operations) {
      {
        final BasicEList<String> parameterNames = new BasicEList<String>();
        final BasicEList<Type> parameterTypes = new BasicEList<Type>();
        final BasicEList<String> parameterNamesWithReturn = new BasicEList<String>();
        final BasicEList<Type> parameterTypesWithReturn = new BasicEList<Type>();
        EList<Parameter> _ownedParameters = operation.getOwnedParameters();
        for (final Parameter parameter : _ownedParameters) {
          {
            ParameterDirectionKind _direction = parameter.getDirection();
            boolean _notEquals = (!Objects.equals(_direction, ParameterDirectionKind.RETURN_LITERAL));
            if (_notEquals) {
              parameterNames.add(parameter.getName());
              parameterTypes.add(parameter.getType());
            }
            parameterNamesWithReturn.add(parameter.getName());
            parameterTypesWithReturn.add(parameter.getType());
          }
        }
        final Operation copiedOperation = EcoreUtil.<Operation>copy(operation);
        broadcastClass.getOwnedOperations().add(copiedOperation);
        Operation delegationOperation = copiedOperation;
        this.cppToOO.copyCppOperationAndParameterStereotypes(operation, copiedOperation);
        StringConcatenation _builder_2 = new StringConcatenation();
        String _name_1 = operation.getName();
        _builder_2.append(_name_1);
        _builder_2.append("(");
        _builder_2.newLineIfNotEmpty();
        {
          boolean _hasElements = false;
          for(final String parameterName : parameterNames) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder_2.appendImmediate(", ", "\t");
            }
            _builder_2.append("\t");
            _builder_2.append(parameterName, "\t");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t\t\t\t");
          }
        }
        _builder_2.append(")");
        _builder_2.newLineIfNotEmpty();
        String delegateOperationCall = _builder_2.toString().trim();
        int _size = parameterNamesWithReturn.size();
        int _size_1 = parameterNames.size();
        final boolean hasReturn = (_size > _size_1);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("for (unsigned int i = 0; i < references.size()");
        {
          if (hasReturn) {
            _builder_3.append(" - 1");
          }
        }
        _builder_3.append("; i++) {");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("\t");
        _builder_3.append("references[i]->");
        _builder_3.append(delegateOperationCall, "\t");
        _builder_3.append(";");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("}");
        _builder_3.newLine();
        {
          if (hasReturn) {
            _builder_3.append("return references[references.size() - 1]->");
            _builder_3.append(delegateOperationCall);
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
          }
        }
        final String delegationOperationBody = _builder_3.toString();
        Behavior _createOwnedBehavior_1 = broadcastClass.createOwnedBehavior(opName, 
          UMLPackage.eINSTANCE.getOpaqueBehavior());
        final OpaqueBehavior delegationOperationBehavior = ((OpaqueBehavior) _createOwnedBehavior_1);
        delegationOperation.getMethods().add(delegationOperationBehavior);
        delegationOperationBehavior.getLanguages().add(CreateMultiRefClass.progLang);
        delegationOperationBehavior.getBodies().add(delegationOperationBody);
      }
    }
    return broadcastClass;
  }
}
