/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.TestInfo;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.LanguageProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.languages.java.codegen.Activator;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Messages;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class LocateJavaProject {
    private static final String SRC = "src";
    public static final String LANGUAGE_NAME = "Java";
    private static final boolean Headless = TestInfo.runsHeadless();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IProject getTargetProject(PackageableElement pe, boolean createIfMissing) {
        IProject modelProject;
        block18: {
            Project javaProject;
            Package rootPkg = PackageUtil.getRootPackage((Element)pe);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            String projectName = null;
            if (GenUtils.hasStereotype((Element)rootPkg, Project.class) && (projectName = (javaProject = (Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class)).getProjectName()) != null && (projectName.equals(".") || projectName.equals(".."))) {
                LocateJavaProject.displayError("An error was encountered during code generation: invalid project name. The default project name will be chosen.");
                projectName = null;
            }
            if (projectName == null || projectName.isEmpty()) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.designer.languages.java.codegen");
                String prefix = prefs != null ? prefs.get("commentHeader", "org.eclipse.papyrus.javagen.") : "bad preferences.";
                projectName = String.valueOf(prefix) + rootPkg.getName();
            }
            if (!ResourcesPlugin.getWorkspace().validateName(projectName, 4).isOK()) {
                LocateJavaProject.displayError("An error was encountered during code generation: invalid project name");
                return null;
            }
            modelProject = null;
            try {
                modelProject = root.getProject(projectName);
            }
            catch (Exception e) {
                LocateJavaProject.displayError("An error was encountered during code generation: invalid project name");
                Activator.log.error((Throwable)e);
                return null;
            }
            if (!modelProject.exists()) {
                if (Headless) {
                    try {
                        modelProject.create(null);
                    }
                    catch (CoreException e) {
                        return null;
                    }
                } else {
                    if (!createIfMissing) return null;
                    if (!LocateJavaProject.openQuestion(Messages.LocateJavaProject_CreateTargetProjectTitle, String.format(Messages.LocateJavaProject_CreateTargetProjectDesc, projectName))) return null;
                    boolean bl = true;
                    boolean create = bl;
                    if (!create) return null;
                    ILangProjectSupport langSupport = LanguageProjectSupport.getProjectSupport((String)LANGUAGE_NAME);
                    if (langSupport == null) return null;
                    modelProject = langSupport.createProject(projectName);
                    langSupport.setSettings(modelProject, langSupport.initialConfigurationData());
                    if (modelProject == null) {
                        return null;
                    }
                }
            }
            if (!modelProject.isOpen()) {
                try {
                    modelProject.open(null);
                }
                catch (CoreException e) {
                    return null;
                }
            }
            if (modelProject.hasNature("org.eclipse.jdt.core.javanature")) return modelProject;
            if (!createIfMissing) return null;
            if (!Headless) {
                if (!LocateJavaProject.openQuestion(Messages.LocateJavaProject_ApplyCNatureTitle, Messages.LocateJavaProject_ApplyCNatureDesc)) return null;
            }
            boolean bl = true;
            boolean apply = bl;
            if (apply) break block18;
            return null;
        }
        try {
            IProjectDescription description = modelProject.getDescription();
            if (description == null) return modelProject;
            description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
            return modelProject;
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        return modelProject;
    }

    public static String getTargetSourceFolder(PackageableElement packageableElement, IProject project) {
        IJavaProject javaProject;
        if (project != null && packageableElement != null && (javaProject = JavaCore.create((IProject)project)) != null) {
            if (!javaProject.exists() && Headless) {
                return "src/";
            }
            Package rootPkg = PackageUtil.getRootPackage((Element)packageableElement);
            String sourceFolderName = GenUtils.getSourceFolder((Element)rootPkg);
            if (sourceFolderName != null && !sourceFolderName.isEmpty() && LocateJavaProject.createSourceFolder(javaProject, sourceFolderName = LocateJavaProject.trimOnceLeadTail(sourceFolderName, "/"))) {
                return String.valueOf(sourceFolderName) + "/";
            }
            if (LocateJavaProject.sourceFolderExists(javaProject, "")) {
                return "";
            }
            if (LocateJavaProject.sourceFolderExists(javaProject, SRC)) {
                return "src/";
            }
            if (LocateJavaProject.createSourceFolder(javaProject, sourceFolderName)) {
                return sourceFolderName;
            }
        }
        return "";
    }

    public static String getTargetPrefix(PackageableElement packageableElement) {
        if (packageableElement != null) {
            Package rootPkg = PackageUtil.getRootPackage((Element)packageableElement);
            String prefixName = null;
            if (GenUtils.hasStereotype((Element)rootPkg, Project.class) && (prefixName = ((Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class)).getPrefix()) != null && !prefixName.isEmpty() && !(prefixName = LocateJavaProject.trimOnceLeadTail(prefixName, ".")).isEmpty()) {
                String prefixPath = prefixName.replaceAll("\\.", "/");
                if (!Path.ROOT.isValidPath(prefixPath) || prefixPath.startsWith("/") || prefixPath.endsWith("/")) {
                    LocateJavaProject.displayError("An error was encountered during code generation: invalid prefix. No prefix will be used.");
                    return "";
                }
                return String.valueOf(prefixName) + ".";
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean sourceFolderExists(IJavaProject javaProject, String sourceFolderName) {
        try {
            IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
            if (classPathEntries == null) return false;
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (true) {
                IPath path;
                String pathString;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry pathEntry = iClasspathEntryArray[n2];
                int entryKind = pathEntry.getEntryKind();
                if (entryKind == 3 && (pathString = (path = pathEntry.getPath()).toString()).equals(String.valueOf(javaProject.getPath().toString()) + "/" + sourceFolderName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        return false;
    }

    private static boolean createSourceFolder(IJavaProject javaProject, String sourceFolderName) {
        if (sourceFolderName == null) {
            sourceFolderName = "";
        }
        if (!Path.ROOT.isValidPath(sourceFolderName) || sourceFolderName.startsWith("/") || sourceFolderName.endsWith("/")) {
            LocateJavaProject.displayError("An error was encountered during code generation: invalid source folder name. A default source folder will be chosen.");
            return false;
        }
        if (LocateJavaProject.sourceFolderExists(javaProject, sourceFolderName)) {
            return true;
        }
        try {
            IPath srcPath = javaProject.getPath().append(sourceFolderName);
            IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
            if (classPathEntries != null) {
                IClasspathEntry[] newEntries = new IClasspathEntry[classPathEntries.length + 1];
                System.arraycopy(classPathEntries, 0, newEntries, 0, classPathEntries.length);
                IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcPath, null);
                newEntries[classPathEntries.length] = JavaCore.newSourceEntry((IPath)srcEntry.getPath());
                javaProject.setRawClasspath(newEntries, null);
                return true;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            LocateJavaProject.displayError("An error was encountered during code generation: invalid source folder name. A default source folder will be chosen.");
            return false;
        }
        return false;
    }

    private static boolean openQuestion(final String title, final String message) {
        final boolean[] ret = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            }
        });
        return ret[0];
    }

    private static String trimOnceLeadTail(String name, String character) {
        String theName = name;
        if (theName != null && !theName.isEmpty()) {
            if ((theName = theName.trim()).startsWith(character)) {
                theName = theName.replaceFirst(character, "");
            }
            if (theName.endsWith(character)) {
                theName = theName.substring(0, theName.length() - 1);
            }
        }
        return theName;
    }

    private static void displayError(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 1);
                messageBox.setText("Code generation error");
                messageBox.setMessage(message);
                messageBox.open();
            }
        });
    }
}

