/*******************************************************************************
 * Copyright (c) 2006 - 2016 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Shuai Li (CEA LIST) <shuai.li@cea.fr> - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.java.codegen.preferences;

import org.eclipse.papyrus.designer.infra.base.StringConstants;

public class JavaCodeGenConstants {

	/**
	 * Suffix for generated header files
	 */
	public static final String P_JAVA_SUFFIX_KEY = "headSuffix"; //$NON-NLS-1$
	public static final String P_JAVA_SUFFIX_DVAL = "java"; //$NON-NLS-1$
	
	/**
	 * User defined comment header in generated files
	 */
	public static final String P_COMMENT_HEADER_KEY = "commentHeader"; //$NON-NLS-1$
	public static final String P_COMMENT_HEADER_DVAL =
			"// --------------------------------------------------------" + StringConstants.NL + //$NON-NLS-1$
			"// Code generated by Papyrus Java" + StringConstants.NL + //$NON-NLS-1$
			"// --------------------------------------------------------" + StringConstants.NL + StringConstants.NL; //$NON-NLS-1$

	/**
	 * Suffix for generated header files
	 */
	public static final String P_PROJECT_PREFIX_KEY = "commentHeader"; //$NON-NLS-1$
	public static final String P_PROJECT_PREFIX_DVAL = "org.eclipse.papyrus.javagen."; //$NON-NLS-1$
}
