/**
 * Copyright (c) 2014 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import com.google.common.base.Objects;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppParameter {
  public static CharSequence CppOperationParameters(final Operation operation, final boolean showDefault) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Parameter, Boolean> _function = new Function1<Parameter, Boolean>() {
        @Override
        public Boolean apply(final Parameter it) {
          ParameterDirectionKind _direction = it.getDirection();
          return Boolean.valueOf((!Objects.equal(_direction, ParameterDirectionKind.RETURN_LITERAL)));
        }
      };
      Iterable<Parameter> _filter = IterableExtensions.<Parameter>filter(operation.getOwnedParameters(), _function);
      boolean _hasElements = false;
      for(final Parameter ownedParameter : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _CppParameter = CppParameter.CppParameter(ownedParameter, showDefault);
        _builder.append(_CppParameter);
      }
    }
    return _builder;
  }

  /**
   * comment signature for a given behavior (e.g. effect within state machine)
   */
  public static CharSequence CppBehaviorParameters(final Behavior behavior, final boolean showDefault) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Parameter, Boolean> _function = new Function1<Parameter, Boolean>() {
        @Override
        public Boolean apply(final Parameter it) {
          ParameterDirectionKind _direction = it.getDirection();
          return Boolean.valueOf((!Objects.equal(_direction, ParameterDirectionKind.RETURN_LITERAL)));
        }
      };
      Iterable<Parameter> _filter = IterableExtensions.<Parameter>filter(behavior.getOwnedParameters(), _function);
      boolean _hasElements = false;
      for(final Parameter ownedParameter : _filter) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _CppParameter = CppParameter.CppParameter(ownedParameter, showDefault);
        _builder.append(_CppParameter);
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  /**
   * C++ parameter. Default values are added, if parameter showDefault is true (implementation signature
   */
  public static String CppParameter(final Parameter parameter, final boolean showDefault) {
    String _modCVQualifier = Modifier.modCVQualifier(parameter);
    String _modSCQualifier = Modifier.modSCQualifier(parameter);
    String _plus = (_modCVQualifier + _modSCQualifier);
    String _cppType = CppTypedElement.cppType(parameter);
    String _plus_1 = (_plus + _cppType);
    String _modPtr = Modifier.modPtr(parameter);
    String _plus_2 = (_plus_1 + _modPtr);
    String _modRef = Modifier.modRef(parameter);
    String _plus_3 = (_plus_2 + _modRef);
    String _dirInfo = Modifier.dirInfo(parameter);
    String _plus_4 = (_plus_3 + _dirInfo);
    String _plus_5 = (_plus_4 + " ");
    String _name = parameter.getName();
    String _plus_6 = (_plus_5 + _name);
    String _modArray = Modifier.modArray(parameter);
    String _plus_7 = (_plus_6 + _modArray);
    String _xifexpression = null;
    if (showDefault) {
      _xifexpression = CppParameter.defaultValue(parameter);
    } else {
      _xifexpression = "";
    }
    return (_plus_7 + _xifexpression);
  }

  /**
   * CppParameterCalculation for CDT
   */
  public static String CppParameterForCDT(final Parameter parameter) {
    String _modCVQualifier = Modifier.modCVQualifier(parameter);
    String _modSCQualifier = Modifier.modSCQualifier(parameter);
    String _plus = (_modCVQualifier + _modSCQualifier);
    String _cppQualifiedName = CppGenUtils.cgu(parameter).cppQualifiedName(parameter.getType());
    String _plus_1 = (_plus + _cppQualifiedName);
    String _modPtr = Modifier.modPtr(parameter);
    String _plus_2 = (_plus_1 + _modPtr);
    String _modRef = Modifier.modRef(parameter);
    String paramStr = (_plus_2 + _modRef);
    Array _stereotypeApplication = UMLUtil.<Array>getStereotypeApplication(parameter, Array.class);
    boolean _tripleNotEquals = (_stereotypeApplication != null);
    if (_tripleNotEquals) {
      String _paramStr = paramStr;
      paramStr = (_paramStr + "[]");
    }
    return paramStr;
  }

  public static String defaultValue(final Parameter parameter) {
    String _xifexpression = null;
    ValueSpecification _defaultValue = parameter.getDefaultValue();
    boolean _tripleNotEquals = (_defaultValue != null);
    if (_tripleNotEquals) {
      String _stringValue = parameter.getDefaultValue().stringValue();
      _xifexpression = (" = " + _stringValue);
    } else {
      _xifexpression = "";
    }
    return _xifexpression;
  }
}
