/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.templates;

import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.papyrus.designer.components.transformation.Activator;
import org.eclipse.papyrus.designer.components.transformation.Messages;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.TemplateUtils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;

public class ConnectorBinding {
    private static Type matchOtherEnd(Port port, Feature connector, Type actual, boolean isProvided) throws TransformationException {
        if (connector instanceof Connector) {
            return ConnectorBinding.matchOtherEnd(port, (Connector)connector, actual, isProvided);
        }
        if (connector instanceof Property) {
            return ConnectorBinding.matchOtherEnd(port, (Property)connector, actual, isProvided);
        }
        return null;
    }

    private static Type matchOtherEnd(Port port, Connector connector, Type actual, boolean isProvided) throws TransformationException {
        Activator.log.info(String.format("", port.getName()));
        boolean found = false;
        for (ConnectorEnd connEnd : connector.getEnds()) {
            ConnectableElement connElem = connEnd.getRole();
            if (!(connElem instanceof Port)) continue;
            Port otherPort = (Port)connElem;
            boolean isAssembly = connEnd.getPartWithPort() != null;
            Interface otherInterface = isProvided == isAssembly ? PortUtils.getRequired(otherPort) : PortUtils.getProvided(otherPort);
            Activator.log.info(String.format(Messages.ConnectorBinding_ConnectorsPort, otherInterface));
            if (otherInterface == null) continue;
            if (actual == null || actual == otherInterface) {
                actual = otherInterface;
                Activator.log.info(String.format(Messages.ConnectorBinding_InfoActualReturnIntfIs, actual.getQualifiedName()));
                found = true;
                continue;
            }
            if (actual == otherInterface) continue;
        }
        if (!found) {
            throw new TransformationException(String.format(Messages.ConnectorBinding_CannotFindConsistentBinding, port.getName(), connector.getName(), connector.getNamespace().getName(), actual != null ? actual.getName() : "null"));
        }
        return actual;
    }

    private static Type matchOtherEnd(Port port, Property partConnector, Type actual, boolean isProvided) throws TransformationException {
        Activator.log.info(String.format(Messages.ConnectorBinding_InfoMatchOtherEnd, port.getName()));
        for (Connector connector : partConnector.getClass_().getOwnedConnectors()) {
            ConnectorEnd connEnd;
            ConnectableElement connElem;
            if (!ConnectorUtil.connectsPart((Connector)connector, (Property)partConnector) || !((connElem = (connEnd = ConnectorUtil.connEndNotPart((Connector)connector, (Property)partConnector)).getRole()) instanceof Port)) continue;
            Port otherPort = (Port)connElem;
            boolean isAssembly = connEnd.getPartWithPort() != null;
            Interface otherInterface = isProvided == isAssembly ? PortUtils.getRequired(otherPort) : PortUtils.getProvided(otherPort);
            Activator.log.info(String.format(Messages.ConnectorBinding_InfoConnectsPort, otherInterface));
            if (otherInterface == null) continue;
            if (actual == null) {
                actual = otherInterface;
                Activator.log.info(String.format(Messages.ConnectorBinding_InfoActualReturnIntfIs, actual.getQualifiedName()));
                continue;
            }
            if (actual == otherInterface) continue;
            throw new TransformationException(String.format(Messages.ConnectorBinding_CannotFindConsistentBinding, port.getName(), connector.getName(), connector.getNamespace().getName(), actual.getName()));
        }
        return actual;
    }

    public static Type getActual(Feature partOrConnector, Class template, ParameterableElement formal) throws TransformationException {
        Type actual = null;
        for (Port port : PortUtils.getAllPorts((EncapsulatedClassifier)template)) {
            Interface requiredIntf;
            Interface providedIntf = PortUtils.getProvided(port);
            if (providedIntf == formal) {
                actual = ConnectorBinding.matchOtherEnd(port, partOrConnector, actual, true);
            }
            if ((requiredIntf = PortUtils.getRequired(port)) == formal) {
                actual = ConnectorBinding.matchOtherEnd(port, partOrConnector, actual, false);
            }
            Type type = PortUtils.getFCMType(port);
            if (providedIntf == formal || requiredIntf == formal || type != formal) continue;
            Activator.log.info(String.format(Messages.ConnectorBinding_InfoProvidedPortTypeMatches, port.getName()));
            boolean found = false;
            if (partOrConnector instanceof Property) {
                Property partConnector = (Property)partOrConnector;
                for (Connector connector : partConnector.getClass_().getOwnedConnectors()) {
                    ConnectorEnd connEnd;
                    if (!ConnectorUtil.connectsPart((Connector)connector, (Property)partConnector) || (actual = ConnectorBinding.matchViaEnd(connEnd = ConnectorUtil.connEndNotPart((Connector)connector, (Property)partConnector), port, partOrConnector, actual)) == null) continue;
                    found = true;
                    break;
                }
            } else {
                for (ConnectorEnd connEnd : ((Connector)partOrConnector).getEnds()) {
                    actual = ConnectorBinding.matchViaEnd(connEnd, port, partOrConnector, actual);
                    if (actual == null) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            String errorMsg = ConnectorBinding.createErrorMsg(port, partOrConnector);
            throw new TransformationException(errorMsg);
        }
        return actual;
    }

    protected static String createErrorMsg(Port port, Feature partOrConnector) {
        String errorMsg = String.format(Messages.ConnectorBinding_CannotFindBindingForPort, port.getName(), partOrConnector.getName());
        for (Classifier cl : partOrConnector.getFeaturingClassifiers()) {
            errorMsg = String.valueOf(errorMsg) + " of class '" + cl.getName() + "'";
        }
        errorMsg = String.valueOf(errorMsg) + ". ";
        return errorMsg;
    }

    private static Type matchViaEnd(ConnectorEnd connEnd, Port port, Feature partOrConnector, Type actual) throws TransformationException {
        String errorMsg = ConnectorBinding.createErrorMsg(port, partOrConnector);
        ConnectableElement connElem = connEnd.getRole();
        if (connElem instanceof Port) {
            boolean sameConjugation;
            Port otherPort = (Port)connElem;
            Activator.log.info(String.format(Messages.ConnectorBinding_InfoConnPortConnectedVia, port.getName(), partOrConnector.getName()));
            Type otherType = PortUtils.getFCMType(otherPort);
            boolean isAssembly = connEnd.getPartWithPort() != null;
            boolean bl = sameConjugation = otherPort.isConjugated() == port.isConjugated();
            if (isAssembly == sameConjugation) {
                return actual;
            }
            if (!PortUtils.sameKinds(port, otherPort)) {
                return actual;
            }
            if (otherType != null) {
                if (actual == null) {
                    actual = otherType;
                    Activator.log.info(String.format(Messages.ConnectorBinding_InfoActualReturnIntfIs, actual.getQualifiedName()));
                } else if (actual != otherType) {
                    throw new TransformationException(String.valueOf(errorMsg) + " " + String.format(Messages.ConnectorBinding_FormalAlreadyBound, actual.getName()));
                }
            }
        }
        return actual;
    }

    public static TemplateBinding obtainBinding(Class composite, Feature connectorPart, Class template, boolean createBinding) throws TransformationException {
        TemplateBinding binding;
        TemplateSignature signature = TemplateUtils.getSignature((TemplateableElement)template);
        if (signature == null) {
            Activator.log.info(String.format(Messages.ConnectorBinding_NoTemplateSignature, template.getName()));
            return null;
        }
        BasicEList actuals = new BasicEList();
        Package pkgTemplate = (Package)signature.getOwner();
        String name = pkgTemplate.getName();
        boolean firstTP = true;
        for (TemplateParameter parameter : signature.getParameters()) {
            ParameterableElement formal = parameter.getParameteredElement();
            Type actual = null;
            if (firstTP) {
                actual = ConnectorBinding.getActual(connectorPart, template, formal);
                firstTP = false;
            } else if (formal instanceof NamedElement) {
                NamedElement formalNE = (NamedElement)formal;
                if (formal instanceof Class && formalNE.getName().equals("T")) {
                    actual = composite;
                }
                if (formal instanceof Port && formalNE.getName().equals("P")) {
                    actual = null;
                }
            }
            if (actual instanceof NamedElement) {
                actuals.add((Object)actual);
                name = String.valueOf(name) + "_" + ((NamedElement)actual).getName();
                continue;
            }
            String reason = String.format(Messages.ConnectorBinding_CannotFindBinding, ((NamedElement)formal).getName(), composite.getName(), connectorPart.getName(), template.getName());
            throw new TransformationException(reason);
        }
        if (!createBinding) {
            return null;
        }
        Package root = TransformationContext.current.modelRoot;
        Package boundPackage = (Package)root.getMember(name);
        if (boundPackage == null) {
            boundPackage = root.createNestedPackage(name);
            Activator.log.info(String.format(Messages.ConnectorBinding_InfoCreateBoundPackage, name, root.getName()));
        }
        if ((binding = boundPackage.getTemplateBinding(signature)) == null) {
            binding = boundPackage.createTemplateBinding(signature);
            Iterator actualsIter = actuals.iterator();
            for (TemplateParameter parameter : signature.getParameters()) {
                TemplateParameterSubstitution substitution = binding.createParameterSubstitution();
                substitution.setFormal(parameter);
                ParameterableElement actual = (ParameterableElement)actualsIter.next();
                substitution.setActual(actual);
            }
        }
        return binding;
    }
}

