/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.transformation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ILocationStrategy;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GenerationModeKind;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.Project;
import org.eclipse.papyrus.designer.languages.java.codegen.Activator;
import org.eclipse.papyrus.designer.languages.java.codegen.Messages;
import org.eclipse.papyrus.designer.languages.java.codegen.preferences.JavaCodeGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.transformation.JavaLocationStrategy;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.LocateJavaProject;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaClassifierGenerator;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.ExternLibrary;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.ManualGeneration;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.NoCodeGen;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Template;
import org.eclipse.papyrus.infra.tools.file.IPFileSystemAccess;
import org.eclipse.papyrus.infra.tools.file.ProjectBasedFileAccess;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JavaModelElementsCreator
extends ModelElementsCreator {
    public static final String TMP_SOURCE_FOLDER = "tmp-codegen";
    private static final String JAVA = "Java";
    private String generationFolder;
    private String sourceFolder;
    private String targetFolder;
    private String prefix;
    protected String javaExt;
    protected String commentHeader;

    public JavaModelElementsCreator(IProject project, PackageableElement packageableElement) {
        this(project, null, packageableElement);
    }

    public JavaModelElementsCreator(IProject project, String commentHeader, PackageableElement packageableElement) {
        this((IPFileSystemAccess)new ProjectBasedFileAccess(project), commentHeader);
        this.project = project;
        this.init(project, packageableElement);
    }

    private void init(IProject project, PackageableElement packageableElement) {
        GenerationModeKind mode;
        this.generationFolder = LocateJavaProject.getTargetSourceFolder(packageableElement, project);
        this.targetFolder = new String(this.generationFolder);
        Package rootPkg = PackageUtil.getRootPackage((Element)packageableElement);
        if (GenUtils.hasStereotype((Element)rootPkg, Project.class) && (mode = ((Project)UMLUtil.getStereotypeApplication((Element)rootPkg, Project.class)).getGenerationMode()).getValue() == 1 && project.getFolder(this.generationFolder).exists()) {
            this.generationFolder = "tmp-codegen_" + System.currentTimeMillis() + "/";
        }
        this.sourceFolder = new String(this.generationFolder);
        this.prefix = LocateJavaProject.getTargetPrefix(packageableElement);
        if (this.prefix != null) {
            this.generationFolder = String.valueOf(this.generationFolder) + this.prefix.replaceAll("\\.", "/");
        } else {
            this.prefix = "";
        }
    }

    public JavaModelElementsCreator(IPFileSystemAccess fileSystemAccess, String commentHeader) {
        super(fileSystemAccess, (ILocationStrategy)new JavaLocationStrategy(), JAVA);
        this.commentHeader = commentHeader != null ? commentHeader : JavaCodeGenUtils.getCommentHeader();
        this.javaExt = JavaCodeGenUtils.getHeaderSuffix();
    }

    protected void createPackageableElementFile(PackageableElement element, IProgressMonitor monitor) {
        if (!(element instanceof PrimitiveType) && !(element instanceof Usage)) {
            if (element instanceof Classifier) {
                this.generateClassifier((Classifier)element, this.prefix);
            } else if (!(element instanceof Relationship || element instanceof Signal || element instanceof SignalEvent)) {
                Activator.log.debug("Java code generator: unsupported model element " + element);
            }
        }
    }

    protected void generateClassifier(Classifier classifier, String prefix) {
        if (GenUtils.hasStereotype((Element)classifier, ManualGeneration.class)) {
            Import javaImport = (Import)UMLUtil.getStereotypeApplication((Element)classifier, Import.class);
            String includes = "";
            if (javaImport != null) {
                includes = javaImport.getManualImports();
            }
            String fileContentH = String.valueOf(this.commentHeader) + includes;
            String fileNameH = String.valueOf(this.generationFolder) + this.locStrategy.getFileName((NamedElement)classifier) + "." + this.javaExt;
            this.generateFile(fileNameH, fileContentH);
        } else if (!(this.noCodeGen((Element)classifier) || this.isTemplate(classifier) || classifier instanceof Association)) {
            String classHeaderFileName = String.valueOf(this.generationFolder) + this.locStrategy.getFileName((NamedElement)classifier) + "." + this.javaExt;
            this.generateFile(classHeaderFileName, String.valueOf(this.commentHeader) + JavaClassifierGenerator.generateClassCode(classifier, prefix));
        }
    }

    protected void generateFile(String fileName, String content) {
        this.fileSystemAccess.generateFile(fileName, JavaModelElementsCreator.format(content));
    }

    private static String format(String content) {
        Document doc;
        if (Platform.getBundle((String)"org.eclipse.jdt.core") == null) {
            return content;
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        TextEdit edit = codeFormatter.format(8, (doc = new Document(content)).get(), 0, doc.get().length(), 0, null);
        if (edit == null) {
            Activator.log.debug(Messages.JavaModelElementsCreator_CannotFormatContent);
            return content;
        }
        try {
            edit.apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            Activator.log.error((Throwable)e);
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    protected boolean noCodeGen(Element element) {
        return GenUtils.hasStereotype((Element)element, NoCodeGen.class) || GenUtils.hasStereotype((Element)element, External.class) || GenUtils.hasStereotypeTree((Element)element, ExternLibrary.class);
    }

    protected boolean isTemplate(Classifier classifier) {
        return !classifier.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getTemplateBinding()).isEmpty() || GenUtils.hasStereotype((Element)classifier, Template.class);
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }
}

