/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum InteractionItemKind implements Enumerator
{
    DATA(0, "DATA", "DATA"),
    INTERFACE(1, "INTERFACE", "INTERFACE");

    public static final int DATA_VALUE = 0;
    public static final int INTERFACE_VALUE = 1;
    private static final InteractionItemKind[] VALUES_ARRAY;
    public static final List<InteractionItemKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InteractionItemKind[]{DATA, INTERFACE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InteractionItemKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionItemKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionItemKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InteractionItemKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InteractionItemKind get(int value) {
        switch (value) {
            case 0: {
                return DATA;
            }
            case 1: {
                return INTERFACE;
            }
        }
        return null;
    }

    private InteractionItemKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

