/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.types.profile.UCMTypes.Types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PrimitiveFloatKind implements Enumerator
{
    FLOAT(0, "FLOAT", "FLOAT"),
    DOUBLE(1, "DOUBLE", "DOUBLE"),
    LONGDOUBLE(2, "LONGDOUBLE", "LONGDOUBLE");

    public static final int FLOAT_VALUE = 0;
    public static final int DOUBLE_VALUE = 1;
    public static final int LONGDOUBLE_VALUE = 2;
    private static final PrimitiveFloatKind[] VALUES_ARRAY;
    public static final List<PrimitiveFloatKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PrimitiveFloatKind[]{FLOAT, DOUBLE, LONGDOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PrimitiveFloatKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveFloatKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveFloatKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PrimitiveFloatKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PrimitiveFloatKind get(int value) {
        switch (value) {
            case 0: {
                return FLOAT;
            }
            case 1: {
                return DOUBLE;
            }
            case 2: {
                return LONGDOUBLE;
            }
        }
        return null;
    }

    private PrimitiveFloatKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

