/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public abstract class UnconnectedPorts
extends AbstractModelConstraint {
    public IStatus validatePorts(IValidationContext ctx, boolean required) {
        String portsStr = "";
        Property attribute = (Property)ctx.getTarget();
        Class owner = attribute.getClass_();
        if (owner != null && attribute.getType() instanceof Class) {
            Class class_ = (Class)attribute.getType();
            for (Port port : class_.getOwnedPorts()) {
                if ((port.getRequireds().size() <= 0 || !required) && (port.getProvideds().size() <= 0 || required)) continue;
                boolean found = false;
                for (Connector connector : owner.getOwnedConnectors()) {
                    if (!ConnectorUtil.connectsPort((Connector)connector, (Port)port)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (portsStr.length() != 0) {
                    portsStr = String.valueOf(portsStr) + ", ";
                }
                portsStr = String.valueOf(portsStr) + port.getName();
            }
        }
        if (portsStr.length() > 0) {
            return ctx.createFailureStatus(new Object[]{"The port(s) '" + portsStr + "' of part '" + attribute.getName() + "' remains unconnected within composite class '" + owner.getQualifiedName() + "'"});
        }
        return ctx.createSuccessStatus();
    }
}

