/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EStorageClass implements Enumerator
{
    VOLATILE(0, "volatile", "volatile"),
    REGISTER(1, "register", "register"),
    EXTERN(2, "extern", "extern");

    public static final int VOLATILE_VALUE = 0;
    public static final int REGISTER_VALUE = 1;
    public static final int EXTERN_VALUE = 2;
    private static final EStorageClass[] VALUES_ARRAY;
    public static final List<EStorageClass> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EStorageClass[]{VOLATILE, REGISTER, EXTERN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EStorageClass get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EStorageClass result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EStorageClass getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EStorageClass result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EStorageClass get(int value) {
        switch (value) {
            case 0: {
                return VOLATILE;
            }
            case 1: {
                return REGISTER;
            }
            case 2: {
                return EXTERN;
            }
        }
        return null;
    }

    private EStorageClass(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

