/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.ucm.ui.dialogs;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.designer.transformation.ui.provider.QNameLabelProvider;
import org.eclipse.papyrus.designer.ucm.core.provider.UCMContentProviderWithUndef;
import org.eclipse.papyrus.designer.ucm.core.provider.UCMLabelProvider;
import org.eclipse.papyrus.designer.ucm.core.utils.BindingUtils;
import org.eclipse.papyrus.designer.ucm.core.utils.PortUtils;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_components.PortTypeSpec;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.IPortType;
import org.eclipse.papyrus.designer.ucm.profile.UCMProfile.ucm_interactions.PortType;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PortConfigurationDialog
extends AbstractElementListSelectionDialog {
    public static final String SELECT_ACTUAL = "Select Actual";
    protected Port port;
    protected Type currentType;
    protected Text m_description;
    protected FilteredList fUpper;
    protected Group fLowerGroup;

    public PortConfigurationDialog(Shell parent, Port port) {
        super(parent, null);
        this.port = port;
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.setTitle("UCM Port Configuration");
        UCMContentProviderWithUndef contentProvider = new UCMContentProviderWithUndef(PackageUtil.getRootPackage((Element)this.port), UMLPackage.eINSTANCE.getClass_(), PortType.class);
        Group fUpperGroup = new Group(contents, 0);
        fUpperGroup.setLayout((Layout)new GridLayout());
        fUpperGroup.setText(" Port type ");
        this.createFilterText((Composite)fUpperGroup);
        this.fUpper = this.createFilteredList((Composite)fUpperGroup);
        this.fUpper.setLabelProvider((ILabelProvider)new QNameLabelProvider());
        this.fUpper.setElements(contentProvider.getElements());
        PortTypeSpec portTypeSpec = this.getPortTypeSpec();
        this.currentType = portTypeSpec != null && portTypeSpec.getType() != null ? portTypeSpec.getType().getBase_Class() : UCMContentProviderWithUndef.getUndef();
        this.fUpper.setSelection(new Object[]{this.currentType});
        this.fLowerGroup = new Group(contents, 0);
        this.fLowerGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        this.fLowerGroup.setLayoutData((Object)gridData);
        this.fLowerGroup.setText(" Bindings ");
        this.updateLower();
        return contents;
    }

    protected void updateLower() {
        Control[] controlArray = this.fLowerGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        EList<Type> abstractTypes = this.getAbstractTypes();
        if (abstractTypes != null) {
            for (final Type formal : abstractTypes) {
                this.createLabel((Composite)this.fLowerGroup, String.format("Binding for %s:", formal.getName()));
                Type actual = BindingUtils.getActual((PortTypeSpec)this.getPortTypeSpec(), (Type)formal);
                final Label actualLabel = this.createLabel((Composite)this.fLowerGroup, actual != null ? actual.getName() : "<undefined>");
                Button b = new Button((Composite)this.fLowerGroup, 0);
                b.setText(SELECT_ACTUAL);
                b.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        UCMContentProviderWithUndef uc = new UCMContentProviderWithUndef((Package)PortConfigurationDialog.this.port.getModel(), formal.eClass());
                        TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
                        dialog.setLabelProvider((ILabelProvider)new UCMLabelProvider());
                        dialog.setContentProvider((ITreeContentProvider)new EncapsulatedContentProvider((IStructuredContentProvider)uc));
                        dialog.setTitle(PortConfigurationDialog.SELECT_ACTUAL);
                        int code = dialog.open();
                        if (code == 0) {
                            Type result = (Type)dialog.getResult()[0];
                            if (result != UCMContentProviderWithUndef.getUndef()) {
                                BindingUtils.setActual((PortTypeSpec)PortConfigurationDialog.this.getPortTypeSpec(), (Type)formal, (Type)result);
                            } else {
                                BindingUtils.resetActual((PortTypeSpec)PortConfigurationDialog.this.getPortTypeSpec(), (Type)formal);
                            }
                            actualLabel.setText(result.getName());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }
                });
            }
        }
        this.fLowerGroup.pack();
    }

    protected PortTypeSpec getPortTypeSpec() {
        Type typeSpec = this.port.getType();
        if (typeSpec != null) {
            return (PortTypeSpec)UMLUtil.getStereotypeApplication((Element)typeSpec, PortTypeSpec.class);
        }
        return null;
    }

    protected void updateOkState() {
        super.updateOkState();
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected void computeResult() {
        Object[] result = new Object[]{this.getSelectedElement()};
        this.setResult(Arrays.asList(result));
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection() && this.getSelectedElement() != null) {
            this.buttonPressed(0);
        }
    }

    protected void handleSelectionChanged() {
        if (this.fUpper.getSelection().length > 0 && this.fUpper.getSelection()[0] != this.currentType) {
            this.currentType = (Type)this.fUpper.getSelection()[0];
            if (this.currentType != null) {
                if (this.currentType != UCMContentProviderWithUndef.getUndef()) {
                    IPortType portType;
                    PortTypeSpec portTypeSpec = this.getPortTypeSpec();
                    if (portTypeSpec == null) {
                        portTypeSpec = PortUtils.createPortTypeSpec((Port)this.port);
                        this.port.setType((Type)portTypeSpec.getBase_Class());
                    }
                    if ((portType = (IPortType)UMLUtil.getStereotypeApplication((Element)this.currentType, IPortType.class)) != portTypeSpec.getType()) {
                        portTypeSpec.setType(portType);
                        portTypeSpec.getBase_Class().getOwnedAttributes().clear();
                    }
                } else {
                    PortTypeSpec portTypeSpec = this.getPortTypeSpec();
                    if (portTypeSpec != null) {
                        portTypeSpec.getBase_Class().destroy();
                    }
                    this.port.setType(null);
                }
                this.updateLower();
            }
        }
        super.handleSelectionChanged();
    }

    protected Object getSelectedElement() {
        return this.fFilteredList.getSelection();
    }

    protected EList<Type> getAbstractTypes() {
        if (this.getPortTypeSpec() != null) {
            return BindingUtils.getAbstractTypes((IPortType)this.getPortTypeSpec().getType());
        }
        return null;
    }
}

