/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.codegen.ui.ChooseGenerator;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangCodegen;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.GeneratorHint;
import org.eclipse.papyrus.designer.transformation.base.utils.ProjectManagement;
import org.eclipse.papyrus.designer.transformation.core.transformations.ExecuteTransformationChain;
import org.eclipse.papyrus.designer.transformation.ui.Messages;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class ExecuteTransformationChainHandler
extends CmdHandler {
    private Package selectedCDP;
    private IProject project;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (this.selectedEObject instanceof Package) {
            this.selectedCDP = (Package)this.selectedEObject;
            this.project = ProjectManagement.getCurrentProject();
            Job job = new Job(Messages.ExecuteTransformationChainHandler_EXECUTE_CHAIN){

                public IStatus run(IProgressMonitor monitor) {
                    ILangCodegen generator;
                    boolean hasHint = GenUtils.hasStereotypeTree((Element)ExecuteTransformationChainHandler.this.selectedCDP, GeneratorHint.class);
                    if (!hasHint && (generator = ChooseGenerator.choose((Pattern)Pattern.compile(".*"), (PackageableElement)ExecuteTransformationChainHandler.this.selectedCDP)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    new ExecuteTransformationChain(ExecuteTransformationChainHandler.this.selectedCDP, ExecuteTransformationChainHandler.this.project).executeTransformation(monitor, 0);
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        return null;
    }
}

