/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.java.library.JavaLibUriConstants;
import org.eclipse.papyrus.designer.languages.java.profile.JavaProfileResource;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.External;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.ChangeEventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.ConcurrencyGenerator;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.EventTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.LifeCycleUtil;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.MonitoringTransformation;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.PseudostateGenerator;
import org.eclipse.papyrus.designer.transformation.languages.java.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.statemachine.SMCommon;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.library.xtend.BehaviorUtil;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.transformation.vsl.ParseVSL;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionExtensions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SM2ClassesTransformationCore {
    @Extension
    protected CDefinitions cdefs;
    public int MAX_NUMBER_ORTHOGONAL_REGIONS = 1;
    private StateMachine sm;
    public Type boolType;
    public Type threadFuncEnum;
    private Type state_t;
    public Class superContext;
    private List<Transition> transitions = new ArrayList<Transition>();
    private List<OpaqueBehavior> actions = new ArrayList<OpaqueBehavior>();
    public Region topRegion;
    public List<State> states = new ArrayList<State>();
    private List<Vertex> vertexes = new ArrayList<Vertex>();
    public LazyCopier copier;
    private String langID = "JAVA";
    public Semaphore sema = new Semaphore(1);
    public boolean generateActionLog = false;
    private boolean createDoActivity = true;
    public Type voidType;
    private Enumeration stateIdEnum;
    public Type intType;
    public Type charType;
    public Type stringType;
    private Enumeration eventIdEnum;
    public Type sockAddrInType;
    public static Package umlPrimitiveLibrary;
    public static Package javaLibrary;
    public List<TimeEvent> timeEvents = new ArrayList<TimeEvent>();
    public List<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
    public List<CallEvent> callEvents = new ArrayList<CallEvent>();
    private List<SignalEvent> signalEvents = new ArrayList<SignalEvent>();
    private List<AnyReceiveEvent> anyEvents = new ArrayList<AnyReceiveEvent>();
    private List<Pseudostate> junctions = new ArrayList<Pseudostate>();
    public ConcurrencyGenerator concurrency;
    public EventTransformation eventTransform;
    public PseudostateGenerator pseudostateGenerator;
    public MonitoringTransformation monitoringTransformation;
    public List<Behavior> doActivityList = new ArrayList<Behavior>();
    public Package smPack;
    private List<Region> regions = new ArrayList<Region>();
    public List<Transition> parallelTransitions = new ArrayList<Transition>();
    public Map<State, List<TimeEvent>> states2TimeEvents = new HashMap<State, List<TimeEvent>>();
    private Type threadStructType;
    private Type event_t;
    public List<Region> orthogonalRegions = new ArrayList<Region>();

    public SM2ClassesTransformationCore(LazyCopier copier, StateMachine sm, Class tmClass) {
        CDefinitions _cDefinitions;
        this.copier = copier;
        this.superContext = tmClass;
        this.sm = sm;
        ResourceSet resourceSet = this.getTargetPacket().eResource().getResourceSet();
        this.cdefs = _cDefinitions = new CDefinitions(this.superContext);
        umlPrimitiveLibrary = ElementUtils.loadPackage((URI)StdUriConstants.UML_PRIM_TYPES_URI, (ResourceSet)resourceSet);
        javaLibrary = ElementUtils.loadPackage((URI)JavaLibUriConstants.LIBRARY_PATH_URI, (ResourceSet)resourceSet);
        this.boolType = umlPrimitiveLibrary.getOwnedType("Boolean");
        this.voidType = umlPrimitiveLibrary.getOwnedType("Object");
        this.intType = umlPrimitiveLibrary.getOwnedType("Integer");
        this.stringType = umlPrimitiveLibrary.getOwnedType("String");
        this.charType = javaLibrary.getOwnedType("char");
    }

    public Package setSmPack(Package smPack) {
        this.smPack = smPack;
        return this.smPack;
    }

    public Type getThreadStructType() {
        return this.threadStructType;
    }

    public Type setThreadStructType(Type threadStructType) {
        this.threadStructType = threadStructType;
        return this.threadStructType;
    }

    public Type setState_t(Type state_t) {
        this.state_t = state_t;
        return this.state_t;
    }

    public Type setEvent_t(Type event_t) {
        this.event_t = event_t;
        return this.event_t;
    }

    public Package getRoot() {
        return TransformationContext.current.copier.source;
    }

    public Package getTargetPacket() {
        return this.copier.target;
    }

    public Package getExternalPackage(Package parentPack) {
        boolean _tripleEquals;
        Package _nestedPackage = parentPack.getNestedPackage("external");
        boolean bl = _tripleEquals = _nestedPackage == null;
        if (_tripleEquals) {
            Package createdPack = parentPack.createNestedPackage("external");
            StereotypeUtil.apply((Element)createdPack, NoCodeGen.class);
        }
        return parentPack.getNestedPackage("external");
    }

    public void createIntConstant(String name, int defaultValue) {
        Property constant = this.superContext.createOwnedAttribute(name, this.intType);
        constant.setIsStatic(true);
        constant.setIsLeaf(true);
        ValueSpecification _createDefaultValue = constant.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralInteger());
        LiteralInteger defaultValueUML = (LiteralInteger)_createDefaultValue;
        defaultValueUML.setValue(defaultValue);
    }

    public void transform() {
        boolean _greaterThan_1;
        boolean _isEmpty_2;
        boolean _not_1;
        boolean _not;
        boolean _greaterThan;
        MonitoringTransformation _monitoringTransformation;
        PseudostateGenerator _pseudostateGenerator;
        EventTransformation _eventTransformation;
        ConcurrencyGenerator _concurrencyGenerator;
        Package javaProfile;
        Package targetPack = this.getTargetPacket();
        ResourceSet resourceSet = targetPack.eResource().getResourceSet();
        Package profile = ElementUtils.loadPackage((URI)StdUriConstants.UML_STD_PROFILE_URI, (ResourceSet)resourceSet);
        if (profile instanceof Profile) {
            PackageUtil.applyProfile((Package)targetPack, (Profile)((Profile)profile), (boolean)true);
        }
        if ((javaProfile = PackageUtil.loadPackage((URI)JavaProfileResource.PROFILE_PATH_URI, (ResourceSet)resourceSet)) instanceof Profile) {
            PackageUtil.applyProfile((Package)targetPack, (Profile)((Profile)javaProfile), (boolean)true);
        }
        this.topRegion = (Region)IterableExtensions.head((Iterable)this.sm.getRegions());
        this.concurrency = _concurrencyGenerator = new ConcurrencyGenerator(this);
        this.eventTransform = _eventTransformation = new EventTransformation(this);
        this.pseudostateGenerator = _pseudostateGenerator = new PseudostateGenerator(this);
        this.monitoringTransformation = _monitoringTransformation = new MonitoringTransformation(this);
        Map<Event, List<Transition>> eventMap = this.getAllEvents(this.topRegion);
        BiConsumer<Event, List<Transition>> _function = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e, List<Transition> k) {
                if (e instanceof TimeEvent) {
                    SM2ClassesTransformationCore.this.timeEvents.add((TimeEvent)e);
                } else if (e instanceof CallEvent) {
                    SM2ClassesTransformationCore.this.callEvents.add((CallEvent)e);
                } else if (e instanceof SignalEvent) {
                    SM2ClassesTransformationCore.this.signalEvents.add((SignalEvent)e);
                } else if (e instanceof ChangeEvent) {
                    SM2ClassesTransformationCore.this.changeEvents.add((ChangeEvent)e);
                } else if (e instanceof AnyReceiveEvent) {
                    SM2ClassesTransformationCore.this.anyEvents.add((AnyReceiveEvent)e);
                }
            }
        };
        eventMap.forEach(_function);
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier("EventId_t", UMLPackage.Literals.ENUMERATION);
        this.eventIdEnum = (Enumeration)_createNestedClassifier;
        this.createIntConstant(this.cdefs.TIME_EVENT_LOWER_BOUND(), 0);
        Consumer<TimeEvent> _function_1 = new Consumer<TimeEvent>(){

            @Override
            public void accept(TimeEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID((Event)it));
            }
        };
        this.timeEvents.forEach(_function_1);
        Consumer<ChangeEvent> _function_2 = new Consumer<ChangeEvent>(){

            @Override
            public void accept(ChangeEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID((Event)it));
            }
        };
        this.changeEvents.forEach(_function_2);
        this.createIntConstant(this.cdefs.CHANGE_EVENT_LOWER_BOUND(), this.timeEvents.size());
        Operation teIndex = this.superContext.createOwnedOperation(this.cdefs.TE_INDEX(), null, null);
        teIndex.setIsStatic(true);
        teIndex.setIsLeaf(true);
        teIndex.createOwnedParameter("id", this.intType);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return id - ");
        String _TIME_EVENT_LOWER_BOUND = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder.append(_TIME_EVENT_LOWER_BOUND);
        _builder.append(";");
        this.createOpaqueBehavior(this.superContext, teIndex, _builder.toString());
        Parameter retType = teIndex.createOwnedParameter("ret", this.intType);
        retType.setDirection(ParameterDirectionKind.RETURN_LITERAL);
        this.superContext.createOwnedAttribute("currentEvent", this.event_t);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("import statemachineJava.EventPriority_t;");
        _builder_1.newLine();
        _builder_1.append("import statemachineJava.EventType_t;");
        _builder_1.newLine();
        this.appendImport(_builder_1.toString());
        Consumer<SignalEvent> _function_3 = new Consumer<SignalEvent>(){

            @Override
            public void accept(SignalEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID((Event)it));
            }
        };
        this.signalEvents.forEach(_function_3);
        Consumer<CallEvent> _function_4 = new Consumer<CallEvent>(){

            @Override
            public void accept(CallEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID((Event)it));
            }
        };
        this.callEvents.forEach(_function_4);
        Consumer<AnyReceiveEvent> _function_5 = new Consumer<AnyReceiveEvent>(){

            @Override
            public void accept(AnyReceiveEvent it) {
                SM2ClassesTransformationCore.this.eventIdEnum.createOwnedLiteral(TransformationUtil.eventID((Event)it));
            }
        };
        this.anyEvents.forEach(_function_5);
        String _upperCase = "CompletionEvent".toUpperCase();
        String _plus = String.valueOf(_upperCase) + "_ID";
        this.eventIdEnum.createOwnedLiteral(_plus);
        this.getAllActionsTransitionsStates(this.topRegion);
        Functions.Function1<State, Boolean> _function_6 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return it.isOrthogonal();
            }
        };
        Consumer<State> _function_7 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _greaterThan;
                int _size = it.getRegions().size();
                boolean bl = _greaterThan = _size > SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS;
                if (_greaterThan) {
                    SM2ClassesTransformationCore.this.MAX_NUMBER_ORTHOGONAL_REGIONS = it.getRegions().size();
                }
            }
        };
        IterableExtensions.filter(this.states, (Functions.Function1)_function_6).forEach(_function_7);
        Consumer<State> _function_8 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                final ArrayList triggers = new ArrayList();
                Consumer<Transition> _function = new Consumer<Transition>(){

                    @Override
                    public void accept(Transition it) {
                        triggers.addAll(it.getTriggers());
                    }
                };
                it.getOutgoings().forEach((Consumer)_function);
                Functions.Function1<Trigger, Event> _function_1 = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List events = ListExtensions.map(triggers, (Functions.Function1)_function_1);
                List timeEvents = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)events, TimeEvent.class));
                SM2ClassesTransformationCore.this.states2TimeEvents.put(it, timeEvents);
            }
        };
        this.states.forEach(_function_8);
        Consumer<Pseudostate> _function_9 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
                if (_equals) {
                    SM2ClassesTransformationCore.this.junctions.add(it);
                }
            }
        };
        Iterables.filter(this.vertexes, Pseudostate.class).forEach(_function_9);
        Consumer<Pseudostate> _function_10 = new Consumer<Pseudostate>(){

            @Override
            public void accept(Pseudostate it) {
                SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(it.getName(), SM2ClassesTransformationCore.this.intType);
            }
        };
        this.junctions.forEach(_function_10);
        Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("StateIDEnum", UMLPackage.Literals.ENUMERATION);
        this.stateIdEnum = (Enumeration)_createNestedClassifier_1;
        this.monitoringTransformation.createMonitorAttributes();
        this.createStateStruct();
        this.superContext.createOwnedAttribute("activeStateID", (Type)this.stateIdEnum);
        this.superContext.createOwnedAttribute("dispatchStruct", this.threadStructType);
        Property smAttr = ((Class)this.threadStructType).getOwnedAttribute("sm", null);
        Type smType = smAttr.getType();
        smType.setName(this.superContext.getName());
        External extSM = (External)UMLUtil.getStereotypeApplication((Element)smType, External.class);
        extSM.setName(this.superContext.getQualifiedName().replace("::", "."));
        Operation teGetter = this.superContext.createOwnedOperation("getTEIndex", null, null);
        teGetter.createOwnedParameter("id", this.intType);
        teGetter.createOwnedParameter("ret", this.intType).setDirection(ParameterDirectionKind.RETURN_LITERAL);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("return ");
        String _upperCase_1 = this.superContext.getName().toUpperCase();
        _builder_2.append(_upperCase_1);
        _builder_2.append("_TE_INDEX(id);");
        BehaviorUtil.set((Operation)teGetter, (String)this.langID, (String)_builder_2.toString());
        Operation smMax = this.superContext.createOwnedOperation("getStateMax", null, null);
        smMax.createOwnedParameter("ret", this.intType).setDirection(ParameterDirectionKind.RETURN_LITERAL);
        BehaviorUtil.set((Operation)smMax, (String)this.langID, (String)"return StateIDEnum.STATE_MAX.ordinal();");
        Property state = this.superContext.createOwnedAttribute("states", this.state_t);
        state.setUpper(this.states.size());
        this.createOpaqueExpressionDefaultValue(state, "state", "new State_t[StateIDEnum.STATE_MAX.ordinal()];");
        Property threadStructs = this.superContext.createOwnedAttribute("threadStructs", this.threadStructType);
        threadStructs.setUpper(this.states.size());
        this.createOpaqueExpressionDefaultValue(threadStructs, "threadStructs", "new StructForThread_t[StateIDEnum.STATE_MAX.ordinal()];");
        Property flags = this.superContext.createOwnedAttribute("flags", this.boolType);
        flags.setUpper(this.states.size());
        this.createOpaqueExpressionDefaultValue(flags, "flags", "new boolean[StateIDEnum.STATE_MAX.ordinal()];");
        Property timeEventFlags = this.superContext.createOwnedAttribute("timeEventFlags", this.boolType);
        timeEventFlags.setUpper(this.states.size());
        this.createOpaqueExpressionDefaultValue(timeEventFlags, "timeEventFlags", "new boolean[StateIDEnum.STATE_MAX.ordinal()];");
        Property timeEventThreadStructs = this.superContext.createOwnedAttribute("timeEventThreadStructs", this.threadStructType);
        timeEventThreadStructs.setUpper(this.states.size());
        this.createOpaqueExpressionDefaultValue(timeEventThreadStructs, "timeEventThreadStructs", "new StructForThread_t[2];");
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)this.superContext, (String)"java::util::concurrent::Semaphore");
        Type semaphore = (Type)_qualifiedElementFromRS;
        Property sem = this.superContext.createOwnedAttribute("sem", semaphore);
        this.createOpaqueExpressionDefaultValue(sem, "sem", "new Semaphore(1);");
        NamedElement _qualifiedElementFromRS_1 = ElementUtils.getQualifiedElementFromRS((Element)this.superContext, (String)"statemachineJava::extern::PriorityBlockingQueue<Event_t>");
        Type queue = (Type)_qualifiedElementFromRS_1;
        Property eventQueue = this.superContext.createOwnedAttribute("eventQueue", queue);
        this.createOpaqueExpressionDefaultValue(eventQueue, "eventQueue", "new PriorityBlockingQueue<Event_t>();");
        this.createRegionMethods();
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("startBehavior();");
        final String startCode = _builder_3.toString();
        boolean _supportsLifeCycle = LifeCycleUtil.supportsLifeCycle(this.superContext);
        if (_supportsLifeCycle) {
            LifeCycleUtil.addUnimplemented(this.superContext);
            Operation activateOp = this.superContext.getOperation("activate", null, null);
            BehaviorUtil.appendBody((Operation)activateOp, (String)startCode);
        } else {
            Functions.Function1<Operation, Boolean> _function_11 = new Functions.Function1<Operation, Boolean>(){

                public Boolean apply(Operation it) {
                    return StereotypeUtil.isApplied((Element)it, Create.class) && Objects.equal((Object)it.getName(), (Object)SM2ClassesTransformationCore.this.superContext.getName());
                }
            };
            Iterable constructors = IterableExtensions.filter((Iterable)this.superContext.getOwnedOperations(), (Functions.Function1)_function_11);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)constructors);
            if (_isEmpty) {
                Operation ctor = this.superContext.createOwnedOperation(this.superContext.getName(), null, null);
                StereotypeUtil.apply((Element)ctor, Create.class);
                StringConcatenation _builder_4 = new StringConcatenation();
                for (State s : this.states) {
                    boolean _isBehaviorExist_2;
                    boolean _isBehaviorExist_1;
                    boolean _isBehaviorExist = TransformationUtil.isBehaviorExist((Behavior)s.getEntry());
                    if (_isBehaviorExist) {
                        String _name = s.getName();
                        String _plus_1 = String.valueOf(_name) + "_";
                        String _plus_2 = String.valueOf(_plus_1) + "entry";
                        _builder_4.append(_plus_2);
                        _builder_4.append("= new ");
                        String _name_1 = s.getName();
                        String _plus_3 = String.valueOf(_name_1) + "_";
                        String _plus_4 = String.valueOf(_plus_3) + "entry";
                        _builder_4.append(_plus_4);
                        _builder_4.append("();");
                        _builder_4.newLineIfNotEmpty();
                    }
                    if (_isBehaviorExist_1 = TransformationUtil.isBehaviorExist((Behavior)s.getExit())) {
                        String _name_2 = s.getName();
                        String _plus_5 = String.valueOf(_name_2) + "_";
                        String _plus_6 = String.valueOf(_plus_5) + "exit";
                        _builder_4.append(_plus_6);
                        _builder_4.append("= new ");
                        String _name_3 = s.getName();
                        String _plus_7 = String.valueOf(_name_3) + "_";
                        String _plus_8 = String.valueOf(_plus_7) + "exit";
                        _builder_4.append(_plus_8);
                        _builder_4.append("();");
                        _builder_4.newLineIfNotEmpty();
                    }
                    if (_isBehaviorExist_2 = TransformationUtil.isBehaviorExist((Behavior)s.getDoActivity())) {
                        String _name_4 = s.getName();
                        String _plus_9 = String.valueOf(_name_4) + "_";
                        String _plus_10 = String.valueOf(_plus_9) + "doActivity";
                        _builder_4.append(_plus_10);
                        _builder_4.append("= new ");
                        String _name_5 = s.getName();
                        String _plus_11 = String.valueOf(_name_5) + "_";
                        String _plus_12 = String.valueOf(_plus_11) + "doActivity";
                        _builder_4.append(_plus_12);
                        _builder_4.append("();");
                        _builder_4.newLineIfNotEmpty();
                    }
                    _builder_4.newLine();
                }
                _builder_4.append("entry_dft = new Entry_dft();");
                _builder_4.newLine();
                _builder_4.append("doActivity_dft = new DoActivity_dft();");
                _builder_4.newLine();
                _builder_4.append("exit_dft = new Exit_dft();");
                _builder_4.newLine();
                _builder_4.append("startBehavior();");
                _builder_4.newLine();
                this.createOpaqueBehavior(this.superContext, ctor, _builder_4.toString());
            } else {
                Consumer<Operation> _function_12 = new Consumer<Operation>(){

                    @Override
                    public void accept(Operation it) {
                        BehaviorUtil.appendBody((Operation)it, (String)startCode);
                    }
                };
                constructors.forEach(_function_12);
            }
        }
        this.monitoringTransformation.createConstructor();
        this.monitoringTransformation.createDestructor();
        Operation startBehavior = this.superContext.createOwnedOperation("startBehavior", null, null);
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("systemState");
        _builder_5.append(" = statemachineJava.SystemStateEnum_t.IDLE;");
        _builder_5.newLineIfNotEmpty();
        _builder_5.newLine();
        _builder_5.append("// initialize all threads, the threads wait until the associated flag is set");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("for (int i = 0; i < (int) StateIDEnum.STATE_MAX.ordinal(); i++) {");
        _builder_5.newLine();
        _builder_5.append("\t\t\t");
        _builder_5.append("states[i] = new State_t(this);");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("}");
        _builder_5.newLine();
        for (State s_1 : this.states) {
            boolean _isBehaviorExist_5;
            boolean _isBehaviorExist_4;
            boolean _isBehaviorExist_3 = TransformationUtil.isBehaviorExist((Behavior)s_1.getEntry());
            if (_isBehaviorExist_3) {
                _builder_5.append("states");
                _builder_5.append("[StateIDEnum.");
                String _upperCase_2 = s_1.getName().toUpperCase();
                _builder_5.append(_upperCase_2);
                _builder_5.append("_ID.ordinal()].");
                _builder_5.append("entry");
                _builder_5.append(" = ");
                String _name_6 = s_1.getName();
                String _plus_13 = String.valueOf(_name_6) + "_";
                String _plus_14 = String.valueOf(_plus_13) + "entry";
                _builder_5.append(_plus_14);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
            }
            if (_isBehaviorExist_4 = TransformationUtil.isBehaviorExist((Behavior)s_1.getExit())) {
                _builder_5.append("states");
                _builder_5.append("[StateIDEnum.");
                String _upperCase_3 = s_1.getName().toUpperCase();
                _builder_5.append(_upperCase_3);
                _builder_5.append("_ID.ordinal()].");
                _builder_5.append("exit");
                _builder_5.append(" = ");
                String _name_7 = s_1.getName();
                String _plus_15 = String.valueOf(_name_7) + "_";
                String _plus_16 = String.valueOf(_plus_15) + "exit";
                _builder_5.append(_plus_16);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
            }
            if (!(_isBehaviorExist_5 = TransformationUtil.isBehaviorExist((Behavior)s_1.getDoActivity()))) continue;
            _builder_5.append("states");
            _builder_5.append("[StateIDEnum.");
            String _upperCase_4 = s_1.getName().toUpperCase();
            _builder_5.append(_upperCase_4);
            _builder_5.append("_ID.ordinal()].");
            _builder_5.append("doActivity");
            _builder_5.append(" = ");
            String _name_8 = s_1.getName();
            String _plus_17 = String.valueOf(_name_8) + "_";
            String _plus_18 = String.valueOf(_plus_17) + "doActivity";
            _builder_5.append(_plus_18);
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
        }
        _builder_5.newLine();
        _builder_5.append("for(int i = 0; i < (int) StateIDEnum.");
        _builder_5.append("STATE_MAX");
        _builder_5.append(".ordinal(); i++) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("if (");
        _builder_5.append("states", "\t");
        _builder_5.append("[i].");
        _builder_5.append("doActivity", "\t");
        _builder_5.append(" != doActivity_dft) {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t\t");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("StructForThread_t threadstructs = new StructForThread_t(this, ThreadFunctions.TF_DO_ACTIVITY,  i,sem);");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("threadStructs[i] = threadstructs;");
        _builder_5.newLine();
        _builder_5.append("\t\t");
        _builder_5.append("threadStructs[i].start();");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("}");
        _builder_5.newLine();
        _builder_5.append("\t");
        _builder_5.newLine();
        int _size = this.timeEvents.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder_5.newLine();
            _builder_5.append("for(int i = ");
            String _TIME_EVENT_LOWER_BOUND_1 = this.cdefs.TIME_EVENT_LOWER_BOUND();
            _builder_5.append(_TIME_EVENT_LOWER_BOUND_1);
            _builder_5.append("; i < ");
            int _size_1 = this.timeEvents.size();
            _builder_5.append((Object)_size_1);
            _builder_5.append("; i++) {");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("timeEventThreadStructs[i] = new StructForThread_t(this,  ThreadFunctions.TF_TIME_EVENT,i,sem );");
            _builder_5.newLine();
            _builder_5.append("}");
            _builder_5.newLine();
            for (TimeEvent e : this.timeEvents) {
                ValueSpecification _expr = e.getWhen().getExpr();
                long duration = ParseVSL.getMsDurationFromVSL((String)((String)((OpaqueExpression)_expr).getBodies().get(0)));
                _builder_5.newLineIfNotEmpty();
                _builder_5.append("timeEventThreadStructs");
                _builder_5.append("[");
                String _TE_INDEX = this.cdefs.TE_INDEX();
                _builder_5.append(_TE_INDEX);
                _builder_5.append("(EventId_t.");
                String _eventID = TransformationUtil.eventID((Event)e);
                _builder_5.append(_eventID);
                _builder_5.append(".ordinal())].duration = ");
                _builder_5.append((Object)duration);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
            }
            _builder_5.append("for(int i = ");
            String _TIME_EVENT_LOWER_BOUND_2 = this.cdefs.TIME_EVENT_LOWER_BOUND();
            _builder_5.append(_TIME_EVENT_LOWER_BOUND_2);
            _builder_5.append("; i < ");
            int _size_2 = this.timeEvents.size();
            _builder_5.append((Object)_size_2);
            _builder_5.append("; i++) {");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("timeEventThreadStructs[i].start();");
            _builder_5.newLine();
            _builder_5.append("\t");
            _builder_5.append("while (timeEventFlags[");
            String _TE_INDEX_1 = this.cdefs.TE_INDEX();
            _builder_5.append(_TE_INDEX_1, "\t");
            _builder_5.append("(i)]) {");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("}");
            _builder_5.newLine();
            _builder_5.append("}");
            _builder_5.newLine();
            _builder_5.append("dispatchStruct = new StructForThread_t(this, 0, ThreadFunctions.TF_STATE_MACHINE_TYPE);");
            _builder_5.newLine();
            _builder_5.append("dispatchStruct.start();");
            _builder_5.newLine();
        }
        _builder_5.newLine();
        boolean _isEmpty_1 = this.orthogonalRegions.isEmpty();
        boolean bl2 = _not = !_isEmpty_1;
        if (_not) {
            for (Region r : this.orthogonalRegions) {
                _builder_5.append("regionTable");
                _builder_5.append("[");
                String _regionMacroId = this.getRegionMacroId(r);
                _builder_5.append(_regionMacroId);
                _builder_5.append("] = &");
                String _name_9 = this.superContext.getName();
                _builder_5.append(_name_9);
                _builder_5.append("::");
                String _regionMethodName = this.getRegionMethodName(r);
                _builder_5.append(_regionMethodName);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
                _builder_5.append("regionExitTable");
                _builder_5.append("[");
                String _regionMacroId_1 = this.getRegionMacroId(r);
                _builder_5.append(_regionMacroId_1);
                _builder_5.append("] = &");
                String _name_10 = this.superContext.getName();
                _builder_5.append(_name_10);
                _builder_5.append("::");
                String _regionMethodExitName = this.getRegionMethodExitName(r);
                _builder_5.append(_regionMethodExitName);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _not_1 = !(_isEmpty_2 = this.parallelTransitions.isEmpty());
        if (_not_1) {
            for (Transition t : this.parallelTransitions) {
                _builder_5.append("transitionTable");
                _builder_5.append("[");
                String _parallelTransitionId = this.concurrency.parallelTransitionId(t);
                _builder_5.append(_parallelTransitionId);
                _builder_5.append("] = &");
                String _name_11 = this.superContext.getName();
                _builder_5.append(_name_11);
                _builder_5.append("::");
                String _parallelTransitionMethodName = this.concurrency.parallelTransitionMethodName(t);
                _builder_5.append(_parallelTransitionMethodName);
                _builder_5.append(";");
                _builder_5.newLineIfNotEmpty();
            }
        }
        _builder_5.newLine();
        int _size_3 = this.changeEvents.size();
        boolean bl4 = _greaterThan_1 = _size_3 > 0;
        if (_greaterThan_1) {
            _builder_5.append("// threads for changeEvent");
            _builder_5.newLine();
            _builder_5.append("for(int i = ");
            String _CHANGE_EVENT_LOWER_BOUND = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_5.append(_CHANGE_EVENT_LOWER_BOUND);
            _builder_5.append("; i < ");
            String _CHANGE_EVENT_LOWER_BOUND_1 = this.cdefs.CHANGE_EVENT_LOWER_BOUND();
            _builder_5.append(_CHANGE_EVENT_LOWER_BOUND_1);
            _builder_5.append(" + ");
            int _size_4 = this.changeEvents.size();
            _builder_5.append((Object)_size_4);
            _builder_5.append("; i++) {");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("changeEventThreadStructs", "\t");
            _builder_5.append("[");
            String _CHE_INDEX = this.cdefs.CHE_INDEX();
            _builder_5.append(_CHE_INDEX, "\t");
            _builder_5.append("(i)].id = i;");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("changeEventThreadStructs", "\t");
            _builder_5.append("[");
            String _CHE_INDEX_1 = this.cdefs.CHE_INDEX();
            _builder_5.append(_CHE_INDEX_1, "\t");
            _builder_5.append("(i)].ptr = this;");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("changeEventThreadStructs", "\t");
            _builder_5.append("[");
            String _CHE_INDEX_2 = this.cdefs.CHE_INDEX();
            _builder_5.append(_CHE_INDEX_2, "\t");
            _builder_5.append("(i)].func_type = ");
            _builder_5.append("ThreadFunctions.TF_CHANGE_EVENT", "\t");
            _builder_5.append(";");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("\t");
            _builder_5.append("pthread_create", "\t");
            _builder_5.append("(&");
            _builder_5.append("changeEventThreads", "\t");
            _builder_5.append("[");
            String _CHE_INDEX_3 = this.cdefs.CHE_INDEX();
            _builder_5.append(_CHE_INDEX_3, "\t");
            _builder_5.append("(i)], NULL, &");
            String _name_12 = this.superContext.getName();
            _builder_5.append(_name_12, "\t");
            _builder_5.append("::");
            _builder_5.append("thread_func_wrapper", "\t");
            _builder_5.append(", &");
            _builder_5.append("changeEventThreadStructs", "\t");
            _builder_5.append("[");
            String _CHE_INDEX_4 = this.cdefs.CHE_INDEX();
            _builder_5.append(_CHE_INDEX_4, "\t");
            _builder_5.append("(i)]);");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("}");
            _builder_5.newLine();
        }
        _builder_5.newLine();
        _builder_5.append("// initialize root active state");
        _builder_5.newLine();
        _builder_5.append("// execute initial effect");
        _builder_5.newLine();
        String _regionMethodName_1 = this.getRegionMethodName(this.topRegion);
        _builder_5.append(_regionMethodName_1);
        _builder_5.append("(");
        String _initialMacroName = this.getInitialMacroName(this.topRegion);
        _builder_5.append(_initialMacroName);
        _builder_5.append(");");
        _builder_5.newLineIfNotEmpty();
        this.createOpaqueBehavior(this.superContext, startBehavior, _builder_5.toString());
        Operation stopBehavior = this.superContext.createOwnedOperation("stop", null, null);
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("systemState");
        _builder_6.append(" = statemachineJava.SystemStateEnum_t.IDLE;");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("dispatchStruct.interrupt();");
        _builder_6.newLine();
        _builder_6.append("for (int i = ");
        String _TIME_EVENT_LOWER_BOUND_3 = this.cdefs.TIME_EVENT_LOWER_BOUND();
        _builder_6.append(_TIME_EVENT_LOWER_BOUND_3);
        _builder_6.append("; i < ");
        int _size_5 = this.timeEvents.size();
        _builder_6.append((Object)_size_5);
        _builder_6.append("; i++) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("timeEventThreadStructs[i].interrupt();");
        _builder_6.newLine();
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("for (int i = 0; i < (int) StateIDEnum.");
        _builder_6.append("STATE_MAX");
        _builder_6.append(".ordinal(); i++) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("if (");
        _builder_6.append("states", "\t");
        _builder_6.append("[i].");
        _builder_6.append("doActivity", "\t");
        _builder_6.append(" != doActivity_dft) {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t\t");
        _builder_6.append("threadStructs[i].interrupt();");
        _builder_6.newLine();
        _builder_6.append("\t");
        _builder_6.append("}");
        _builder_6.newLine();
        _builder_6.append("}");
        _builder_6.newLine();
        this.createOpaqueBehavior(this.superContext, stopBehavior, _builder_6.toString());
        this.superContext.createOwnedAttribute("dispatchFlag", this.boolType);
        BiConsumer<Event, List<Transition>> _function_13 = new BiConsumer<Event, List<Transition>>(){

            @Override
            public void accept(Event e, List<Transition> trans) {
                SM2ClassesTransformationCore.this.eventTransform.createEventMethod(e, trans);
            }
        };
        eventMap.forEach(_function_13);
        final ArrayList<Transition> autoTrans = new ArrayList<Transition>();
        Consumer<Transition> _function_14 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                if (it.getSource() instanceof State && ListExtensions.map((List)it.getTriggers(), (Functions.Function1)new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                }).size() == 0) {
                    autoTrans.add(it);
                }
            }
        };
        this.transitions.forEach(_function_14);
        this.eventTransform.createEventMethod("CompletionEvent", autoTrans);
        Consumer<State> _function_15 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _isBehaviorExist_2;
                boolean _isBehaviorExist_1;
                String _upperCase = it.getName().toUpperCase();
                String _plus = String.valueOf(_upperCase) + "_ID";
                SM2ClassesTransformationCore.this.stateIdEnum.createOwnedLiteral(_plus);
                NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)SM2ClassesTransformationCore.this.superContext, (String)"java::lang::Runnable");
                Interface runnable = (Interface)_qualifiedElementFromRS;
                boolean _isBehaviorExist = TransformationUtil.isBehaviorExist((Behavior)it.getEntry());
                if (_isBehaviorExist) {
                    String _name = it.getName();
                    String _plus_1 = String.valueOf(_name) + "_";
                    String _plus_2 = String.valueOf(_plus_1) + "entry";
                    Classifier _createNestedClassifier = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_2, UMLPackage.eINSTANCE.getClass_());
                    Class entry = (Class)_createNestedClassifier;
                    entry.createInterfaceRealization(null, runnable);
                    Operation entry_run = entry.createOwnedOperation("run", null, null);
                    Behavior _entry = it.getEntry();
                    OpaqueBehavior opaque = SM2ClassesTransformationCore.this.createOpaqueBehavior(entry, entry_run, (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_entry).getBodies()));
                    opaque.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                    String _name_1 = it.getName();
                    String _plus_3 = String.valueOf(_name_1) + "_";
                    String _plus_4 = String.valueOf(_plus_3) + "entry";
                    SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_4, (Type)entry);
                }
                if (_isBehaviorExist_1 = TransformationUtil.isBehaviorExist((Behavior)it.getExit())) {
                    String _name_2 = it.getName();
                    String _plus_5 = String.valueOf(_name_2) + "_";
                    String _plus_6 = String.valueOf(_plus_5) + "exit";
                    Classifier _createNestedClassifier_1 = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_6, UMLPackage.eINSTANCE.getClass_());
                    Class exit = (Class)_createNestedClassifier_1;
                    exit.createInterfaceRealization(null, runnable);
                    Operation exit_run = exit.createOwnedOperation("run", null, null);
                    Behavior _exit = it.getExit();
                    OpaqueBehavior opaque_1 = SM2ClassesTransformationCore.this.createOpaqueBehavior(exit, exit_run, (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_exit).getBodies()));
                    opaque_1.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                    String _name_3 = it.getName();
                    String _plus_7 = String.valueOf(_name_3) + "_";
                    String _plus_8 = String.valueOf(_plus_7) + "exit";
                    SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_8, (Type)exit);
                }
                if (_isBehaviorExist_2 = TransformationUtil.isBehaviorExist((Behavior)it.getDoActivity())) {
                    SM2ClassesTransformationCore.this.doActivityList.add(it.getDoActivity());
                    String _name_4 = it.getName();
                    String _plus_9 = String.valueOf(_name_4) + "_";
                    String _plus_10 = String.valueOf(_plus_9) + "doActivity";
                    Classifier _createNestedClassifier_2 = SM2ClassesTransformationCore.this.superContext.createNestedClassifier(_plus_10, UMLPackage.eINSTANCE.getClass_());
                    Class doActivity = (Class)_createNestedClassifier_2;
                    doActivity.createInterfaceRealization(null, runnable);
                    Operation doActivity_run = doActivity.createOwnedOperation("run", null, null);
                    Behavior _doActivity = it.getDoActivity();
                    OpaqueBehavior opaque_2 = SM2ClassesTransformationCore.this.createOpaqueBehavior(doActivity, doActivity_run, (String)IterableExtensions.head((Iterable)((OpaqueBehavior)_doActivity).getBodies()));
                    opaque_2.getLanguages().add((Object)SM2ClassesTransformationCore.this.langID);
                    String _name_5 = it.getName();
                    String _plus_11 = String.valueOf(_name_5) + "_";
                    String _plus_12 = String.valueOf(_plus_11) + "doActivity";
                    SM2ClassesTransformationCore.this.superContext.createOwnedAttribute(_plus_12, (Type)doActivity);
                }
            }
        };
        this.states.forEach(_function_15);
        this.stateIdEnum.createOwnedLiteral("STATE_MAX");
        this.concurrency.createThreadBasedParallelism();
        this.smPack.getOwnedType("Event_t");
        Operation eventDispatch = this.superContext.createOwnedOperation("dispatchEvent", null, null);
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("boolean popDeferred = false;");
        _builder_7.newLine();
        _builder_7.append("while (!Thread.currentThread().isInterrupted()) {");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("// run-to-completion: need to have a mutex here");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("try {");
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("currentEvent = ");
        _builder_7.append("eventQueue", "\t\t");
        _builder_7.append(".take();");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("} catch (InterruptedException e) {");
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("// interruption, exit loop");
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("break;");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("}");
        _builder_7.newLine();
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("dispatchFlag = true;");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("if (currentEvent != null) {");
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("int eventID = currentEvent.getEventID();");
        _builder_7.newLine();
        _builder_7.newLine();
        Functions.Function1<Event, Boolean> _function_16 = new Functions.Function1<Event, Boolean>(){

            public Boolean apply(Event it) {
                return !(it instanceof CallEvent);
            }
        };
        Iterable _filter = IterableExtensions.filter(eventMap.keySet(), (Functions.Function1)_function_16);
        for (Event e_1 : _filter) {
            _builder_7.append("\t\t");
            _builder_7.append("if (eventID == EventId_t.");
            String _eventID_1 = TransformationUtil.eventID((Event)e_1);
            _builder_7.append(_eventID_1, "\t\t");
            _builder_7.append(".ordinal()) { ");
            _builder_7.newLineIfNotEmpty();
            if (e_1 instanceof SignalEvent && ((SignalEvent)e_1).getSignal() != null) {
                _builder_7.append("\t\t");
                _builder_7.append("\t");
                _builder_7.append("if (currentEvent != NULL) {");
                _builder_7.newLine();
                _builder_7.append("\t\t");
                _builder_7.append("\t");
                _builder_7.append("\t");
                _builder_7.append("memcpy(&sig_");
                String _eventID_2 = TransformationUtil.eventID((Event)e_1);
                _builder_7.append(_eventID_2, "\t\t\t\t");
                _builder_7.append(", currentEvent->data, sizeof();");
                _builder_7.newLineIfNotEmpty();
                _builder_7.append("\t\t");
                _builder_7.append("\t");
                _builder_7.append("\t");
                _builder_7.append("process");
                String _eventName = TransformationUtil.eventName((Event)e_1);
                _builder_7.append(_eventName, "\t\t\t\t");
                _builder_7.append("(sig_");
                String _eventID_3 = TransformationUtil.eventID((Event)e_1);
                _builder_7.append(_eventID_3, "\t\t\t\t");
                _builder_7.append(");");
                _builder_7.newLineIfNotEmpty();
                _builder_7.append("\t\t");
                _builder_7.append("\t");
                _builder_7.append("}");
                _builder_7.newLine();
            } else {
                _builder_7.append("\t\t");
                _builder_7.append("\t");
                _builder_7.append("process");
                String _eventName_1 = TransformationUtil.eventName((Event)e_1);
                _builder_7.append(_eventName_1, "\t\t\t");
                _builder_7.append("();");
                _builder_7.newLineIfNotEmpty();
            }
            _builder_7.newLine();
            _builder_7.append("\t\t");
            _builder_7.append("}");
            _builder_7.newLine();
        }
        _builder_7.append("\t\t");
        _builder_7.append("if (eventID == EventId_t.COMPLETIONEVENT_ID.ordinal()) {");
        _builder_7.newLine();
        _builder_7.append("\t\t\t");
        _builder_7.append("processCompletionEvent();");
        _builder_7.newLine();
        _builder_7.append("\t\t");
        _builder_7.append("}");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("}");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("if (");
        _builder_7.append("systemState", "\t");
        _builder_7.append(" == SystemStateEnum_t.EVENT_DEFERRED) {");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t\t");
        _builder_7.append("// ");
        _builder_7.append("eventQueue", "\t\t");
        _builder_7.append(".saveDeferred(*currentEvent);");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("}");
        _builder_7.newLine();
        _builder_7.append("\t");
        _builder_7.append("popDeferred = (");
        _builder_7.append("systemState", "\t");
        _builder_7.append(" != SystemStateEnum_t.EVENT_DEFERRED);");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("// ");
        _builder_7.append("systemState", "\t");
        _builder_7.append(" = SystemStateEnum_t.IDLE;");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("}");
        _builder_7.newLine();
        this.createOpaqueBehavior(this.superContext, eventDispatch, _builder_7.toString());
        this.concurrency.createConcurrencyForTransitions();
        this.createChangeEvents();
    }

    public void appendImport(String appended) {
        Import import_ = (Import)StereotypeUtil.applyApp((Element)this.superContext, Import.class);
        StringConcatenation _builder = new StringConcatenation();
        String _manualImports = import_.getManualImports();
        _builder.append(_manualImports);
        _builder.newLineIfNotEmpty();
        _builder.append(appended);
        import_.setManualImports(_builder.toString());
    }

    private void createChangeEvents() {
        new ChangeEventTransformation(this).createChangeEvents();
    }

    public String generateChangeState(State s) {
        Region _container = s.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("activeStateID");
            _builder.append(" = StateIDEnum.");
            String _upperCase = s.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID;");
            return _builder.toString();
        }
        int rIndex = s.getContainer().getState().getRegions().indexOf((Object)s.getContainer());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("states");
        _builder_1.append("[StateIDEnum.");
        String _upperCase_1 = s.getContainer().getState().getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal()].");
        _builder_1.append("actives");
        _builder_1.append("[");
        _builder_1.append((Object)rIndex);
        _builder_1.append("] = ");
        String _upperCase_2 = s.getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_ID;");
        return _builder_1.toString();
    }

    public String generateExitingSubStates(State parent, boolean exitParent) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            _builder_1.append("//exiting concurrent state ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.newLineIfNotEmpty();
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                String _generateForkCall = this.concurrency.generateForkCall(r, false, "0");
                _builder_1.append(_generateForkCall);
                _builder_1.newLineIfNotEmpty();
            }
            EList _regions_1 = parent.getRegions();
            for (Region r_1 : _regions_1) {
                String _generateJoinCall = this.concurrency.generateJoinCall(r_1, false);
                _builder_1.append(_generateJoinCall);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                String _regionMethodExitName = this.getRegionMethodExitName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                _builder_1.append(_regionMethodExitName);
                _builder_1.append("();");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            boolean _isBehaviorExist = TransformationUtil.isBehaviorExist((Behavior)parent.getDoActivity());
            if (_isBehaviorExist) {
                _builder_1.append("//signal to exit the doActivity of ");
                String _name_1 = parent.getName();
                _builder_1.append(_name_1);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("setFlag");
                _builder_1.append("(StateIDEnum.");
                String _upperCase_1 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_1);
                _builder_1.append("_ID.ordinal(), ");
                _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
                _builder_1.append(", false);");
                _builder_1.newLineIfNotEmpty();
            }
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "false");
            _builder_1.append((Object)_generateActivateTimeEvent);
            _builder_1.newLineIfNotEmpty();
            boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist((Behavior)parent.getExit());
            if (_isBehaviorExist_1) {
                _builder_1.append("//exit action of ");
                String _name_2 = parent.getName();
                _builder_1.append(_name_2);
                _builder_1.newLineIfNotEmpty();
                String _fptrCall = this.getFptrCall(pAttr, "exit");
                _builder_1.append(_fptrCall);
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    public CharSequence generateActivateTimeEvent(State s, String trueOrFalse) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        List<TimeEvent> _get = this.states2TimeEvents.get(s);
        boolean bl = _tripleNotEquals = _get != null;
        if (_tripleNotEquals) {
            List<TimeEvent> _get_1 = this.states2TimeEvents.get(s);
            for (TimeEvent te : _get_1) {
                _builder.append("setFlag");
                _builder.append("(");
                String _TE_INDEX = this.cdefs.TE_INDEX();
                _builder.append(_TE_INDEX);
                _builder.append("(EventId_t.");
                String _eventID = TransformationUtil.eventID((Event)te);
                _builder.append(_eventID);
                _builder.append(".ordinal()), ");
                _builder.append("ThreadFunctions.TF_TIME_EVENT");
                _builder.append(", ");
                _builder.append(trueOrFalse);
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @Deprecated
    public String generateExitingSubStatesWithTransition(State parent, boolean exitParent, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState) && it.isComposite();
                    }
                };
                Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function);
                boolean _hasElements = false;
                for (State s : _filter) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_1 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_1);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] == &");
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_2 = s.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID.ordinal()]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates = this.generateExitingSubStates(s, true);
                    _builder_1.append(_generateExitingSubStates, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_3 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_3);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function_1);
                boolean _hasElements_1 = false;
                for (State sub : _filter_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_4 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_4, "\t");
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives", "\t");
                    _builder_1.append("[");
                    int _indexOf_2 = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf_2, "\t");
                    _builder_1.append("] == &");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_5 = sub.getName().toUpperCase();
                    _builder_1.append(_upperCase_5, "\t");
                    _builder_1.append("_ID.ordinal()]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("setFlag", "\t\t");
                    _builder_1.append("(StateIdEnum.");
                    String _upperCase_6 = sub.getName().toUpperCase();
                    _builder_1.append(_upperCase_6, "\t\t");
                    _builder_1.append("_ID.ordinal(), ");
                    _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY", "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _upperCase_7 = parent.getName().toUpperCase();
                String _plus = "states[StateIDEnum." + _upperCase_7;
                String _plus_1 = String.valueOf(_plus) + "_ID.ordinal()].";
                String _plus_2 = String.valueOf(_plus_1) + "actives";
                String _plus_3 = String.valueOf(_plus_2) + "[";
                int _indexOf_3 = parent.getRegions().indexOf((Object)r);
                String _plus_4 = String.valueOf(_plus_3) + Integer.valueOf(_indexOf_3);
                String _plus_5 = String.valueOf(_plus_4) + "]";
                String _fptrCall = this.getFptrCall(_plus_5, "exit");
                _builder_1.append(_fptrCall, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("states");
                _builder_1.append("[StateIdEnum.");
                String _upperCase_8 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_8);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_4 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_4);
                _builder_1.append("] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState) && it.isComposite();
                    }
                };
                Iterable _filter_2 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_2);
                boolean _hasElements_2 = false;
                for (State s_1 : _filter_2) {
                    if (!_hasElements_2) {
                        _hasElements_2 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "");
                    }
                    _builder_1.append("if (");
                    _builder_1.append("states");
                    _builder_1.append("[StateIdEnum.");
                    String _upperCase_9 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_9);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] == ");
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_10 = s_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_10);
                    _builder_1.append("_ID.ordinal()]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    String _generateExitingSubStates_1 = this.generateExitingSubStates(s_1, true);
                    _builder_1.append(_generateExitingSubStates_1, "\t");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("if (");
                _builder_1.append("states");
                _builder_1.append("[StateIdEnum.");
                String _upperCase_11 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_11);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[0] != NULL) {");
                _builder_1.newLineIfNotEmpty();
                Functions.Function1<State, Boolean> _function_3 = new Functions.Function1<State, Boolean>(){

                    public Boolean apply(State it) {
                        return !(it instanceof FinalState);
                    }
                };
                Iterable _filter_3 = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_3);
                boolean _hasElements_3 = false;
                for (State sub_1 : _filter_3) {
                    if (!_hasElements_3) {
                        _hasElements_3 = true;
                    } else {
                        _builder_1.appendImmediate((Object)" else ", "\t");
                    }
                    _builder_1.append("\t");
                    _builder_1.append("if (");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_12 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_12, "\t");
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives", "\t");
                    _builder_1.append("[0] == ");
                    _builder_1.append("states", "\t");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_13 = sub_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_13, "\t");
                    _builder_1.append("_ID.ordinal()]) {");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("\t");
                    _builder_1.append("setFlag", "\t\t");
                    _builder_1.append("(StateIDEnum.");
                    String _upperCase_14 = sub_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_14, "\t\t");
                    _builder_1.append("_ID.ordinal(), ");
                    _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY", "\t\t");
                    _builder_1.append(", false);");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("\t");
                    _builder_1.append("}");
                    _builder_1.newLine();
                }
                _builder_1.append("\t");
                String _upperCase_15 = parent.getName().toUpperCase();
                String _plus_6 = "states[StateIDEnum" + _upperCase_15;
                String _plus_7 = String.valueOf(_plus_6) + "_ID.ordinal()].";
                String _plus_8 = String.valueOf(_plus_7) + "actives";
                String _plus_9 = String.valueOf(_plus_8) + "[0]";
                String _fptrCall_1 = this.getFptrCall(_plus_9, "exit");
                _builder_1.append(_fptrCall_1, "\t");
                _builder_1.append(";");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_16 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_16);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[0] = NULL;");
                _builder_1.newLineIfNotEmpty();
            }
        }
        if (exitParent) {
            _builder_1.append("setFlag");
            _builder_1.append("(StateIDEnum.");
            String _upperCase_17 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_17);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
            _builder_1.append(", false);");
            _builder_1.newLineIfNotEmpty();
            String _fptrCall_2 = this.getFptrCall(pAttr, "exit");
            _builder_1.append(_fptrCall_2);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)t);
        _builder_1.append(_transitionEffect);
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, boolean enterParent) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("// start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(StateIDEnum.");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                boolean _tripleNotEquals_1;
                State _findInitialState_1 = TransformationUtil.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                boolean bl = _tripleNotEquals_1 = _findInitialState_1 != null;
                if (_tripleNotEquals_1) {
                    String _initialEffect_1 = TransformationUtil.getInitialEffect((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                    _builder_1.append(_initialEffect_1);
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions()))), true);
                    _builder_1.append(_generateEnteringSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSubStates(State parent, State child, boolean enterParent, boolean gotoSubstate) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("// start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(StateIDEnum.");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoSubstate) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                _builder_1.append("//");
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_2 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_2);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[0] = &");
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_3 = child.getName().toUpperCase();
                _builder_1.append(_upperCase_3);
                _builder_1.append("_ID.ordinal()];");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_2 = this.generateEnteringSubStates(child, true);
                _builder_1.append(_generateEnteringSubStates_2);
                _builder_1.newLineIfNotEmpty();
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = TransformationUtil.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return TransformationUtil.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, false, false);
                    _builder_1.append(_generateEnteringSubStates_2);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return TransformationUtil.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringTransitiveSubStates(State parent, final State child, boolean enterParent, boolean gotoChild) {
        boolean _isOrthogonal;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        if (enterParent) {
            String _generateChangeState = this.generateChangeState(parent);
            _builder_1.append(_generateChangeState);
            _builder_1.newLineIfNotEmpty();
            String _fptrCall = this.getFptrCall(pAttr, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("// start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(StateIDEnum.");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (_isOrthogonal = parent.isOrthogonal()) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    if (!gotoChild) continue;
                    String _generateEnteringSubStates = this.generateEnteringSubStates(child, true);
                    _builder_1.append(_generateEnteringSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = TransformationUtil.transitiveSubStates((Region)r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return TransformationUtil.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates = this.generateEnteringTransitiveSubStates(nextParent, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates_1 = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates_1);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    if (gotoChild) {
                        String _generateEnteringSubStates_2 = this.generateEnteringSubStates(parent, child, enterParent, false);
                        _builder_1.append(_generateEnteringSubStates_2);
                        _builder_1.newLineIfNotEmpty();
                    }
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return TransformationUtil.transitiveSubStates((State)it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringTransitiveSubStates_1 = this.generateEnteringTransitiveSubStates(nextParent_1, child);
                    _builder_1.append(_generateEnteringTransitiveSubStates_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    private List<State> transitiveSubStates(Region r) {
        return TransformationUtil.transitiveSubStates((Region)r);
    }

    private List<State> transitiveSubStates(State s) {
        return TransformationUtil.transitiveSubStates((State)s);
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal(),]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = this.transitiveSubStates(r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_2 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID.ordinal(),].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] = ");
                    String _upperCase_3 = nextParent.getName().toUpperCase();
                    _builder_1.append(_upperCase_3);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] = ");
                String _upperCase_5 = TransformationUtil.findInitialState((Region)r).getName().toUpperCase();
                _builder_1.append(_upperCase_5);
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_6 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_6);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] = ");
                    String _upperCase_7 = nextParent_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_7);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    @Deprecated
    public String generateEnteringSpecial(State parent, final Pseudostate child, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)t);
        _builder_1.append(_transitionEffect);
        _builder_1.newLineIfNotEmpty();
        String _fptrCall = this.getFptrCall(pAttr, "entry");
        _builder_1.append(_fptrCall);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("// start activity of ");
        String _name = parent.getName();
        _builder_1.append(_name);
        _builder_1.append(" by calling setFlag");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("setFlag");
        _builder_1.append("(StateIDEnum.");
        String _upperCase_1 = parent.getName().toUpperCase();
        _builder_1.append(_upperCase_1);
        _builder_1.append("_ID.ordinal(), ");
        _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
        _builder_1.append(", true);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        boolean _isOrthogonal = parent.isOrthogonal();
        if (_isOrthogonal) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                boolean _tripleNotEquals;
                Region _container = child.getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)r);
                if (_equals) {
                    String _generatePseudo = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                boolean _contains = this.transitiveSubStates(r).contains(child);
                if (_contains) {
                    Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child);
                        }
                    };
                    State nextParent = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_2 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_2);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = parent.getRegions().indexOf((Object)r);
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] = ");
                    String _upperCase_3 = nextParent.getName().toUpperCase();
                    _builder_1.append(_upperCase_3);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial = this.generateEnteringSpecial(nextParent, child);
                    _builder_1.append(_generateEnteringSpecial);
                    _builder_1.newLineIfNotEmpty();
                    continue;
                }
                State _findInitialState = TransformationUtil.findInitialState((Region)r);
                boolean bl = _tripleNotEquals = _findInitialState != null;
                if (!_tripleNotEquals) continue;
                String _initialEffect = TransformationUtil.getInitialEffect((Region)r);
                _builder_1.append(_initialEffect);
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("states");
                _builder_1.append("[StateIDEnum.");
                String _upperCase_4 = parent.getName().toUpperCase();
                _builder_1.append(_upperCase_4);
                _builder_1.append("_ID.ordinal()].");
                _builder_1.append("actives");
                _builder_1.append("[");
                int _indexOf_1 = parent.getRegions().indexOf((Object)r);
                _builder_1.append((Object)_indexOf_1);
                _builder_1.append("] = ");
                String _upperCase_5 = TransformationUtil.findInitialState((Region)r).getName().toUpperCase();
                _builder_1.append(_upperCase_5);
                _builder_1.append("_ID;");
                _builder_1.newLineIfNotEmpty();
                String _generateEnteringSubStates = this.generateEnteringSubStates(TransformationUtil.findInitialState((Region)r), true);
                _builder_1.append(_generateEnteringSubStates);
                _builder_1.newLineIfNotEmpty();
            }
        } else {
            boolean _isComposite = parent.isComposite();
            if (_isComposite) {
                State _state = child.getContainer().getState();
                boolean _equals_1 = Objects.equal((Object)_state, (Object)parent);
                if (_equals_1) {
                    String _generatePseudo_1 = this.pseudostateGenerator.generatePseudo(child);
                    _builder_1.append(_generatePseudo_1);
                    _builder_1.newLineIfNotEmpty();
                } else {
                    Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

                        public Boolean apply(State it) {
                            return SM2ClassesTransformationCore.this.transitiveSubStates(it).contains(child);
                        }
                    };
                    State nextParent_1 = (State)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)Iterables.filter((Iterable)((Region)IterableExtensions.head((Iterable)parent.getRegions())).getSubvertices(), State.class), (Functions.Function1)_function_1));
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("states");
                    _builder_1.append("[StateIDEnum.");
                    String _upperCase_6 = parent.getName().toUpperCase();
                    _builder_1.append(_upperCase_6);
                    _builder_1.append("_ID.ordinal()].");
                    _builder_1.append("actives");
                    _builder_1.append("[0] = ");
                    String _upperCase_7 = nextParent_1.getName().toUpperCase();
                    _builder_1.append(_upperCase_7);
                    _builder_1.append("_ID;");
                    _builder_1.newLineIfNotEmpty();
                    String _generateEnteringSpecial_1 = this.generateEnteringSpecial(nextParent_1, child);
                    _builder_1.append(_generateEnteringSpecial_1);
                    _builder_1.newLineIfNotEmpty();
                }
            }
        }
        return _builder_1.toString();
    }

    public String generateCompletionCall(State state) {
        StringConcatenation _builder = new StringConcatenation();
        String callCompletionEvent = _builder.toString();
        State composite = state.getContainer().getState();
        if (composite == null) {
            StringConcatenation _builder_1 = new StringConcatenation();
            callCompletionEvent = _builder_1.toString();
        } else {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("if (");
            EList _regions = composite.getRegions();
            boolean _hasElements = false;
            for (Region r : _regions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" && ", "");
                }
                _builder_2.append("(");
                _builder_2.append("states");
                _builder_2.append("[StateIDEnum.");
                String _upperCase = composite.getName().toUpperCase();
                _builder_2.append(_upperCase);
                _builder_2.append("_ID.ordinal()].");
                _builder_2.append("actives");
                _builder_2.append("[");
                int _indexOf = composite.getRegions().indexOf((Object)r);
                _builder_2.append((Object)_indexOf);
                _builder_2.append("] == ");
                _builder_2.append("STATE_MAX");
                _builder_2.append(")");
            }
            _builder_2.append(") {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            _builder_2.append("eventQueue", "\t");
            _builder_2.append(".push(statemachine::EventPriority_t::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
            String _upperCase_1 = composite.getName().toUpperCase();
            _builder_2.append(_upperCase_1, "\t");
            _builder_2.append("_ID);");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}");
            callCompletionEvent = _builder_2.toString();
        }
        return callCompletionEvent;
    }

    public TransitionGraph calculateTransitionGraphs(final State s, final Transition t) {
        TransitionGraph ret = new TransitionGraph();
        Vertex _target = t.getTarget();
        ret.P.add((Pseudostate)_target);
        ret.T.add(t);
        ret.S.add(s);
        Vertex _target_1 = t.getTarget();
        Pseudostate target = (Pseudostate)_target_1;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    State _state = it.getSource().getContainer().getState();
                    State _state_1 = s.getContainer().getState();
                    return Objects.equal((Object)_state, (Object)_state_1);
                }
            };
            List ins = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)target.getIncomings(), (Functions.Function1)_function));
            Functions.Function1<Transition, Vertex> _function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            };
            Iterables.addAll(ret.S, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)ins, (Functions.Function1)_function_1), State.class));
            ret.T.addAll(ins);
        }
        List nexts = SMCommon.findTrans((Vertex)t.getTarget());
        ret.T.addAll(nexts);
        Functions.Function1<Transition, Vertex> _function_2 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return t.getTarget();
            }
        };
        Functions.Function1<Pseudostate, Boolean> _function_3 = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                return Objects.equal((Object)it.getKind(), (Object)PseudostateKind.DEEP_HISTORY_LITERAL) || Objects.equal((Object)it.getKind(), (Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
            }
        };
        Iterable H = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_2), Pseudostate.class), (Functions.Function1)_function_3);
        Iterables.addAll(ret.P, (Iterable)H);
        Functions.Function1<Transition, Vertex> _function_4 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getSource();
            }
        };
        Iterables.addAll(ret.P, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_4), Pseudostate.class));
        Functions.Function1<Transition, Vertex> _function_5 = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getTarget();
            }
        };
        Iterables.addAll(ret.L, (Iterable)Iterables.filter((Iterable)ListExtensions.map((List)nexts, (Functions.Function1)_function_5), State.class));
        return ret;
    }

    private OpaqueExpression createOpaqueExpressionDefaultValue(Property container, String name) {
        ValueSpecification _defaultValue = container.getDefaultValue();
        OpaqueExpression opaque = (OpaqueExpression)_defaultValue;
        if (opaque == null) {
            ValueSpecification _createDefaultValue = container.createDefaultValue(name, null, UMLPackage.Literals.OPAQUE_EXPRESSION);
            opaque = (OpaqueExpression)_createDefaultValue;
            opaque.getLanguages().add((Object)this.langID);
        }
        return opaque;
    }

    public OpaqueExpression createOpaqueExpressionDefaultValue(Property container, String name, String body) {
        boolean _greaterThan;
        OpaqueExpression opaque = this.createOpaqueExpressionDefaultValue(container, name);
        int _size = opaque.getBodies().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            opaque.getBodies().set(0, (Object)body);
        } else {
            opaque.getLanguages().add((Object)this.langID);
            opaque.getBodies().add((Object)body);
        }
        return opaque;
    }

    public List<State> getTransitiveParentStates(Vertex s) {
        ArrayList<State> ret = new ArrayList<State>();
        State parent = s.getContainer().getState();
        while (parent != null) {
            ret.add(parent);
            parent = parent.getContainer().getState();
        }
        return ret;
    }

    public Property createStateStruct() {
        Property _xblockexpression = null;
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)this.superContext, (String)"java::lang::Runnable");
        Interface runnable = (Interface)_qualifiedElementFromRS;
        Classifier _createNestedClassifier = this.superContext.createNestedClassifier("Entry_dft", UMLPackage.eINSTANCE.getClass_());
        Class entry_dft = (Class)_createNestedClassifier;
        entry_dft.createInterfaceRealization(null, runnable);
        Operation entry_run = entry_dft.createOwnedOperation("run", null, null);
        this.createOpaqueBehavior(entry_dft, entry_run, "");
        Classifier _createNestedClassifier_1 = this.superContext.createNestedClassifier("DoActivity_dft", UMLPackage.eINSTANCE.getClass_());
        Class doActivity_dft = (Class)_createNestedClassifier_1;
        doActivity_dft.createInterfaceRealization(null, runnable);
        Operation doActivity_run = doActivity_dft.createOwnedOperation("run", null, null);
        this.createOpaqueBehavior(doActivity_dft, doActivity_run, "");
        Classifier _createNestedClassifier_2 = this.superContext.createNestedClassifier("Exit_dft", UMLPackage.eINSTANCE.getClass_());
        Class exit_dft = (Class)_createNestedClassifier_2;
        exit_dft.createInterfaceRealization(null, runnable);
        Operation exit_run = exit_dft.createOwnedOperation("run", null, null);
        this.createOpaqueBehavior(exit_dft, exit_run, "");
        this.superContext.createOwnedAttribute("entry_dft", (Type)entry_dft);
        this.superContext.createOwnedAttribute("doActivity_dft", (Type)doActivity_dft);
        _xblockexpression = this.superContext.createOwnedAttribute("exit_dft", (Type)exit_dft);
        return _xblockexpression;
    }

    public String getFptrCall(String attr, String fptrName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(attr);
        _builder.append(".");
        _builder.append(fptrName);
        _builder.append(".run()");
        return _builder.toString();
    }

    private Map<Event, List<Transition>> getAllEvents(Region region) {
        final LinkedHashMap<Event, List<Transition>> ret = new LinkedHashMap<Event, List<Transition>>();
        EList subVertices = region.getSubvertices();
        EList transitions = region.getTransitions();
        Consumer<Transition> _function = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                EList _triggers = it.getTriggers();
                for (Trigger trigger : _triggers) {
                    boolean _contains;
                    boolean _not_1;
                    boolean _not;
                    boolean _tripleNotEquals;
                    Event _event = trigger.getEvent();
                    boolean bl = _tripleNotEquals = _event != null;
                    if (!_tripleNotEquals) continue;
                    boolean _containsKey = ret.containsKey(trigger.getEvent());
                    boolean bl2 = _not = !_containsKey;
                    if (_not) {
                        Event _event_1 = trigger.getEvent();
                        ArrayList _arrayList = new ArrayList();
                        ret.put(_event_1, _arrayList);
                    }
                    boolean bl3 = _not_1 = !(_contains = ((List)ret.get(trigger.getEvent())).contains(it));
                    if (!_not_1) continue;
                    ((List)ret.get(trigger.getEvent())).add(it);
                }
            }
        };
        transitions.forEach((Consumer)_function);
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                EList _regions = it.getRegions();
                for (Region subRe : _regions) {
                    Map<Event, List<Transition>> m = SM2ClassesTransformationCore.this.getAllEvents(subRe);
                    Set<Map.Entry<Event, List<Transition>>> _entrySet = m.entrySet();
                    for (Map.Entry<Event, List<Transition>> e : _entrySet) {
                        boolean _not;
                        boolean _containsKey = ret.containsKey(e.getKey());
                        boolean bl = _not = !_containsKey;
                        if (_not) {
                            ret.put(e.getKey(), e.getValue());
                            continue;
                        }
                        ((List)ret.get(e.getKey())).addAll((Collection)e.getValue());
                    }
                }
            }
        };
        Iterables.filter((Iterable)subVertices, State.class).forEach(_function_1);
        return ret;
    }

    private void getAllActionsTransitionsStates(Region region) {
        boolean _not;
        boolean _contains = this.regions.contains(region);
        boolean bl = _not = !_contains;
        if (_not) {
            this.regions.add(region);
        }
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                return it.getSource() != null && it.getTarget() != null;
            }
        };
        Iterables.addAll(this.transitions, (Iterable)IterableExtensions.filter((Iterable)region.getTransitions(), (Functions.Function1)_function));
        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                boolean _contains = SM2ClassesTransformationCore.this.parallelTransitions.contains(it);
                return !_contains;
            }
        };
        Consumer<Transition> _function_2 = new Consumer<Transition>(){

            @Override
            public void accept(Transition it) {
                Vertex _target;
                Vertex _source = it.getSource();
                if (_source instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getSource()).getKind(), (Object)PseudostateKind.FORK_LITERAL) && it.getEffect() != null) {
                    SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                }
                if ((_target = it.getTarget()) instanceof Pseudostate && Objects.equal((Object)((Pseudostate)it.getTarget()).getKind(), (Object)PseudostateKind.JOIN_LITERAL) && it.getEffect() != null) {
                    SM2ClassesTransformationCore.this.parallelTransitions.add(it);
                }
            }
        };
        IterableExtensions.filter(this.transitions, (Functions.Function1)_function_1).forEach(_function_2);
        EList _subvertices = region.getSubvertices();
        for (Vertex s : _subvertices) {
            this.vertexes.add(s);
            if (!(s instanceof State)) continue;
            if (!(s instanceof FinalState)) {
                this.states.add((State)s);
            }
            if (((State)s).getEntry() != null && ((State)s).getEntry() instanceof OpaqueBehavior) {
                Behavior _entry = ((State)s).getEntry();
                this.actions.add((OpaqueBehavior)_entry);
            }
            if (((State)s).getExit() != null && ((State)s).getExit() instanceof OpaqueBehavior) {
                Behavior _exit = ((State)s).getExit();
                this.actions.add((OpaqueBehavior)_exit);
            }
            if (this.createDoActivity && ((State)s).getDoActivity() != null && ((State)s).getDoActivity() instanceof OpaqueBehavior) {
                Behavior _doActivity = ((State)s).getDoActivity();
                this.actions.add((OpaqueBehavior)_doActivity);
            }
            Consumer<Region> _function_3 = new Consumer<Region>(){

                @Override
                public void accept(Region it) {
                    SM2ClassesTransformationCore.this.getAllActionsTransitionsStates(it);
                }
            };
            ((State)s).getRegions().forEach((Consumer)_function_3);
        }
    }

    private void createRegionMethods() {
        int i = 0;
        while (i < this.regions.size()) {
            this.createIntConstant(this.getRegionMacroName(this.regions.get(i)), i);
            this.createRegionMethod(this.regions.get(i));
            this.createRegionMethodExit(this.regions.get(i));
            if (this.regions.get(i).getState() != null && this.regions.get(i).getState().isOrthogonal()) {
                this.orthogonalRegions.add(this.regions.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.orthogonalRegions.size()) {
            this.createIntConstant(this.getRegionMacroId(this.orthogonalRegions.get(i)), i);
            ++i;
        }
    }

    public String getRegionMacroId(Region r) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("REGION_ID_");
        String _upperCase = r.getState().getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_");
        String _upperCase_1 = r.getName().toUpperCase();
        _builder.append(_upperCase_1);
        return _builder.toString();
    }

    public String getRegionMethodName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = r.getStateMachine().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1);
            _builder.append("_Enter");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_2 = r.getState().getName();
        _builder_1.append(_name_2);
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3);
        _builder_1.append("_Enter");
        return _builder_1.toString();
    }

    public String getRegionMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = r.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = r.getName().toUpperCase();
            _builder.append(_upperCase_1);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_2 = r.getState().getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_");
        String _upperCase_3 = r.getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        return _builder_1.toString();
    }

    public String getVertexMacroName(Vertex v) {
        Region _container = v.getContainer();
        boolean _equals = Objects.equal((Object)_container, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = this.topRegion.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = v.getContainer().getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_");
            String _upperCase_2 = v.getName().toUpperCase();
            _builder.append(_upperCase_2);
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_3 = v.getContainer().getState().getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        _builder_1.append("_");
        String _upperCase_4 = v.getContainer().getName().toUpperCase();
        _builder_1.append(_upperCase_4);
        _builder_1.append("_");
        String _upperCase_5 = v.getName().toUpperCase();
        _builder_1.append(_upperCase_5);
        return _builder_1.toString();
    }

    public String getInitialMacroName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _upperCase = r.getStateMachine().getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_");
            String _upperCase_1 = r.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_DEFAULT");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _upperCase_2 = r.getState().getName().toUpperCase();
        _builder_1.append(_upperCase_2);
        _builder_1.append("_");
        String _upperCase_3 = r.getName().toUpperCase();
        _builder_1.append(_upperCase_3);
        _builder_1.append("_DEFAULT");
        return _builder_1.toString();
    }

    private ArrayList<Vertex> getSubVertexes(State state) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        Consumer<Region> _function = new Consumer<Region>(){

            @Override
            public void accept(Region it) {
                ret.addAll(it.getSubvertices());
            }
        };
        state.getRegions().forEach((Consumer)_function);
        return ret;
    }

    private void createRegionMethod(Region r) {
        boolean _notEquals;
        boolean _tripleNotEquals;
        boolean _not;
        ArrayList<Vertex> endVertexs = new ArrayList<Vertex>();
        HashMap state2TransSubVertices = new HashMap();
        EList _subvertices = r.getSubvertices();
        for (final Vertex v : _subvertices) {
            boolean _greaterThan;
            Functions.Function1<Transition, Vertex> _function_1;
            Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    return !Objects.equal((Object)it.getContainer(), (Object)v.getContainer()) || it.getSource() instanceof State && SM2ClassesTransformationCore.this.getSubVertexes((State)it.getSource()).contains(it.getTarget());
                }
            };
            Iterable incomings = IterableExtensions.filter((Iterable)v.getIncomings(), (Functions.Function1)_function);
            Iterable sources = IterableExtensions.map((Iterable)incomings, (Functions.Function1)(_function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            }));
            int _size = IterableExtensions.size((Iterable)sources);
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                boolean _contains = endVertexs.contains(v);
                boolean bl2 = _not = !_contains;
                if (_not) {
                    endVertexs.add(v);
                }
            }
            if (!(v instanceof State)) continue;
            final ArrayList subvertices = new ArrayList();
            Consumer<Region> _function_2 = new Consumer<Region>(){

                @Override
                public void accept(Region it) {
                    subvertices.addAll(SM2ClassesTransformationCore.this.allSubVertexes(it));
                }
            };
            ((State)v).getRegions().forEach((Consumer)_function_2);
            for (Vertex subV : subvertices) {
                boolean _not_1;
                boolean _greaterThan_1;
                Functions.Function1<Vertex, Boolean> _function_4;
                Functions.Function1<Transition, Vertex> _function_3 = new Functions.Function1<Transition, Vertex>(){

                    public Vertex apply(Transition it) {
                        return it.getSource();
                    }
                };
                List sourcesOfIncomings = ListExtensions.map((List)subV.getIncomings(), (Functions.Function1)_function_3);
                Iterable sourcesOutSideOfR = IterableExtensions.filter((Iterable)sourcesOfIncomings, (Functions.Function1)(_function_4 = new Functions.Function1<Vertex, Boolean>(){

                    public Boolean apply(Vertex it) {
                        boolean _contains = subvertices.contains(it);
                        return !_contains;
                    }
                }));
                int _size_1 = IterableExtensions.size((Iterable)sourcesOutSideOfR);
                boolean bl3 = _greaterThan_1 = _size_1 > 0;
                if (!_greaterThan_1) continue;
                boolean _containsKey = state2TransSubVertices.containsKey(v);
                boolean bl4 = _not_1 = !_containsKey;
                if (_not_1) {
                    ArrayList _arrayList = new ArrayList();
                    state2TransSubVertices.put((State)v, _arrayList);
                }
                ((List)state2TransSubVertices.get(v)).add(subV);
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        String switchBody = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String body = _builder_1.toString();
        StringConcatenation _builder_2 = new StringConcatenation();
        String macros = _builder_2.toString();
        Pseudostate _firstPseudoState = TransformationUtil.firstPseudoState((Region)r, (PseudostateKind)PseudostateKind.INITIAL_LITERAL);
        boolean bl = _tripleNotEquals = _firstPseudoState != null;
        if (_tripleNotEquals) {
            boolean _isComposite;
            Pseudostate initialP = TransformationUtil.firstPseudoState((Region)r, (PseudostateKind)PseudostateKind.INITIAL_LITERAL);
            Vertex _target = ((Transition)IterableExtensions.head((Iterable)initialP.getOutgoings())).getTarget();
            State initialState = (State)_target;
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("states");
            _builder_3.append("[StateIDEnum.");
            String _upperCase = initialState.getName().toUpperCase();
            _builder_3.append(_upperCase);
            _builder_3.append("_ID.ordinal()]");
            String pAttr = _builder_3.toString();
            this.createIntConstant(this.getInitialMacroName(r), 0);
            String _body = body;
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("case ");
            String _initialMacroName = this.getInitialMacroName(r);
            _builder_4.append(_initialMacroName);
            _builder_4.append(":");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)((Transition)IterableExtensions.head((Iterable)initialP.getOutgoings())));
            _builder_4.append(_transitionEffect, "\t");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            String _generateChangeState = this.generateChangeState(initialState);
            _builder_4.append(_generateChangeState, "\t");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.newLine();
            boolean _isBehaviorExist = TransformationUtil.isBehaviorExist((Behavior)initialState.getEntry());
            if (_isBehaviorExist) {
                _builder_4.append("\t");
                String _fptrCall = this.getFptrCall(pAttr, "entry");
                _builder_4.append(_fptrCall, "\t");
                _builder_4.append(";");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("\t");
                _builder_4.append("// starting the counters for time events");
                _builder_4.newLine();
            }
            _builder_4.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(initialState, "true");
            _builder_4.append((Object)_generateActivateTimeEvent, "\t");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("\t");
            _builder_4.newLine();
            if (TransformationUtil.isBehaviorExist((Behavior)initialState.getDoActivity()) || TransformationUtil.hasTriggerlessTransition((State)initialState)) {
                _builder_4.append("\t");
                _builder_4.append("// start activity of ");
                String _name = initialState.getName();
                _builder_4.append(_name, "\t");
                _builder_4.append(" by calling setFlag");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("\t");
                _builder_4.append("setFlag", "\t");
                _builder_4.append("(StateIDEnum.");
                String _upperCase_1 = initialState.getName().toUpperCase();
                _builder_4.append(_upperCase_1, "\t");
                _builder_4.append("_ID.ordinal(), ");
                _builder_4.append("ThreadFunctions.TF_DO_ACTIVITY", "\t");
                _builder_4.append(", true);");
                _builder_4.newLineIfNotEmpty();
            }
            if (_isComposite = initialState.isComposite()) {
                boolean _isOrthogonal = initialState.isOrthogonal();
                if (_isOrthogonal) {
                    _builder_4.append("\t");
                    _builder_4.append("//TODO: fork region funtions");
                    _builder_4.newLine();
                    EList _regions = initialState.getRegions();
                    for (Region subRegion : _regions) {
                        _builder_4.append("\t");
                        _builder_4.append("//");
                        String _regionMethodName = this.getRegionMethodName(subRegion);
                        _builder_4.append(_regionMethodName, "\t");
                        _builder_4.append("(");
                        String _initialMacroName_1 = this.getInitialMacroName(subRegion);
                        _builder_4.append(_initialMacroName_1, "\t");
                        _builder_4.append(");");
                        _builder_4.newLineIfNotEmpty();
                        _builder_4.append("\t");
                        String _generateForkCall = this.concurrency.generateForkCall(subRegion, true, this.getInitialMacroName(subRegion));
                        _builder_4.append(_generateForkCall, "\t");
                        _builder_4.newLineIfNotEmpty();
                    }
                    _builder_4.append("\t");
                    _builder_4.append("//TODO: join region functions");
                    _builder_4.newLine();
                    EList _regions_1 = initialState.getRegions();
                    for (Region subRegion_1 : _regions_1) {
                        _builder_4.append("\t");
                        _builder_4.append("//");
                        String _regionMethodName_1 = this.getRegionMethodName(subRegion_1);
                        _builder_4.append(_regionMethodName_1, "\t");
                        _builder_4.append("(");
                        String _initialMacroName_2 = this.getInitialMacroName(subRegion_1);
                        _builder_4.append(_initialMacroName_2, "\t");
                        _builder_4.append(");");
                        _builder_4.newLineIfNotEmpty();
                        _builder_4.append("\t");
                        String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, true);
                        _builder_4.append(_generateJoinCall, "\t");
                        _builder_4.newLineIfNotEmpty();
                    }
                } else {
                    _builder_4.append("\t");
                    String _regionMethodName_2 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)initialState.getRegions()));
                    _builder_4.append(_regionMethodName_2, "\t");
                    _builder_4.append("(");
                    String _initialMacroName_3 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)initialState.getRegions()));
                    _builder_4.append(_initialMacroName_3, "\t");
                    _builder_4.append(");");
                    _builder_4.newLineIfNotEmpty();
                }
            }
            _builder_4.append("\t");
            _builder_4.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_4.newLine();
            _builder_4.append("\t");
            _builder_4.append("break;");
            body = String.valueOf(_body) + _builder_4;
        }
        int i = 0;
        while (i < endVertexs.size()) {
            this.createIntConstant(this.getVertexMacroName((Vertex)endVertexs.get(i)), i + 1);
            ++i;
        }
        boolean _isApplied = StereotypeUtil.isApplied((Element)this.superContext, Import.class);
        boolean bl5 = _not = !_isApplied;
        if (_not) {
            StereotypeUtil.apply((Element)this.superContext, Import.class);
        }
        Operation regionMethod = this.superContext.createOwnedOperation(this.getRegionMethodName(r), null, null);
        regionMethod.createOwnedParameter("enter_mode", this.intType);
        for (Vertex v_1 : endVertexs) {
            if (v_1 instanceof State) {
                boolean _isComposite_1;
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("states");
                _builder_5.append("[StateIDEnum.");
                String _upperCase_2 = ((State)v_1).getName().toUpperCase();
                _builder_5.append(_upperCase_2);
                _builder_5.append("_ID.ordinal()]");
                String pAttr_1 = _builder_5.toString();
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append(body);
                _builder_6.newLineIfNotEmpty();
                _builder_6.append("case ");
                String _vertexMacroName = this.getVertexMacroName(v_1);
                _builder_6.append(_vertexMacroName);
                _builder_6.append(":");
                _builder_6.newLineIfNotEmpty();
                _builder_6.append("\t");
                String _generateChangeState_1 = this.generateChangeState((State)v_1);
                _builder_6.append(_generateChangeState_1, "\t");
                _builder_6.newLineIfNotEmpty();
                boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist((Behavior)((State)v_1).getEntry());
                if (_isBehaviorExist_1) {
                    _builder_6.append("\t");
                    String _fptrCall_1 = this.getFptrCall(pAttr_1, "entry");
                    _builder_6.append(_fptrCall_1, "\t");
                    _builder_6.append(";");
                    _builder_6.newLineIfNotEmpty();
                }
                _builder_6.append("\t");
                _builder_6.append("//starting the counters for time events");
                _builder_6.newLine();
                _builder_6.append("\t");
                CharSequence _generateActivateTimeEvent_1 = this.generateActivateTimeEvent((State)v_1, "true");
                _builder_6.append((Object)_generateActivateTimeEvent_1, "\t");
                _builder_6.newLineIfNotEmpty();
                if (TransformationUtil.isBehaviorExist((Behavior)((State)v_1).getDoActivity()) || TransformationUtil.hasTriggerlessTransition((State)((State)v_1))) {
                    _builder_6.append("\t");
                    _builder_6.append("// start activity of ");
                    String _name_1 = ((State)v_1).getName();
                    _builder_6.append(_name_1, "\t");
                    _builder_6.append(" by calling setFlag");
                    _builder_6.newLineIfNotEmpty();
                    _builder_6.append("\t");
                    _builder_6.append("setFlag", "\t");
                    _builder_6.append("(StateIDEnum.");
                    String _upperCase_3 = ((State)v_1).getName().toUpperCase();
                    _builder_6.append(_upperCase_3, "\t");
                    _builder_6.append("_ID.ordinal(), ");
                    _builder_6.append("ThreadFunctions.TF_DO_ACTIVITY", "\t");
                    _builder_6.append(", true);");
                    _builder_6.newLineIfNotEmpty();
                }
                if (_isComposite_1 = ((State)v_1).isComposite()) {
                    boolean _isOrthogonal_1 = ((State)v_1).isOrthogonal();
                    if (_isOrthogonal_1) {
                        _builder_6.append("\t");
                        _builder_6.append("//TODO: fork region funtions");
                        _builder_6.newLine();
                        EList _regions_2 = ((State)v_1).getRegions();
                        for (Region subRegion_2 : _regions_2) {
                            _builder_6.append("\t");
                            _builder_6.append("//");
                            String _regionMethodName_3 = this.getRegionMethodName(subRegion_2);
                            _builder_6.append(_regionMethodName_3, "\t");
                            _builder_6.append("(");
                            String _initialMacroName_4 = this.getInitialMacroName(subRegion_2);
                            _builder_6.append(_initialMacroName_4, "\t");
                            _builder_6.append(");");
                            _builder_6.newLineIfNotEmpty();
                            _builder_6.append("\t");
                            String _generateForkCall_1 = this.concurrency.generateForkCall(subRegion_2, true, this.getInitialMacroName(subRegion_2));
                            _builder_6.append(_generateForkCall_1, "\t");
                            _builder_6.newLineIfNotEmpty();
                        }
                        _builder_6.append("\t");
                        _builder_6.append("//TODO: join region functions");
                        _builder_6.newLine();
                        EList _regions_3 = ((State)v_1).getRegions();
                        for (Region subRegion_3 : _regions_3) {
                            _builder_6.append("\t");
                            _builder_6.append("//");
                            String _regionMethodName_4 = this.getRegionMethodName(subRegion_3);
                            _builder_6.append(_regionMethodName_4, "\t");
                            _builder_6.append("(");
                            String _initialMacroName_5 = this.getInitialMacroName(subRegion_3);
                            _builder_6.append(_initialMacroName_5, "\t");
                            _builder_6.append(");");
                            _builder_6.newLineIfNotEmpty();
                            _builder_6.append("\t");
                            String _generateJoinCall_1 = this.concurrency.generateJoinCall(subRegion_3, true);
                            _builder_6.append(_generateJoinCall_1, "\t");
                            _builder_6.newLineIfNotEmpty();
                        }
                    } else {
                        _builder_6.append("\t");
                        String _regionMethodName_5 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)((State)v_1).getRegions()));
                        _builder_6.append(_regionMethodName_5, "\t");
                        _builder_6.append("(");
                        String _initialMacroName_6 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)((State)v_1).getRegions()));
                        _builder_6.append(_initialMacroName_6, "\t");
                        _builder_6.append(");");
                        _builder_6.newLineIfNotEmpty();
                    }
                }
                _builder_6.append("\t");
                _builder_6.append("//TODO: set systemState to EVENT_CONSUMED");
                _builder_6.newLine();
                _builder_6.append("\t");
                _builder_6.append("break;");
                body = _builder_6.toString();
                continue;
            }
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append(body);
            _builder_7.newLineIfNotEmpty();
            _builder_7.append("case ");
            String _vertexMacroName_1 = this.getVertexMacroName(v_1);
            _builder_7.append(_vertexMacroName_1);
            _builder_7.append(": ");
            _builder_7.newLineIfNotEmpty();
            _builder_7.append("\t");
            String _generatePseudo = this.pseudostateGenerator.generatePseudo((Pseudostate)v_1);
            _builder_7.append(_generatePseudo, "\t");
            _builder_7.newLineIfNotEmpty();
            _builder_7.append("\t");
            _builder_7.append("//TODO: set systemState to EVENT_CONSUMED");
            _builder_7.newLine();
            _builder_7.append("\t");
            _builder_7.append("break;");
            body = _builder_7.toString();
        }
        boolean bl6 = _notEquals = !Objects.equal((Object)r, (Object)this.topRegion);
        if (_notEquals) {
            Set _entrySet = state2TransSubVertices.entrySet();
            for (Map.Entry e : _entrySet) {
                State state = (State)e.getKey();
                List _value = (List)e.getValue();
                for (Vertex transitiveSubVertex : _value) {
                    StringConcatenation _builder_8 = new StringConcatenation();
                    _builder_8.append(body);
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("case ");
                    String _vertexMacroName_2 = this.getVertexMacroName(transitiveSubVertex);
                    _builder_8.append(_vertexMacroName_2);
                    _builder_8.append(":");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t");
                    String _generateEnteringOnSubVertex = this.generateEnteringOnSubVertex(state, transitiveSubVertex);
                    _builder_8.append(_generateEnteringOnSubVertex, "\t");
                    _builder_8.newLineIfNotEmpty();
                    _builder_8.append("\t");
                    _builder_8.append("break;");
                    body = _builder_8.toString();
                }
            }
        }
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("switch(");
        _builder_8.append("enter_mode");
        _builder_8.append(") {");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append(body, "\t");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("}");
        _builder_8.newLine();
        switchBody = _builder_8.toString();
        this.createOpaqueBehavior(this.superContext, regionMethod, switchBody);
    }

    public String generateEnteringOnSubVertex(State parent, final Vertex subVertex) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase = parent.getName().toUpperCase();
        _builder.append(_upperCase);
        _builder.append("_ID.ordinal()]");
        String pAttr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        String _generateChangeState = this.generateChangeState(parent);
        _builder_1.append(_generateChangeState);
        _builder_1.newLineIfNotEmpty();
        boolean _isBehaviorExist = TransformationUtil.isBehaviorExist((Behavior)parent.getEntry());
        if (_isBehaviorExist) {
            String _fptrCall = this.getFptrCall(pAttr, "entry");
            _builder_1.append(_fptrCall);
            _builder_1.append(";");
            _builder_1.newLineIfNotEmpty();
        }
        _builder_1.append("//starting the counters for time events");
        _builder_1.newLine();
        CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(parent, "true");
        _builder_1.append((Object)_generateActivateTimeEvent);
        _builder_1.newLineIfNotEmpty();
        if (TransformationUtil.isBehaviorExist((Behavior)parent.getDoActivity()) || TransformationUtil.hasTriggerlessTransition((State)parent)) {
            _builder_1.append("// start activity of ");
            String _name = parent.getName();
            _builder_1.append(_name);
            _builder_1.append(" by calling setFlag");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("setFlag");
            _builder_1.append("(StateIDEnum.");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_1.append(_upperCase_1);
            _builder_1.append("_ID.ordinal(), ");
            _builder_1.append("ThreadFunctions.TF_DO_ACTIVITY");
            _builder_1.append(", true);");
            _builder_1.newLineIfNotEmpty();
        }
        if (parent.isComposite() && !Objects.equal((Object)parent, (Object)subVertex)) {
            boolean _isOrthogonal = parent.isOrthogonal();
            if (_isOrthogonal) {
                ArrayList<Region> toJoinList = new ArrayList<Region>();
                _builder_1.newLineIfNotEmpty();
                EList _regions = parent.getRegions();
                for (Region r : _regions) {
                    boolean _tripleNotEquals_1;
                    if (subVertex != null) {
                        boolean _tripleNotEquals;
                        Region _container = subVertex.getContainer();
                        boolean _equals = Objects.equal((Object)_container, (Object)r);
                        if (_equals) {
                            boolean _add = toJoinList.add(r);
                            _builder_1.append((Object)_add);
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append("//");
                            String _regionMethodName = this.getRegionMethodName(r);
                            _builder_1.append(_regionMethodName);
                            _builder_1.append("(");
                            String _vertexMacroName = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName);
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                            String _generateForkCall = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder_1.append(_generateForkCall);
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        boolean _contains = this.allSubVertexes(r).contains(subVertex);
                        if (_contains) {
                            boolean _add_1 = toJoinList.add(r);
                            _builder_1.append((Object)_add_1);
                            _builder_1.newLineIfNotEmpty();
                            _builder_1.append("//");
                            String _regionMethodName_1 = this.getRegionMethodName(r);
                            _builder_1.append(_regionMethodName_1);
                            _builder_1.append("(");
                            String _vertexMacroName_1 = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName_1);
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                            String _generateForkCall_1 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder_1.append(_generateForkCall_1);
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        State _findInitialState = TransformationUtil.findInitialState((Region)r);
                        boolean bl = _tripleNotEquals = _findInitialState != null;
                        if (!_tripleNotEquals) continue;
                        boolean _add_2 = toJoinList.add(r);
                        _builder_1.append((Object)_add_2);
                        _builder_1.newLineIfNotEmpty();
                        _builder_1.append("//");
                        String _regionMethodName_2 = this.getRegionMethodName(r);
                        _builder_1.append(_regionMethodName_2);
                        _builder_1.append("(");
                        String _initialMacroName = this.getInitialMacroName(r);
                        _builder_1.append(_initialMacroName);
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                        String _generateForkCall_2 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                        _builder_1.append(_generateForkCall_2);
                        _builder_1.newLineIfNotEmpty();
                        continue;
                    }
                    if (subVertex != null && subVertex.getContainer() == null) {
                        EObject _eContainer = subVertex.eContainer();
                        boolean _equals_1 = Objects.equal((Object)_eContainer, (Object)parent);
                        if (_equals_1) {
                            boolean _add_3 = toJoinList.add(r);
                            _builder_1.append((Object)_add_3);
                            _builder_1.newLineIfNotEmpty();
                            String _generateForkCall_3 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                            _builder_1.append(_generateForkCall_3);
                            _builder_1.newLineIfNotEmpty();
                            continue;
                        }
                        boolean _add_4 = toJoinList.add(r);
                        _builder_1.append((Object)_add_4);
                        _builder_1.newLineIfNotEmpty();
                        String _generateForkCall_4 = this.concurrency.generateForkCall(r, true, this.getVertexMacroName(subVertex));
                        _builder_1.append(_generateForkCall_4);
                        _builder_1.newLineIfNotEmpty();
                        continue;
                    }
                    State _findInitialState_1 = TransformationUtil.findInitialState((Region)r);
                    boolean bl = _tripleNotEquals_1 = _findInitialState_1 != null;
                    if (!_tripleNotEquals_1) continue;
                    boolean _add_5 = toJoinList.add(r);
                    _builder_1.append((Object)_add_5);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("//");
                    String _regionMethodName_3 = this.getRegionMethodName(r);
                    _builder_1.append(_regionMethodName_3);
                    _builder_1.append("(");
                    String _initialMacroName_1 = this.getInitialMacroName(r);
                    _builder_1.append(_initialMacroName_1);
                    _builder_1.append(");");
                    _builder_1.newLineIfNotEmpty();
                    String _generateForkCall_5 = this.concurrency.generateForkCall(r, true, this.getInitialMacroName(r));
                    _builder_1.append(_generateForkCall_5);
                    _builder_1.newLineIfNotEmpty();
                }
                for (Region r_1 : toJoinList) {
                    String _generateJoinCall = this.concurrency.generateJoinCall(r_1, true);
                    _builder_1.append(_generateJoinCall);
                    _builder_1.newLineIfNotEmpty();
                }
            } else {
                boolean _isComposite = parent.isComposite();
                if (_isComposite) {
                    if (subVertex != null) {
                        if (subVertex.getContainer() == null && subVertex.eContainer() instanceof State) {
                            String _regionMethodName_4 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                            _builder_1.append(_regionMethodName_4);
                            _builder_1.append("(");
                            String _vertexMacroName_2 = this.getVertexMacroName(subVertex);
                            _builder_1.append(_vertexMacroName_2);
                            _builder_1.append(");");
                            _builder_1.newLineIfNotEmpty();
                        } else {
                            State _state = subVertex.getContainer().getState();
                            boolean _equals_2 = Objects.equal((Object)_state, (Object)parent);
                            if (_equals_2) {
                                String _regionMethodName_5 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                                _builder_1.append(_regionMethodName_5);
                                _builder_1.append("(");
                                String _vertexMacroName_3 = this.getVertexMacroName(subVertex);
                                _builder_1.append(_vertexMacroName_3);
                                _builder_1.append(");");
                                _builder_1.newLineIfNotEmpty();
                            } else {
                                Functions.Function1<Region, Boolean> _function = new Functions.Function1<Region, Boolean>(){

                                    public Boolean apply(Region it) {
                                        return SM2ClassesTransformationCore.this.allSubVertexes(it).contains(subVertex);
                                    }
                                };
                                Region containingRegion = (Region)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)parent.getRegions(), (Functions.Function1)_function));
                                _builder_1.newLineIfNotEmpty();
                                String _regionMethodName_6 = this.getRegionMethodName(containingRegion);
                                _builder_1.append(_regionMethodName_6);
                                _builder_1.append("(");
                                String _vertexMacroName_4 = this.getVertexMacroName(subVertex);
                                _builder_1.append(_vertexMacroName_4);
                                _builder_1.append(");");
                                _builder_1.newLineIfNotEmpty();
                            }
                        }
                    } else {
                        String _regionMethodName_7 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                        _builder_1.append(_regionMethodName_7);
                        _builder_1.append("(");
                        String _initialMacroName_2 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                        _builder_1.append(_initialMacroName_2);
                        _builder_1.append(");");
                        _builder_1.newLineIfNotEmpty();
                    }
                }
            }
        } else if (parent.isComposite() && Objects.equal((Object)parent, (Object)subVertex)) {
            boolean _isOrthogonal_1 = parent.isOrthogonal();
            if (_isOrthogonal_1) {
                ArrayList<Region> toJoinList_1 = new ArrayList<Region>();
                _builder_1.newLineIfNotEmpty();
                EList _regions_1 = parent.getRegions();
                for (Region r_2 : _regions_1) {
                    boolean _tripleNotEquals_2;
                    State _findInitialState_2 = TransformationUtil.findInitialState((Region)r_2);
                    boolean bl = _tripleNotEquals_2 = _findInitialState_2 != null;
                    if (!_tripleNotEquals_2) continue;
                    boolean _add_6 = toJoinList_1.add(r_2);
                    _builder_1.append((Object)_add_6);
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append("//");
                    String _regionMethodName_8 = this.getRegionMethodName(r_2);
                    _builder_1.append(_regionMethodName_8);
                    _builder_1.append("(");
                    String _initialMacroName_3 = this.getInitialMacroName(r_2);
                    _builder_1.append(_initialMacroName_3);
                    _builder_1.append(");");
                    _builder_1.newLineIfNotEmpty();
                    String _generateForkCall_6 = this.concurrency.generateForkCall(r_2, true, this.getInitialMacroName(r_2));
                    _builder_1.append(_generateForkCall_6);
                    _builder_1.newLineIfNotEmpty();
                }
                for (Region r_3 : toJoinList_1) {
                    String _generateJoinCall_1 = this.concurrency.generateJoinCall(r_3, true);
                    _builder_1.append(_generateJoinCall_1);
                    _builder_1.newLineIfNotEmpty();
                }
            } else {
                boolean _tripleNotEquals_3;
                State _findInitialState_3 = TransformationUtil.findInitialState((Region)((Region)IterableExtensions.head((Iterable)parent.getRegions())));
                boolean bl = _tripleNotEquals_3 = _findInitialState_3 != null;
                if (_tripleNotEquals_3) {
                    String _regionMethodName_9 = this.getRegionMethodName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                    _builder_1.append(_regionMethodName_9);
                    _builder_1.append("(");
                    String _initialMacroName_4 = this.getInitialMacroName((Region)IterableExtensions.head((Iterable)parent.getRegions()));
                    _builder_1.append(_initialMacroName_4);
                    _builder_1.append(");");
                    _builder_1.newLineIfNotEmpty();
                }
            }
            _builder_1.append("\t\t");
        }
        return _builder_1.toString();
    }

    private void createRegionMethodExit(Region r) {
        if (r.getState() == null || !r.getState().isComposite()) {
            return;
        }
        State parent = r.getState();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("//exiting region ");
        String _name = r.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        int regionIndex = r.getState().getRegions().indexOf((Object)r);
        _builder.newLineIfNotEmpty();
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && it.isComposite();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (State s : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            _builder.append("states");
            _builder.append("[StateIDEnum.");
            String _upperCase = parent.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID.ordinal()].");
            _builder.append("actives");
            _builder.append("[");
            _builder.append((Object)regionIndex);
            _builder.append("] == ");
            String _upperCase_1 = s.getName().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_ID) {");
            _builder.newLineIfNotEmpty();
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                EList _regions = s.getRegions();
                for (Region subRegion : _regions) {
                    _builder.append("\t");
                    String _generateForkCall = this.concurrency.generateForkCall(subRegion, false, "0");
                    _builder.append(_generateForkCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
                EList _regions_1 = s.getRegions();
                for (Region subRegion_1 : _regions_1) {
                    _builder.append("\t");
                    String _generateJoinCall = this.concurrency.generateJoinCall(subRegion_1, false);
                    _builder.append(_generateJoinCall, "\t");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                _builder.append("\t");
                String _regionMethodExitName = this.getRegionMethodExitName((Region)IterableExtensions.head((Iterable)s.getRegions()));
                _builder.append(_regionMethodExitName, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("if (");
        _builder.append("states");
        _builder.append("[StateIDEnum.");
        String _upperCase_2 = parent.getName().toUpperCase();
        _builder.append(_upperCase_2);
        _builder.append("_ID.ordinal()].");
        _builder.append("actives");
        _builder.append("[");
        _builder.append((Object)regionIndex);
        _builder.append("] != ");
        _builder.append("STATE_MAX");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//signal to exit the doActivity of sub-state of ");
        String _name_1 = parent.getName();
        _builder.append(_name_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("setFlag", "\t");
        _builder.append("(");
        _builder.append("states", "\t");
        _builder.append("[StateIDEnum.");
        String _upperCase_3 = parent.getName().toUpperCase();
        _builder.append(_upperCase_3, "\t");
        _builder.append("_ID.ordinal()].");
        _builder.append("actives", "\t");
        _builder.append("[0], ");
        _builder.append("ThreadFunctions.TF_DO_ACTIVITY", "\t");
        _builder.append(", false);");
        _builder.newLineIfNotEmpty();
        Iterable _filter_1 = Iterables.filter((Iterable)r.getSubvertices(), State.class);
        boolean _hasElements_1 = false;
        for (State sub : _filter_1) {
            boolean _tripleNotEquals;
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            List<TimeEvent> _get = this.states2TimeEvents.get(sub);
            boolean bl = _tripleNotEquals = _get != null;
            if (!_tripleNotEquals) continue;
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_4 = sub.getName().toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == ");
            _builder.append("states", "\t");
            _builder.append("[StateIDEnum.");
            String _upperCase_5 = parent.getName().toUpperCase();
            _builder.append(_upperCase_5, "\t");
            _builder.append("_ID.ordinal()].");
            _builder.append("actives", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("]) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.generateActivateTimeEvent(sub, "false");
            _builder.append((Object)_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("//exit action of sub-state of ");
        String _name_2 = parent.getName();
        _builder.append(_name_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append("states", "\t");
        _builder.append("[StateIDEnum.");
        _builder.append("states", "\t");
        _builder.append("[");
        String _upperCase_6 = parent.getName().toUpperCase();
        _builder.append(_upperCase_6, "\t");
        _builder.append("_ID.ordinal()].");
        _builder.append("actives", "\t");
        _builder.append("[0]].");
        _builder.append("exit", "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _isSavehistory = TransformationUtil.isSavehistory((Region)this.topRegion, (Region)r);
        if (_isSavehistory) {
            _builder.append("\t");
            _builder.append("//save history region ");
            String _name_3 = r.getName();
            _builder.append(_name_3, "\t");
            _builder.append(" of state ");
            String _name_4 = parent.getName();
            _builder.append(_name_4, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("states", "\t");
            _builder.append("[StateIDEnum.");
            String _upperCase_7 = parent.getName().toUpperCase();
            _builder.append(_upperCase_7, "\t");
            _builder.append("_ID.ordinal()].");
            _builder.append("previousStates", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("] = ");
            _builder.append("states", "\t");
            _builder.append("[StateIDEnum.");
            String _upperCase_8 = parent.getName().toUpperCase();
            _builder.append(_upperCase_8, "\t");
            _builder.append("_ID.ordinal()].");
            _builder.append("actives", "\t");
            _builder.append("[");
            _builder.append((Object)regionIndex, "\t");
            _builder.append("];");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("//set active sub-state of ");
        String _name_5 = parent.getName();
        _builder.append(_name_5, "\t");
        _builder.append(" to ");
        _builder.append("STATE_MAX", "\t");
        _builder.append(" meaning NULL");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("states", "\t");
        _builder.append("[StateIDEnum.");
        String _upperCase_9 = parent.getName().toUpperCase();
        _builder.append(_upperCase_9, "\t");
        _builder.append("_ID.ordinal()].");
        _builder.append("actives", "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("] = ");
        _builder.append("STATE_MAX", "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        String body = _builder.toString();
        Operation exitOp = this.superContext.createOwnedOperation(this.getRegionMethodExitName(r), null, null);
        this.createOpaqueBehavior(this.superContext, exitOp, body);
    }

    private String getRegionMethodExitName(Region r) {
        boolean _equals = Objects.equal((Object)r, (Object)this.topRegion);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            String _name = r.getStateMachine().getName();
            _builder.append(_name);
            _builder.append("_");
            String _name_1 = r.getName();
            _builder.append(_name_1);
            _builder.append("_Exit");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_2 = r.getState().getName();
        _builder_1.append(_name_2);
        _builder_1.append("_");
        String _name_3 = r.getName();
        _builder_1.append(_name_3);
        _builder_1.append("_Exit");
        return _builder_1.toString();
    }

    public List<Vertex> allSubVertexes(Region r) {
        final ArrayList<Vertex> ret = new ArrayList<Vertex>();
        ret.addAll((Collection<Vertex>)r.getSubvertices());
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                Consumer<Region> _function = new Consumer<Region>(){

                    @Override
                    public void accept(Region it) {
                        ret.addAll(SM2ClassesTransformationCore.this.allSubVertexes(it));
                    }
                };
                it.getRegions().forEach((Consumer)_function);
            }
        };
        Iterables.filter((Iterable)r.getSubvertices(), State.class).forEach(_function);
        return ret;
    }

    private OpaqueBehavior createOpaqueBehavior(Class container, Operation op) {
        OpaqueBehavior opaque = (OpaqueBehavior)IterableExtensions.head((Iterable)Iterables.filter((Iterable)op.getMethods(), OpaqueBehavior.class));
        if (opaque == null) {
            Behavior _createClassifierBehavior = container.createClassifierBehavior(op.getName(), UMLPackage.Literals.OPAQUE_BEHAVIOR);
            opaque = (OpaqueBehavior)_createClassifierBehavior;
            op.getMethods().add((Object)opaque);
            opaque.getLanguages().add((Object)this.langID);
        }
        return opaque;
    }

    public OpaqueBehavior createOpaqueBehavior(Class container, Operation op, String body) {
        boolean _greaterThan;
        OpaqueBehavior opaque = this.createOpaqueBehavior(container, op);
        int _size = opaque.getBodies().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            opaque.getBodies().set(0, (Object)body);
        } else {
            opaque.getLanguages().add((Object)this.langID);
            opaque.getBodies().add((Object)body);
        }
        return opaque;
    }

    public Operation createDerivedOperation(Class clz, Operation source) {
        Operation _xblockexpression = null;
        String name = source.getName();
        Operation derivedOp = clz.createOwnedOperation(name, null, null);
        derivedOp.setName(name);
        StereotypeUtil.apply((Element)derivedOp, DerivedElement.class);
        DerivedElement _stereotypeApplication = (DerivedElement)UMLUtil.getStereotypeApplication((Element)derivedOp, DerivedElement.class);
        _stereotypeApplication.setSource((Element)source);
        this.setVirtual(derivedOp);
        _xblockexpression = derivedOp;
        return _xblockexpression;
    }

    public void copyParameters(Operation source, Operation target, boolean isCopyReturn) {
        String name = target.getName();
        if (!isCopyReturn) {
            Functions.Function1<Parameter, Boolean> _function = new Functions.Function1<Parameter, Boolean>(){

                public Boolean apply(Parameter it) {
                    ParameterDirectionKind _direction = it.getDirection();
                    return Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
                }
            };
            Iterable ret = IterableExtensions.filter((Iterable)target.getOwnedParameters(), (Functions.Function1)_function);
            CollectionExtensions.removeAll((Collection)target.getOwnedParameters(), (Iterable)ret);
        }
        EList _stereotypeApplications = target.getStereotypeApplications();
        for (EObject stt : _stereotypeApplications) {
            StereotypeUtil.apply((Element)target, stt.getClass());
        }
        target.setName(name);
    }

    private Object setVirtual(Operation op) {
        return null;
    }

    public String getGuard(Transition t) {
        ValueSpecification _specification = t.getGuard().getSpecification();
        return (String)IterableExtensions.head((Iterable)((OpaqueExpression)_specification).getBodies());
    }
}

