/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.library.statemachine.TransformationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PseudostateGenerator {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;

    public PseudostateGenerator(SM2ClassesTransformationCore core) {
        this.core = core;
        this.cdefs = core.cdefs;
    }

    public String generatePseudo(Pseudostate p) {
        String ret = "";
        PseudostateKind _kind = p.getKind();
        if (_kind != null) {
            switch (_kind) {
                case JUNCTION_LITERAL: {
                    ret = this.generateJunction(p);
                    break;
                }
                case JOIN_LITERAL: {
                    ret = this.generateJoin(p);
                    break;
                }
                case FORK_LITERAL: {
                    ret = this.generateFork(p);
                    break;
                }
                case CHOICE_LITERAL: {
                    ret = this.generateChoice(p);
                    break;
                }
                case SHALLOW_HISTORY_LITERAL: {
                    ret = this.generateShallowHistory(p);
                    break;
                }
                case DEEP_HISTORY_LITERAL: {
                    ret = this.generateDeepHistory(p);
                    break;
                }
                case ENTRY_POINT_LITERAL: {
                    ret = this.generateEntryPoint(p);
                    break;
                }
                case EXIT_POINT_LITERAL: {
                    ret = this.generateExitPoint(p);
                    break;
                }
                case INITIAL_LITERAL: {
                    break;
                }
                case TERMINATE_LITERAL: {
                    break;
                }
            }
        }
        return ret;
    }

    public String generateJunction(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        boolean _hasElements = false;
        for (Transition out : _outgoings) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _name = p.getName();
            _builder.append(_name);
            _builder.append(" == ");
            int _indexOf = p.getOutgoings().indexOf((Object)out);
            _builder.append((Object)_indexOf);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, out.getTarget(), out);
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        String ret = _builder.toString();
        return ret;
    }

    public String generateBetweenVertex(Vertex v1, Vertex v2, Transition t) {
        ArrayList<Vertex> exits = new ArrayList<Vertex>();
        ArrayList<Vertex> enters = new ArrayList<Vertex>();
        this.core.eventTransform.calculateExitsEnters(t, exits, enters);
        Vertex cpEx = (Vertex)IterableExtensions.last(exits);
        StringConcatenation _builder = new StringConcatenation();
        if (cpEx instanceof State) {
            String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
            _builder.append(_generateExitingSubStates);
            _builder.newLineIfNotEmpty();
        }
        String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)t);
        _builder.append(_transitionEffect);
        _builder.newLineIfNotEmpty();
        String ret = _builder.toString();
        Vertex cpEn = (Vertex)IterableExtensions.last(enters);
        Vertex innermost = (Vertex)IterableExtensions.head(enters);
        if (innermost instanceof State) {
            String _ret = ret;
            StringConcatenation _builder_1 = new StringConcatenation();
            if (innermost instanceof FinalState) {
                Region _container = ((FinalState)innermost).getContainer();
                boolean _equals = Objects.equal((Object)_container, (Object)this.core.topRegion);
                if (_equals) {
                    _builder_1.append("activeStateID");
                    _builder_1.append(" = ");
                    _builder_1.append("STATE_MAX");
                    _builder_1.append(";");
                    _builder_1.newLineIfNotEmpty();
                } else {
                    _builder_1.append("states");
                    _builder_1.append("[");
                    _builder_1.append("activeStateID");
                    _builder_1.append("].");
                    _builder_1.append("actives");
                    _builder_1.append("[");
                    int _indexOf = ((FinalState)innermost).getContainer().getState().getRegions().indexOf((Object)((FinalState)innermost).getContainer());
                    _builder_1.append((Object)_indexOf);
                    _builder_1.append("] = ");
                    _builder_1.append("STATE_MAX");
                    _builder_1.append(";");
                    _builder_1.newLineIfNotEmpty();
                    String _generateCompletionCall = this.core.generateCompletionCall((State)innermost);
                    _builder_1.append(_generateCompletionCall);
                    _builder_1.newLineIfNotEmpty();
                }
            } else {
                CharSequence _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_1.append((Object)_generateEnteringOnSubVertex);
                _builder_1.newLineIfNotEmpty();
            }
            ret = String.valueOf(_ret) + _builder_1;
        } else {
            String _ret_1 = ret;
            StringConcatenation _builder_2 = new StringConcatenation();
            if (cpEn instanceof State) {
                CharSequence _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_2.append((Object)_generateEnteringOnSubVertex_1);
                _builder_2.newLineIfNotEmpty();
            } else {
                String _generatePseudo = this.generatePseudo((Pseudostate)innermost);
                _builder_2.append(_generatePseudo);
                _builder_2.newLineIfNotEmpty();
            }
            ret = String.valueOf(_ret_1) + _builder_2;
        }
        return ret;
    }

    public String generateDeepHistory(Pseudostate p) {
        boolean _greaterThan;
        int regionIndex = p.getContainer().getState().getRegions().indexOf((Object)p.getContainer());
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && it.isComposite();
            }
        };
        Iterable subCompositeStates = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)p.getContainer().getSubvertices(), State.class), (Functions.Function1)_function);
        String _upperCase = p.getContainer().getState().getName().toUpperCase();
        String parentId = String.valueOf(_upperCase) + "_ID";
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && !it.isComposite();
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)p.getContainer().getSubvertices(), State.class), (Functions.Function1)_function_1);
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return PseudostateGenerator.this.core.states2TimeEvents.get(it) != null && !PseudostateGenerator.this.core.states2TimeEvents.get(it).isEmpty();
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_2);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unsigned int ");
        CharSequence _deepHistoryVariableName = this.getDeepHistoryVariableName(p.getContainer(), p);
        _builder.append((Object)_deepHistoryVariableName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("if (");
        _builder.append("states");
        _builder.append("[");
        _builder.append(parentId);
        _builder.append("].");
        _builder.append("previousStates");
        _builder.append("[");
        _builder.append((Object)regionIndex);
        _builder.append("] != ");
        _builder.append("STATE_MAX");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("//restore active sub-state of ");
        String _name = p.getContainer().getState().getName();
        _builder.append(_name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _deepHistoryVariableName_1 = this.getDeepHistoryVariableName(p.getContainer(), p);
        _builder.append((Object)_deepHistoryVariableName_1, "\t");
        _builder.append(" = ");
        _builder.append("states", "\t");
        _builder.append("[");
        _builder.append(parentId, "\t");
        _builder.append("].");
        _builder.append("previousStates", "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append("states", "\t");
        _builder.append("[");
        CharSequence _deepHistoryVariableName_2 = this.getDeepHistoryVariableName(p.getContainer(), p);
        _builder.append((Object)_deepHistoryVariableName_2, "\t");
        _builder.append("].");
        _builder.append("entry", "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (State a : atomicsWithTimeEvent) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_1 = a.getName().toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append("_ID == ");
            CharSequence _deepHistoryVariableName_3 = this.getDeepHistoryVariableName(p.getContainer(), p);
            _builder.append((Object)_deepHistoryVariableName_3, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a, "true");
            _builder.append((Object)_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("setFlag", "\t");
        _builder.append("(");
        CharSequence _deepHistoryVariableName_4 = this.getDeepHistoryVariableName(p.getContainer(), p);
        _builder.append((Object)_deepHistoryVariableName_4, "\t");
        _builder.append(", ");
        _builder.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t");
        _builder.append(", true);");
        _builder.newLineIfNotEmpty();
        boolean _hasElements_1 = false;
        for (State comp : subCompositeStates) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_2 = comp.getName().toUpperCase();
            _builder.append(_upperCase_2, "\t");
            _builder.append("_ID == ");
            CharSequence _deepHistoryVariableName_5 = this.getDeepHistoryVariableName(p.getContainer(), p);
            _builder.append((Object)_deepHistoryVariableName_5, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            String _generateRestoreString = this.generateRestoreString(comp, p);
            _builder.append(_generateRestoreString, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//for the first time, the history should be initialized");
        _builder.newLine();
        int _size = p.getOutgoings().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, ((Transition)IterableExtensions.head((Iterable)p.getOutgoings())).getTarget(), (Transition)IterableExtensions.head((Iterable)p.getOutgoings()));
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            String _regionMethodName = this.core.getRegionMethodName(p.getContainer());
            _builder.append(_regionMethodName, "\t");
            _builder.append("(");
            String _initialMacroName = this.core.getInitialMacroName(p.getContainer());
            _builder.append(_initialMacroName, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        String ret = _builder.toString();
        return ret;
    }

    private String generateRestoreString(State s, Pseudostate p) {
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && !it.isComposite();
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)p.getContainer().getSubvertices(), State.class), (Functions.Function1)_function);
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return PseudostateGenerator.this.core.states2TimeEvents.get(it) != null && !PseudostateGenerator.this.core.states2TimeEvents.get(it).isEmpty();
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_1);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// restore active-stub state of ");
        String _name = s.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        EList _regions = s.getRegions();
        for (Region r : _regions) {
            _builder.append("unsigned int ");
            CharSequence _deepHistoryVariableName = this.getDeepHistoryVariableName(r, p);
            _builder.append((Object)_deepHistoryVariableName);
            _builder.append(" = ");
            _builder.append("states");
            _builder.append("[");
            String _upperCase = s.getName().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_ID].");
            _builder.append("previousStates");
            _builder.append("[");
            int _indexOf = s.getRegions().indexOf((Object)r);
            _builder.append((Object)_indexOf);
            _builder.append("];");
            _builder.newLineIfNotEmpty();
            _builder.append("(this->*");
            _builder.append("states");
            _builder.append("[");
            CharSequence _deepHistoryVariableName_1 = this.getDeepHistoryVariableName(r, p);
            _builder.append((Object)_deepHistoryVariableName_1);
            _builder.append("].");
            _builder.append("entry");
            _builder.append(")();");
            _builder.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (State a : atomicsWithTimeEvent) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _upperCase_1 = a.getName().toUpperCase();
                _builder.append(_upperCase_1);
                _builder.append("_ID == ");
                CharSequence _deepHistoryVariableName_2 = this.getDeepHistoryVariableName(r, p);
                _builder.append((Object)_deepHistoryVariableName_2);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                CharSequence _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a, "true");
                _builder.append((Object)_generateActivateTimeEvent, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("setFlag");
            _builder.append("(");
            CharSequence _deepHistoryVariableName_3 = this.getDeepHistoryVariableName(r, p);
            _builder.append((Object)_deepHistoryVariableName_3);
            _builder.append(", ");
            _builder.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder.append(", true);");
            _builder.newLineIfNotEmpty();
            Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State it) {
                    return !(it instanceof FinalState) && it.isComposite();
                }
            };
            Iterable subCompositeStates = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)r.getSubvertices(), State.class), (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            boolean _hasElements_1 = false;
            for (State comp : subCompositeStates) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _upperCase_2 = comp.getName().toUpperCase();
                _builder.append(_upperCase_2);
                _builder.append("_ID == ");
                CharSequence _deepHistoryVariableName_4 = this.getDeepHistoryVariableName(r, p);
                _builder.append((Object)_deepHistoryVariableName_4);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                String _generateRestoreString = this.generateRestoreString(comp, p);
                _builder.append(_generateRestoreString, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        }
        return _builder.toString();
    }

    public CharSequence getDeepHistoryVariableName(Region r, Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = r.getState().getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = r.getName();
        _builder.append(_name_1);
        _builder.append("_");
        String _name_2 = p.getName();
        _builder.append(_name_2);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public String generateShallowHistory(Pseudostate p) {
        boolean _greaterThan_2;
        boolean _greaterThan_1;
        boolean _greaterThan;
        int regionIndex = p.getContainer().getState().getRegions().indexOf((Object)p.getContainer());
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && it.isComposite();
            }
        };
        Iterable subCompositeStates = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)p.getContainer().getSubvertices(), State.class), (Functions.Function1)_function);
        Pseudostate pseudoInitial = TransformationUtil.firstPseudoState((Region)p.getContainer(), (PseudostateKind)PseudostateKind.INITIAL_LITERAL);
        String _upperCase = p.getContainer().getState().getName().toUpperCase();
        String parentId = String.valueOf(_upperCase) + "_ID";
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState) && !it.isComposite();
            }
        };
        Iterable subAtomics = IterableExtensions.filter((Iterable)Iterables.filter((Iterable)p.getContainer().getSubvertices(), State.class), (Functions.Function1)_function_1);
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return PseudostateGenerator.this.core.states2TimeEvents.get(it) != null && !PseudostateGenerator.this.core.states2TimeEvents.get(it).isEmpty();
            }
        };
        Iterable atomicsWithTimeEvent = IterableExtensions.filter((Iterable)subAtomics, (Functions.Function1)_function_2);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unsigned int loc_ActiveId;");
        _builder.newLine();
        _builder.append("if (");
        _builder.append("states");
        _builder.append("[");
        _builder.append(parentId);
        _builder.append("].");
        _builder.append("previousStates");
        _builder.append("[");
        _builder.append((Object)regionIndex);
        _builder.append("] != ");
        _builder.append("STATE_MAX");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("loc_ActiveId = ");
        _builder.append("states", "\t");
        _builder.append("[");
        _builder.append(parentId, "\t");
        _builder.append("].");
        _builder.append("previousStates", "\t");
        _builder.append("[");
        _builder.append((Object)regionIndex, "\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//for the first time, the history should be initialized");
        _builder.newLine();
        int _size = p.getOutgoings().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)((Transition)IterableExtensions.head((Iterable)p.getOutgoings())));
            _builder.append(_transitionEffect, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("loc_ActiveId = ");
            String _upperCase_1 = ((Transition)IterableExtensions.head((Iterable)p.getOutgoings())).getTarget().getName().toUpperCase();
            _builder.append(_upperCase_1, "\t");
            _builder.append("_ID;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            String _transitionEffect_1 = TransformationUtil.getTransitionEffect((Transition)((Transition)IterableExtensions.head((Iterable)pseudoInitial.getOutgoings())));
            _builder.append(_transitionEffect_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("loc_ActiveId = ");
            String _upperCase_2 = ((Transition)IterableExtensions.head((Iterable)pseudoInitial.getOutgoings())).getTarget().getName().toUpperCase();
            _builder.append(_upperCase_2, "\t");
            _builder.append("_ID;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.append("states");
        _builder.append("[");
        _builder.append(parentId);
        _builder.append("].");
        _builder.append("actives");
        _builder.append("[");
        _builder.append((Object)regionIndex);
        _builder.append("] = loc_ActiveId;");
        _builder.newLineIfNotEmpty();
        boolean _hasElements = false;
        for (State comp : subCompositeStates) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _upperCase_3 = comp.getName().toUpperCase();
            _builder.append(_upperCase_3);
            _builder.append("_ID == loc_ActiveId) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            CharSequence _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex(comp, null);
            _builder.append((Object)_generateEnteringOnSubVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t\t\t");
        }
        _builder.append(" ");
        int _size_1 = IterableExtensions.size((Iterable)subCompositeStates);
        boolean bl2 = _greaterThan_1 = _size_1 > 0;
        if (_greaterThan_1) {
            _builder.append(" else { ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("(this->*");
        _builder.append("states", "\t");
        _builder.append("[loc_ActiveId].");
        _builder.append("entry", "\t");
        _builder.append(")();");
        _builder.newLineIfNotEmpty();
        boolean _hasElements_1 = false;
        for (State a : atomicsWithTimeEvent) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)" else ", "\t");
            }
            _builder.append("\t");
            _builder.append("if (");
            String _upperCase_4 = a.getName().toUpperCase();
            _builder.append(_upperCase_4, "\t");
            _builder.append("_ID == loc_ActiveId) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _generateActivateTimeEvent = this.core.generateActivateTimeEvent(a, "true");
            _builder.append((Object)_generateActivateTimeEvent, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("setFlag", "\t");
        _builder.append("(loc_ActiveId, ");
        _builder.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY", "\t");
        _builder.append(", true);");
        _builder.newLineIfNotEmpty();
        int _size_2 = IterableExtensions.size((Iterable)subCompositeStates);
        boolean bl3 = _greaterThan_2 = _size_2 > 0;
        if (_greaterThan_2) {
            _builder.append("}");
        }
        _builder.append("\t\t");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String generateChoice(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return _guard != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)p.getOutgoings(), (Functions.Function1)_function);
        boolean _hasElements = false;
        for (Transition out : _filter) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" else ", "");
            }
            _builder.append("if (");
            String _guard = this.core.getGuard(out);
            _builder.append(_guard);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, out.getTarget(), out);
            _builder.append(_generateBetweenVertex, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("else {");
        _builder.newLine();
        _builder.append("\t");
        Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return _guard == null;
            }
        };
        Transition t = (Transition)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)p.getOutgoings(), (Functions.Function1)_function_1));
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateBetweenVertex_1 = this.generateBetweenVertex((Vertex)p, t.getTarget(), t);
        _builder.append(_generateBetweenVertex_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    public List<Vertex> intersect(List<Vertex> l1, final List<Vertex> l2) {
        Functions.Function1<Vertex, Boolean> _function = new Functions.Function1<Vertex, Boolean>(){

            public Boolean apply(Vertex it) {
                return l2.contains(it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(l1, (Functions.Function1)_function));
    }

    public String generateEntryPoint(Pseudostate p) {
        Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getTarget();
            }
        };
        final List targets = IterableExtensions.toList((Iterable)ListExtensions.map((List)p.getOutgoings(), (Functions.Function1)_function));
        EObject _eContainer = p.eContainer();
        Functions.Function1<Region, Boolean> _function_1 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                int _size = PseudostateGenerator.this.intersect(IterableExtensions.toList(PseudostateGenerator.this.core.allSubVertexes(it)), targets).size();
                return _size > 0;
            }
        };
        final List enteredRegions = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)((State)_eContainer).getRegions(), (Functions.Function1)_function_1));
        EObject _eContainer_1 = p.eContainer();
        Functions.Function1<Region, Boolean> _function_2 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                boolean _contains = enteredRegions.contains(it);
                return !_contains;
            }
        };
        Iterable defaultRegions = IterableExtensions.filter((Iterable)((State)_eContainer_1).getRegions(), (Functions.Function1)_function_2);
        StringConcatenation _builder = new StringConcatenation();
        EList _outgoings = p.getOutgoings();
        for (Transition out : _outgoings) {
            String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)out);
            _builder.append(_transitionEffect);
            _builder.newLineIfNotEmpty();
        }
        Functions.Function1<Region, Boolean> _function_3 = new Functions.Function1<Region, Boolean>(){

            public Boolean apply(Region it) {
                State _findInitialState = TransformationUtil.findInitialState((Region)it);
                return _findInitialState != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)defaultRegions, (Functions.Function1)_function_3);
        for (Region r : _filter) {
            String _regionMethodName = this.core.getRegionMethodName(r);
            _builder.append(_regionMethodName);
            _builder.append("(");
            String _initialMacroName = this.core.getInitialMacroName(r);
            _builder.append(_initialMacroName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        for (final Region r_1 : enteredRegions) {
            String _regionMethodName_1 = this.core.getRegionMethodName(r_1);
            _builder.append(_regionMethodName_1);
            _builder.append("(");
            Functions.Function1<Vertex, Boolean> _function_4 = new Functions.Function1<Vertex, Boolean>(){

                public Boolean apply(Vertex it) {
                    return r_1.allNamespaces().contains((Object)it);
                }
            };
            String _vertexMacroName = this.core.getVertexMacroName((Vertex)IterableExtensions.head((Iterable)IterableExtensions.filter((Iterable)targets, (Functions.Function1)_function_4)));
            _builder.append(_vertexMacroName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String generateExitPoint(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, ((Transition)IterableExtensions.head((Iterable)p.getOutgoings())).getTarget(), (Transition)IterableExtensions.head((Iterable)p.getOutgoings()));
        _builder.append(_generateBetweenVertex);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String generateFork(Pseudostate p) {
        try {
            boolean _not;
            Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getTarget();
                }
            };
            List targets = ListExtensions.map((List)p.getOutgoings(), (Functions.Function1)_function);
            StringConcatenation _builder = new StringConcatenation();
            String ret = _builder.toString();
            ArrayList<Vertex> exits = new ArrayList<Vertex>();
            ArrayList<Vertex> enters = new ArrayList<Vertex>();
            this.core.eventTransform.calculateExitsEnters((Transition)IterableExtensions.head((Iterable)p.getOutgoings()), exits, enters);
            Vertex cpEx = (Vertex)IterableExtensions.last(exits);
            Vertex _last = (Vertex)IterableExtensions.last(enters);
            State parent = (State)_last;
            boolean _isOrthogonal = parent.isOrthogonal();
            boolean bl = _not = !_isOrthogonal;
            if (_not) {
                throw new Exception("state machine is ill-formed");
            }
            String _ret = ret;
            StringConcatenation _builder_1 = new StringConcatenation();
            if (cpEx instanceof State) {
                String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
                _builder_1.append(_generateExitingSubStates);
                _builder_1.newLineIfNotEmpty();
            }
            _builder_1.append("// need to be concurrently executed");
            _builder_1.newLine();
            EList _outgoings = p.getOutgoings();
            for (Transition out : _outgoings) {
                String _transitionEffect = TransformationUtil.getTransitionEffect((Transition)out);
                _builder_1.append(_transitionEffect);
                _builder_1.newLineIfNotEmpty();
            }
            ret = String.valueOf(_ret) + _builder_1;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("states");
            _builder_2.append("[");
            String _upperCase = parent.getName().toUpperCase();
            _builder_2.append(_upperCase);
            _builder_2.append("_ID]");
            String pAttr = _builder_2.toString();
            String _ret_1 = ret;
            StringConcatenation _builder_3 = new StringConcatenation();
            String _generateChangeState = this.core.generateChangeState(parent);
            _builder_3.append(_generateChangeState);
            _builder_3.newLineIfNotEmpty();
            String _fptrCall = this.core.getFptrCall(pAttr, false, "entry");
            _builder_3.append(_fptrCall);
            _builder_3.append(";");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("// start activity of ");
            String _name = parent.getName();
            _builder_3.append(_name);
            _builder_3.append(" by calling setFlag");
            _builder_3.newLineIfNotEmpty();
            _builder_3.append("setFlag");
            _builder_3.append("(");
            String _upperCase_1 = parent.getName().toUpperCase();
            _builder_3.append(_upperCase_1);
            _builder_3.append("_ID, ");
            _builder_3.append("statemachine::ThreadFunctions::TF_DO_ACTIVITY");
            _builder_3.append(", true);");
            _builder_3.newLineIfNotEmpty();
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                for (Vertex target : targets) {
                    boolean _contains = this.core.allSubVertexes(r).contains(target);
                    if (!_contains) continue;
                    String _generateForkCall = this.core.concurrency.generateForkCall(r, true, this.core.getVertexMacroName(target));
                    _builder_3.append(_generateForkCall);
                    _builder_3.newLineIfNotEmpty();
                }
            }
            ret = String.valueOf(_ret_1) + _builder_3;
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateJoin(Pseudostate p) {
        StringConcatenation _builder = new StringConcatenation();
        String _generateBetweenVertex = this.generateBetweenVertex((Vertex)p, ((Transition)IterableExtensions.head((Iterable)p.getOutgoings())).getTarget(), (Transition)IterableExtensions.head((Iterable)p.getOutgoings()));
        _builder.append(_generateBetweenVertex);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

